*
*
*           A CLIPPER A86' OUTPUT PROGRAM WITH RAMPANT FEATURES
*
*               WHICH CAN SET UP OUTPUT TO THE SCREEN,
*
*               DISK, PRINTER, OR NOVELL NETWORK PRINTERS.
*
*           By Henry J. Franzoni III, with large code segments
*
*                   By John Kaster from his EXTNDB22.ARC
*
*
*
* The procedures below are divided into two groups:
*
* PRINTSET, CTLCODE, QUEUE, PRNTCODE ASKL, ASK2, BLOCKCLR, MESSAGE
* DOSBROWSE and SPOOL are procedures completely of my own code and
* divising, and here they are combined with OPCHOICE, PRINTON, PRINTOFF,
* SELEFILE, SHOWFILES, TITLE, BOXIT, CNTR(), FEXISTS(), DIV(),
* and FORMFEED which are modifications and adaptations of
* procedures and functions of the same names in
* John Kaster's EXTNDB22.PRG public domain library of
* Clipper procedures and functions.
*
* I would like to thank Mr. Kaster for contributing these procedures
* to the public domain.
*
* PRINTSET, CTLCODE, QUEUE, PRNTCODE and SPOOL are new improved versions of
* procedures present in my public domain file CLPNVLP2.ARC.
*
*                    OTHER SYSTEM REQUIREMENTS:
*
* The function ISPRINT() is presumed to exist in one form or another
* [ISPRINTER(), etc.], in your implemetation of Clipper even though
* it is not a standard function.  It merely tests the readyness of
* the device connected to COM1:
*
* ALLTRIM() is from EXTENDDB.PRG, Tom Rettig's public domain
* Clipper Function library. It is presumed you have this. If not,
* it merely trims the leading and trailing blanks from a field
* or memory variable. It is easy to code if you need to code it from
* scratch.
*
* The DOS environment area needs two variables to be initialized.
* STA and USER.
* The commands SET STA=%STATION, and SET USER=%Login_name
* should appear in the Novell system login file for all users;
* for now, dummy values will be initialized below.
*
!SET STA=1
!SET USER=HANK
*
* Comment out the above two lines when you do adapt your
* system login script.
*
* If the evironment is too small, use the SHELL=COMMAND /p/e:30
* type of statement in the config.sys file to increase your
* environment string space in DOS 3.1 and above.
*
* Also use DBU.lib at link time for the ASCAN() and ADIR()
* functions that the procedures below require.
*
*
*                Running the procedures:
*
*
* The idea is to run OPCHOICE and it will fill the variable
* OUTPUT with an N, D, P, or S depending on the chosen output as
* well as initialize the chosen output setting.
*
* DO OPCHOICE first.
*
* Then use PRINTON and PRINTOFF turn the output device on and off depending
* on your selection. The idea is to use DO PRINTON and DO PRINTOFF
* instead of SET PRINT ON and SET PRINT OFF in your code.
*
* Additionally you can set up the output to the choice you like
* and then run DOSBROWSE by typing Alt-X.
* DOSBROWSE looks for all the ".TXT" files in the current directory
* and allows you to type them to the selected ouput device.
* It just demonstrates the use of these procedures.
*
*
*
* CLIPPER is a trademark of the Nantucket Corp. and NOVELL NETWARE
* is a trademark of the Novell corp.  Extenddb.prg was placed in the
* public domain by Tom Rettig Associates Nov. 1 1985.
* Extndb22.prg was placed in the public domain by John Kaster
* Sometime after Nov. 1 1985, I don't know exactly when...
*
* This collection of programs is placed in the public domain Aug. 12th 1987
* by Henry J. Franzoni III, part of these programs were placed in the
* public domain at an earlier time by John Kaster.
*
* This program assumes you have Advanced Novell Netware 286 Ver. 2.0a
* and the Autumn'86 Clipper compiler.
* Novell Netware 86 ver. 4.61b has a maximum of three printers and
* certain spool and queue commands don't work. The code can be simplified
* to adapt it to Netware 86.
*
*
* The file PRINT.OBJ is the object file of this code.
*
*
* Variable and environment initialization begins below:
*
*
SET SCOREBOARD OFF
SET CONFIRM OFF
SET SAFETY OFF
SET TALK OFF
SET UNIQ OFF
SET EXCL OFF
PRIV USER,STA,ENLGON,ENLGOFF,SPLVAR,PRINTVAR
PRIV L1QON,L1QOFF,G1RAPHON,G1RAPHOFF,E1LITEON,E1LITEOFF,C1OMPRON,C1OMPROFF
PRIV LQON,LQOFF,GRAPHON,GRAPHOFF,ELITEON,ELITEOFF,COMPRON,COMPROFF,FRAME
PRIV LfArrow,RtArrow,CLfArrow,CRtArrow,UpArrow,DnArrow,PgUp,PgDn,CPgUp,CPgDn
PRIV CHome,CEnd,CtrlU,HelpKey,HomeKey,EndKey
PRIV FKey2,FKey3,FKey4,FKey5,FKey6,FKey7,FKey8,FKey9,FKey10
PRIV SFKey1,SFKey2,SFKey3,SFKey4,SFKey5,SFKey6,SFKey7,SFKey8,SFKey9,SFKey10
PRIV AFKey1,AFKey2,AFKey3,AFKey4,AFKey5,AFKey6,AFKey7,AFKey8,AFKey9,AFKey10
PRIV CFKey1,CFKey2,CFKey3,CFKey4,CFKey5,CFKey6,CFKey7,CFKey8,CFKey9,CFKey10
*
***** Declarations for special keys
*
HomeKey  = 1
EndKey   = 6
LfArrow  = 19
RtArrow  = 4
CRtArrow = 2
CLfArrow = 26
UpArrow  = 5
DnArrow  = 24
PgUp     = 18
PgDn     = 3
CPgUp    = 31
CPgDn    = 30
CHome    = 29
CEnd     = 23
CtrlU    = 21
HelpKey  = 28
FKey2    = -1
FKey3    = -2
FKey4    = -3
FKey5    = -4
FKey6    = -5
FKey7    = -6
FKey8    = -7
FKey9    = -8
FKey10   = -9
SFKey1   = -10 && Shifted function key definitions
SFKey2   = -11
SFKey3   = -12
SFKey4   = -13
SFKey5   = -14
SFKey6   = -15
SFKey7   = -16
SFKey8   = -17
SFKey9   = -18
SFKey10  = -19
CFKey1   = -20 && Ctrl function key definitions
CFKey2   = -21
CFKey3   = -22
CFKey4   = -23
CFKey5   = -24
CFKey6   = -25
CFKey7   = -26
CFKey8   = -27
CFKey9   = -28
CFKey10  = -29
AFKey1   = -30 && Alt function key definitions
AFKey2   = -31
AFKey3   = -32
AFKey4   = -33
AFKey5   = -34
AFKey6   = -35
AFKey7   = -36
AFKey8   = -37
AFKey9   = -38
AFKey10  = -39
*
*
USER=GETE("USER")       &&Used for Q command options
STA=GETE("STA")
*
*  Set up the color attributes below
*
PUBL MCOLO,MSCOLO,MCOLOR,FCOLOR,ECOLOR,ACOLOR,VCOLOR,OUTPUT
VCOLOR=IIF (ISCOLOR(), 'N/GR,N/G,N+,,W+/G','W+/N,U/W,N+,,I')
ECOLOR=IIF (ISCOLOR(), 'N/GR,GR+/B,N+,,GR+/R','W/N,N/W,N+,,U/W')
ACOLOR=IIF (ISCOLOR(), 'N/GR,N/B,N+,,GR+/B','W+/N,U/W,N+,,W+/N')
MCOLOR=IIF (ISCOLOR(), 'R+/N,BG/GR,N+,,G/N','W/N,U,N+,,')
MCOLO= IIF (ISCOLOR(), 'GR+/B,W+/R,N+,,RB+/G','W+/N,N/W,N+,,I')
MSCOLO=IIF (ISCOLOR(), 'GR+/B,W+/R,N+,,R/W','N/W,W/N,N,,I')
SET COLO TO &MSCOLO
CLEA
*
* You have options for invoking these procedures...
SET KEY 301 TO DOSBROWSE       && will set Alt-X to start DOSBROWSE
* Run DOSBROWSE AFTER RUNNING OPCHOICE
*
PUBL DUMMY1,DUMMY2,DUMMY3,AGAIN
AGAIN=.T.
DO WHILE AGAIN
DO OPCHOICE WITH DUMMY1,DUMMY2,DUMMY3    && will start opchoice
DO ASKL WITH 24,0,"Continue? ",AGAIN
ENDD
*
*
PROC DOSBROWSE          &&example of how to use OUTPUT variable
PARA DUM1,DUM2,DUM3
SAVE SCREEN
STOR SPAC(20) TO BROWSER
DO SELEFILE WITH "*.TXT",BROWSER,.N.,"Select file, <esc> to exit"
  IF ! EMPTY(BROWSER)
    STOR TRIM(BROWSER) TO BROWSER
    @ 24,0 SAY "Ctrl-S to start/stop scrolling"
      DO PRINTON
      IF OUTPUT='S'
        TYPE &BROWSER
      ELSE
        TYPE &BROWSER TO PRINT
      ENDI
      DO PRINTOFF
  ENDI
RESTORE SCREEN
RETU
*
*
PROCEDURE OPCHOICE
PARA W,X,Y
* Syntax:  DO OPCHOICE
* Notes.:  Determines where output is going: Disk, Printer, Screen,
*          Or Novell Network printers connected to the current file server
*          Assumes a public character variable called OUTPUT for other
*          procedures such as PrintOn, PrintOff, and FormFeed, Printset
*
PRIVATE ANSWER
ANSWER=0
@ 23,0 CLEA
@ 23,0  PROMPT 'Printer   ' MESSAGE 'Select output to the local printer'
@ 23,10 PROMPT 'Screen    ' MESSAGE 'Select output to the screen'
@ 23,20 PROMPT 'Disk      ' MESSAGE 'Select output to a disk file'
@ 23,30 PROMPT 'Network   ' MESSAGE 'Select output to the network spooler'
@ 23,40 PROMPT 'Quit      ' MESSAGE "Don't select an output device and quit"
MENU TO ANSWER
@ 23,0 CLEA
DO CASE
CASE ANSWER=1
  OUTPUT='P'
  SET PRINTER TO LPT1
CASE ANSWER=2
  OUTPUT='S'
  Pause=.F.
  @ 23,0 SAY 'Pause for each page (Y/N)? ' GET Pause
  READ
CASE ANSWER=3
  OUTPUT='D'
  * sets up the printer device to a disk file name after verifying
  * an overwrite if the file exists
  Cor=.N.
  File=space(20)
  DO SELEFILE WITH '*.TXT',File,.N.,'Select a file for output. "*" in filename for a new directory'
  IF ! EMPTY(File)
    SET PRINTER TO &File
  ELSE
    OUTPUT='S'
  ENDIF
CASE ANSWER=4
  OUTPUT='N'
  SET PRINTER TO LPT1
  DO PRINTSET WITH 20,0
ENDC
RETU
*
PROCEDURE PRINTOFF
* Syntax.: DO PRINTOFF
* Notes..: Assumes a public variable OUTPUT of type Character
* Default: OUTPUT = 'S'creen
*
IF TYPE('OUTPUT') # 'C'
  OUTPUT='S'
ENDIF
IF OUTPUT='S'
  WAIT
  CLEA
ELSE
  SET ALTERNATE OFF
  SET PRINT OFF
  SET PRINTER TO
  SET DEVICE TO SCREEN
  SET CONS ON
ENDIF
IF OUTPUT='N'
  @ 22,0 CLEA
  !ENDSPOOL
ENDI
OUTPUT='S'
RETURN
*
PROCEDURE PRINTON
* Syntax.: DO PRINTON
* Notes..: Assumes a public variable OUTPUT as type 'C' for "S"creen, "P"rinter,
*          or "D"isk
* Default: OUTPUT = 'S'creen
*
IF TYPE('OUTPUT') = 'U'
  PUBLIC OUTPUT
  OUTPUT='S'
ENDIF
IF TYPE('OUTPUT') # 'C'
  OUTPUT='S'
ENDIF
SET PRINT OFF
SET CONSOLE OFF
SET ALTERNATE OFF
OUTPUT=UPPE(OUTPUT)
  DO CASE
    CASE OUTPUT$'PN'
      IF ISPRINT()
        SET PRINT ON
        SET DEVICE TO PRINT
      ELSE
        ?? chr(7)
        @ 0,0 SAY 'Hit any key when the printer is ready. [Esc] for Screen output.'
        key=inkey(0)
          DO WHILE Key#27 .AND. (! ISPRINT())
            KEY=INKEY(0)
          ENDDO
        IF Key=27
          SET CONS ON
          OUTPUT='S'
          Pause=.T.
          @ 24,0 SAY 'Pause for each page (Y/N)? ' GET Pause
          READ
          @ 24,0
        ENDIF
          @ 0,0
      ENDIF
    CASE OUTPUT='D'
      SET PRINT ON
      SET DEVICE TO PRINT
    OTHE
      SET CONSOLE ON
    ENDCASE
RETURN
*
PROCEDURE FORMFEED
* Syntax:  DO FORMFEED
* Notes.:  Assumes a public variable OUTPUT declared as character
*
DO CASE
CASE OUTPUT='S'
  IF PAUSE
    DO CNTR WITH 'Hit a key'
    inkey(0)
  ENDIF
  CLEA
CASE OUTPUT = 'D'
  ?? chr(12)
CASE OUTPUT $ 'NP'
  EJEC
ENDC
RETU
*
PROC PRINTSET
PARA RR,CC
DO BLOCKCLR WITH RR,CC
STOR SPAC(10) TO PRINTVAR
STOR " " TO SPLVAR
DO PRNTCODE
  DO WHIL .T.
    DO ASK2 WITH RR,CC,"Printer: (0),(1),(2),(3),(4),(C)ancel,(S)pool or (Q)ueue control,(E)xit","CSQE01234",SPLVAR
      DO CASE
        CASE SPLVAR='S'
          DO SPOOL WITH RR,CC
        CASE SPLVAR='0'
          @ 20,0 CLEA
          !SPOOL /P0 NB C=1
          DO BLOCKCLR WITH RR,CC
          EXIT
        CASE SPLVAR='1'
          @ 20,0 CLEA
          !SPOOL /P1 NB C=1
          DO BLOCKCLR WITH RR,CC
          EXIT
        CASE SPLVAR='2'
          @ 20,0 CLEA
          !SPOOL /P2 NB C=1
          DO BLOCKCLR WITH RR,CC
          EXIT
        CASE SPLVAR='3'
          @ 20,0 CLEA
          !SPOOL /P3 NB C=1
          DO BLOCKCLR WITH RR,CC
          EXIT
        CASE SPLVAR='4'
          @ 20,0 CLEA
          !SPOOL /P4 NB C=1
          DO BLOCKCLR WITH RR,CC
          EXIT
        CASE SPLVAR='Q'
          DO QUEUE WITH RR,CC
        CASE SPLVAR='C'
          PRIV C1,C2,C3
          STOR " " TO C1
          DO ASK2 WITH RR+1,CC,"Delete (A)vailable jobs or (P)ending spooler job","AP",C1
            IF C1='P'
              @ RR,CC SAY " "
              !ENDSPOOL C
              WAIT
            ELSE
              STOR " " TO C2
              DO ASK2 WITH RR+2,CC,"Select printer queue to delete (0,1,2,3,4)?","01234",C2
              SAVE SCREEN
              @ 0,0 CLEA
              STOR " *.*" TO C3
              STOR C3+" /P"+C2+" " TO C3
              STOR C3+"U="+USER+" " TO C3
              STOR C3+" D" TO C3
              !Q &C3
              WAIT
              RESTORE SCREEN
            ENDI
          DO BLOCKCLR WITH RR,CC
        CASE SPLVAR='E'
          DO BLOCKCLR WITH RR,CC
          EXIT
        ENDC
    ENDD
RETU
*
PROC SPOOL
PARA RR,CC
PRIV SP1,SP2,SP3,SP4,SP5,SP6,SP7,SP8,SP9,SP10
STOR " " TO SP7
STOR "0" TO SP1,SP2
STOR .F. TO SP3,SP6,SP5,SP9,SP10
STOR SPAC(14) TO SP4
STOR "0  " TO SP8
  DO WHIL .T.
    DO BLOCKCLR WITH RR,CC
    DO ASK2 WITH RR,CC,"Select network printer (0,1,2,3,4) or (E)xit?","01234E",SP1
      IF SP1="E"
        DO BLOCKCLR WITH RR,CC
        RETU
      ENDI
    @ RR,CC SAY "Printer "+SP1+" selected."
    STOR " P"+SP1 TO SP7
    DO ASKL WITH RR+1,CC,"Show spooler settings only?",SP3
      IF SP3
        SAVE SCREEN
        @ 0,0 CLEA
        STOR SP7+" SH" TO SP7
        !SPOOL &SP7
        WAIT
        STOR " " TO SP7
        @ 0,0 CLEA
        RESTORE SCREEN
        RETU
      ENDI
    DO ASK2 WITH RR+1,CC,"Select number of copies 0-9, 0 for disk file only ","0123456789",SP2
    @ RR+1,CC SAY SP2+" copies selected."
    DO ASKL WITH RR+2,CC,"Create disk file? (Y/N)",SP3
      IF SP3
        @ RR+2,CC SAY "Enter filename (With drive identifier) for disk file" GET SP4 PICT 'A:AXXXXXXXXXXX'
        READ
        @ RR+2,CC SAY SPAC(80)
        @ RR+2,CC SAY "File name "+SP4+" selected."
      ENDI
    DO ASKL WITH RR+3,CC,"Alter default form type in printer? (Y/N)",SP10
      IF SP10
        @ RR+3,CC SAY "Enter form type 0-255 or <cr> for 0, the default form " GET SP8 PICT '999'
        READ
      ENDI
    DO ASKL WITH RR+4,CC,"Add form feed after printing job (Y/N)?",SP9
    DO ASKL WITH RR+4,CC,"Execute this spooler command (Y/N)?",SP5
      IF SP5
       EXIT
      ENDI
  ENDD
STOR SP7+" NB" TO SP7
STOR SP7+" C="+TRIM(SP2) TO SP7
STOR SP7+" F="+TRIM(SP8) TO SP7
  IF SP3
    STOR SP7+" CR="+TRIM(SP4) TO SP7
  ENDI
  IF SP9
    STOR SP7+" FF" TO SP7
  ELSE
    STOR SP7+" NFF" TO SP7
  ENDI
DO BLOCKCLR WITH RR,CC
@ RR,CC SAY " "
!SPOOL &SP7
DO BLOCKCLR WITH RR,CC
DO ASKL WITH RR,CC,"Add extra printer control codes (Y/N)?",SP6
  IF SP6
    DO CTLCODES WITH RR,CC
  ENDI
RETU
*
PROC QUEUE
PARA RR,CC
PRIV Q1,Q2,Q3,Q4,Q5,Q6,Q7
STOR SPAC(12) TO Q1
STOR USER TO Q5
STOR STA TO Q4
STOR "0" TO Q2
STOR " " TO Q3
STOR .F. TO Q6,Q7,Q8
  DO WHIL .T.
    DO BLOCKCLR WITH RR,CC
    DO ASK2 WITH RR,CC,"Select printer queue number 0,1,2,3,4 or (E)xit?","01234E",Q2
      IF Q2="E"
        DO BLOCKCLR WITH RR,CC
        RETU
      ENDI
    @ RR,CC SAY "Printer queue "+Q2+" selected."
    @ RR+1,CC SAY "Select files: enter <filespec> , print job #, or <cr> for all?" GET Q1 PICT 'XXXXXXXXXXXX'
    READ
    DO ASK2 WITH RR+2,CC,"Select files: (A)ll, (S)tation "+STA+" only, or (U)ser "+USER+" only?","SUA",Q3
      DO CASE
        CASE Q3='S'
          STOR "ST="+Q4 TO Q3
          @ RR+2,CC SAY "Files from station number "+Q4+" selected."
        CASE Q3='U'
          STOR "U="+TRIM(Q5) TO Q3
          @ RR+2,CC SAY "Files from user "+TRIM(Q5)+" selected."
        CASE Q3='A'
          @ RR+2,CC SAY "All available files selected."
          Q3=' '
      ENDC
    DO ASKL WITH RR+4,CC,"Delete these files from the queue (Y/N)?",Q6
    DO ASKL WITH RR+4,CC,"Do you want a detailed file list (Y/N)?",Q7
    DO ASKL WITH RR+4,CC,"Do it all now (Y/N)?",Q8
      IF Q8
        EXIT
      ENDI
  ENDD
  IF .NOT. EMPTY(Q1)
    Q1=" "+TRIM(Q1)+" "
  ELSE
    Q1=" "
  ENDI
    Q1=Q1+"/P="+Q2
  IF .NOT. EMPTY(Q3)
    Q1=Q1+" "+Q3
  ENDI
  IF Q6
    Q1=Q1+" D"
  ENDI
  IF .NOT. Q7
    Q1=Q1+" NL"
  ENDI
SAVE SCREEN
@ 0,0 CLEA
!Q &Q1
WAIT
RESTORE SCREEN
DO BLOCKCLR WITH RR,CC
RETU
*
PROC CTLCODES              && ISSUES CONTROL CODES TO PRINTERS
PARA RR,CC                 && ONLY TWO PRINTERS HERE ADD MORE YOURSELF...
DO BLOCKCLR WITH RR,CC     && EXTEND CASE STRUCTURE FOR ADDITIONAL CHOICES
VALU='E'
  DO CASE
    CASE SP1="1"
    @ RR,CC SAY '(1) Letter quality on                  (2) Letter quality off'
    @ RR+1,CC SAY '(3) Graphic characters on              (4) Graphic characters off'
    @ RR+2,CC SAY '(5) 20 chars. per inch on              (6) 20 chars. per inch off'
      DO WHIL .T.
        @ RR+3,CC SAY '(7) 17 chars. per inch on              (8) 17 chars. off {(E)xit } -> ' GET VALU PICT '@! X'
        READ
          DO CASE
            CASE VALU='1'
              PRINTVAR=L1QON
            CASE VALU='2'
              PRINTVAR=L1QOFF
            CASE VALU='3'
              PRINTVAR=G1RAPHON
            CASE VALU='4'
              PRINTVAR=G1RAPHOFF
            CASE VALU='5'
              PRINTVAR=E1LITEON
            CASE VALU='6'
              PRINTVAR=E1LITEOFF
            CASE VALU='7'
               PRINTVAR=C1OMPRON
            CASE VALU='8'
               PRINTVAR=C1OMPROFF
            CASE VALU='E'
               EXIT
            OTHE
               LOOP
          ENDC
        SET CONS OFF
        SET PRIN ON
        ?&PRINTVAR
        SET PRIN OFF
        SET CONS ON
      ENDD
    CASE SP1='0'
      @ RR,CC SAY '(1) Letter quality on                  (2) Letter quality off'
      @ RR+1,CC SAY '(3) 5 chars. per inch on               (4) 5 chars per inch off'
      @ RR+2,CC SAY '(5) 12 chars. per inch on              (6) 12 chars. per inch off'
        DO WHIL .T.
          @ RR+3,CC SAY '(7) 17 chars. per inch on              (8) 17 chars. off {(E)xit } -> ' GET VALU PICT '@! X'
          READ
            DO CASE
              CASE VALU='1'
                PRINTVAR=LQON
              CASE VALU='2'
                PRINTVAR=LQOFF
              CASE VALU='3'
                PRINTVAR=ENLGON
              CASE VALU='4'
                PRINTVAR=ENLGOFF
              CASE VALU='5'
                PRINTVAR=ELITEON
              CASE VALU='6'
                PRINTVAR=ELITEOFF
              CASE VALU='7'
               PRINTVAR=COMPRON
              CASE VALU='8'
               PRINTVAR=COMPROFF
             CASE VALU='E'
               EXIT
             OTHE
               LOOP
           ENDC
         SET CONS OFF
         SET PRIN ON
         ?&PRINTVAR
         SET PRIN OFF
         SET CONS ON
       ENDD
     OTHE
   ENDC
VALU=SPAC(20)
DO BLOCKCLR WITH RR,CC
RETU
*
PROC ASKL
PARA MLINE,MCOLUMN,MQUESTION,MANSWER
@ MLINE,MCOLUMN SAY SPAC(LEN(MQUESTION)+4)
STOR .F. TO MANSWER
@ MLINE,MCOLUMN SAY MQUESTION GET MANSWER PICT '@L '
READ
@ MLINE,MCOLUMN SAY SPAC(LEN(MQUESTION)+4)
RETU
*
PROC ASK2
PARA MLINE,MCOLUMN,MQUESTION,MCHOICES,MANSWER
@ MLINE,MCOLUMN SAY SPAC(LEN(MQUESTION)+4)
STOR " " TO MANSWER
  DO WHIL .NOT. MANSWER $ MCHOICES
    @ MLINE,MCOLUMN SAY MQUESTION GET MANSWER PICT "@! "
    READ
  ENDD
@ MLINE,MCOLUMN SAY SPAC(LEN(MQUESTION)+4)
RETU
*
PROC BLOCKCLR
PARA RR,CC
@ RR,CC SAY SPAC(80)
@ RR+1,CC SAY SPAC(80)
@ RR+2,CC SAY SPAC(80)
@ RR+3,CC SAY SPAC(80)
@ RR+4,CC SAY SPAC(80)
RETU
*
PROC PRNTCODE
LQON='CHR(27)+"I"+"2"'               && CODES ON IBM PROPRINTER
LQOFF='CHR(27)+"I"+"0"'              && NETWORK PRINTER 0
ELITEON='CHR(27)+":"'
ELITEOFF='CHR(27)+"I"+"0"'
COMPRON='CHR(15)'
COMPROFF='CHR(18)'
ENLGON='CHR(14)'
ENLGOFF='CHR(20)'
L1QON='CHR(27)+"x"+CHR(1)'
L1QOFF='CHR(27)+"x"+CHR(0)'
G1RAPHON='CHR(27)+CHR(109)+CHR(4)'   && CODES ON EPSON LX80
G1RAPHOFF='CHR(27)+CHR(109)+CHR(0)'  && NETWORK PRINTER 1
E1LITEON='CHR(27)+"M"+CHR(15)'
E1LITEOFF='CHR(27)+"P"+CHR(18)'
C1OMPRON='CHR(27)+CHR(15)'
C1OMPROFF='CHR(27)+CHR(18)'
E1NLGON='CHR(27)'
E1NLGOFF='CHR(27)'
RETU
*
* Add more printer definitions if you please here
* make up unique variable names to suit
*
PROCEDURE SHOWFILES
* Syntax:  DO SHOWFILES WITH [<Mask>],[<Array of Files>],[<# of Files>],[<Title>]
* Notes.:  Returns the list of files in <Array of Files>
*
PARA Mask,Files,Num,Title
IF PCOUNT()<1
  Mask='*.*'
ENDIF
IF TYPE('Mask')#'C'
  Mask='*.*'
ENDIF
IF PCOUNT()<2
  DECLARE FILES[ADIR(Mask)]
ENDIF
IF TYPE('FILES')#'A'
  DECLARE FILES[ADIR(MASK)]
ENDIF
IF PCOUNT()<3
  Num=ADIR(Mask,Files)
ENDIF
IF TYPE('Num')#'C'
  Num=ADIR(Mask,Files)
ENDIF
IF TYPE('Title')#'C'
  Title='Directory of '+trim(Mask)+' Files'
ENDIF
SET COLOR TO &MSCOLO
@ 0,0 CLEA
DO TITLE WITH Title
DO BOXIT WITH 3,0,5+DIV(Num-1,5),79
  FOR I = 1 to num
    @ 4+DIV(I-1,5),5+MOD(i-1,5)*14 SAY Files[I]
  NEXT
RETU

PROCEDURE SELEFILE
* Syntax:  DO SHOWFILES WITH [<Mask>],[<FName>],[<Must exist?>],[<Title>]
* Notes.:  Returns the name of the file selected.  Calls SHOWFILES
*
PARA Mask,Selected,MustExist,Title
PRIV Row,Col,LastLine,ValCon,Ext,Num,I,Prefix
IF PCOUNT()<1
  Mask='*.*'
ENDIF
IF TYPE('Mask')#'C'
  Mask='*.*'
ENDIF
Selected=Mask
IF PCOUNT()<3
  MustExist=.F.
ENDIF
IF TYPE('MustExist')#'L'
  MustExist=.F.
ENDIF
IF MustExist
  ValCon='Selected'
ELSE
  ValCon="''"
ENDIF
IF PCOUNT()<4
  Title='Directory of '+alltrim(Mask)+' files.'
ENDIF
DO WHIL '*' $ Selected
  Ext=''
  Mask=Selected
  IF ! '.*' $ Mask
    Ext=RIGHT(Mask,len(Mask)-AT('.',Mask))
  ENDIF
  DECLARE FILES[ADIR(Mask)]
  Num=0
  DO SHOWFILES WITH Mask,Files,Num,Title
  Insert=''
  DO CASE
  CASE '\' $ Mask
    p=len(mask)-2
    DO WHIL substr(mask,p,1)#'\'.AND.P>0
      p=p-1
    ENDDO
    IF P>0
      Insert=left(mask,p)
    ENDIF
  CASE ':' $ Mask
    p=len(mask)-2
    DO WHIL ( ! substr(mask,p,1) $ ':\').AND.P>0
      p=p-1
    ENDDO
    IF P>0
      Insert=left(mask,p)
    ENDIF
  ENDC
  I=1
  IF ! Empty(Selected)
    I=ASCAN(Files,Selected)
  ENDIF
  I=IF(I<1,1,I)
  IF DIV(Num,5)=1
    LastLine=1
  ELSE
    LastLine=DIV(Num,5)+1
  ENDIF
  @ 24,0 SAY 'File '
  SET COLO TO &MSCOLO
  Selected=Files[I]
  key=0
  DO WHIL key#13.AND.key#27.AND.Num>0
    SET COLOR TO &VCOLOR
    @ 24,5
    @ 24,5 SAY Insert+trim(Files[I])+space(60-len(Insert+trim(files[i])))
    SET COLO TO &ECOLOR
    @ 4+DIV(I-1,5),4+MOD(I-1,5)*14 SAY ''
    key=inkey(0)
    @ 4+DIV(I-1,5),4+MOD(I-1,5)*14 SAY ' '
    DO CASE
    Case Key=HelpKey
      SET COLOR TO &VCOLOR
      @ 0,0 SAY 'Move: arrows, [Home], [End]; [Enter] selects file, [Esc] to type in file'
    CASE Key=LfArrow
      i=IF(I>1,i-1,i)
    CASE Key=RtArrow
      i=IF(i<num,i+1,i)
    CASE Key=HomeKey
      i=1
    CASE Key=EndKey
      I=Num
    CASE Key=UpArrow
      i=IF(i-5>1,i-5,1)
    CASE Key=DnArrow
      i=if(I+5<Num,i+5,Num)
    CASE Key=13
      Selected=Files[I]
    ENDC
  ENDDO
  IF num>0
    Selected=Insert+trim(Files[I])+space(60-len(Insert+trim(files[i])))
  ELSE
    Selected=space(60)
  ENDIF
  SET COLOR TO &VCOLOR
  IF Key#13
    @ 24,5
    @ 24,5 GET Selected PICT '@K!' VALI FExists(&ValCon,Ext)
    READ
  ENDIF
ENDDO
RETU
*
PROC BOXIT
* Syntax.: DO BOXIT WITH <Top>, <Left>, <Bottom>, <Right>, <Border>, <Clear>
* Notes..: Creates a box at the above locations with <Border>
*
PARAMETERS Top,Left,Bottom,Right,Border,Clear
IF TYPE("Border")#"N"
  Border=1
ENDIF
IF TYPE("Right")#"N".OR.TYPE("Left")#"N".OR.TYPE("Top")#"N".OR.TYPE("Bottom")#"N"
  RETURN
ENDIF
DO CASE
CASE Border=0
  Bframe = "        "
CASE Border=2
  BFrame = "ͻȺ"
CASE Border=3
  BFrame = "͸Գ"
CASE Border=4
  BFrame = "ķӺ"
CASE Border=5
  BFrame = ""
CASE Border=6
  BFrame = ""
CASE Border=7
  BFrame = ""
CASE Border=8
  BFrame = ""
CASE Border=9
  BFrame = ""
CASE Border=10
  BFrame = ""
CASE Border=11
  BFrame = " Գ"
OTHE
  Bframe = "Ŀ"
ENDC
IF TYPE("Clear")="C"
  Bframe=Bframe+Clear
ENDIF
SET COLOR TO &ECOLOR
@ Top,left CLEA TO Bottom,Right
IF Border#0
  @ Top,left,bottom,right BOX Bframe
ENDIF
SET COLOR TO &MSCOLO
RETU
* EOP: Procedure BOXIT
*
PROCEDURE CNTR
* Syntax:  DO CNTR WITH <Text>, [<Line>]
* Notes.:  Centers <Text> on <Line>.  <Line> defaults to 0
*
PARA Text,Line
IF Pcount()<2
  Line=0
ENDIF
@ Line,40-len(text)/2 SAY text
RETU
*
PROCEDURE TITLE
* Syntax.: DO TITLE WITH <Title>, [<starting line>]
* Notes..: Clears line 1 and 2 and centers <Title> on line 1
*
PARAMETER Ttl,start
IF TYPE('Start')<>'N'
  Start=1
ENDIF
@ Start,0
@ Start+1,0
BFrame = ' Գ'
Cent=INT(len(Ttl)/2)
BotLine=INT(FCOUNT()/6+5)
SET COLOR TO &MSCOLO
@ Start,40-cent-2,Start+1,40+cent+IF(LEN(Ttl)/2=INT(len(Ttl)/2),1,2) BOX Bframe
SET COLOR TO &MCOLOR
@ Start,40-cent-1 SAY ' '+Ttl+' '
SET COLOR TO &VCOLOR
RETURN
*
PROC MESSAGE        &&prints message
PARA MLINE,MCOLUMN,MMESSAGE,DUR
SET CONS OFF
@ MLINE,MCOLUMN SAY CHR(7)+SPAC(LEN(MMESSAGE))
@ MLINE,MCOLUMN SAY MMESSAGE
CNTL=0
DUR=DUR+SECONDS()
DO WHIL CNTL<=DUR
CNTL=SECONDS()
ENDD
@ MLINE,MCOLUMN SAY SPAC(LEN(MMESSAGE)+1)
SET CONS ON
RETU
*
FUNCTION DIV
* Syntax:  DIV( <ExpN1>, <ExpN2> )
* Notes.:  Returns int(<ExpN1>/<ExpN2>) if <ExpN2>#0, otherwise 0
PARA ZN1,ZN2
IF PCOUNT()<2
  RETURN (0)
ENDIF
IF ZN2=0
  RETURN (0)
ENDIF
RETURN ( INT(ZN1/ZN2))
*
FUNC FExists
* Syntax: FExists ( <ExpC>, [<Ext>] )
* Return: .T. if <ExpC> empty or it exists, .F. if not
*
PARA File,Ext
IF PCOUNT()<1
  RETURN ( .T. )
ENDIF
IF PCOUNT()<2
  Ext='.'
ELSE
  IF TYPE('Ext')='C'
    Ext='.'+alltrim(Ext)
  ELSE
    Ext='.'
  ENDIF
ENDIF
IF ! EMPTY(File)
  RETURN ( File (IF(AT('.',File)=0,trim(File)+Ext,file)) )
ENDIF
RETURN ( .T. )
