* ------------------------------------------------------------------------
* Program......: EXPFNT87.PRG
* Author.......: Pepijn Smits.
* Version......: 1.0
* Date.........: May 1991.
* Copyright....: (c)1991, Pepijn Smits.
* Notes........: Clipper Summer '87 Demo program, demonstrates the use of
*                the EGA/VGA font routines.
*
* This does not DEMO the 512 chars mode, or other blocks.
* But it's good enough, I hope.
* Requires at least an EGA, as well as EGAFONTS.DBF and VGAFONTS.DBF.
* Be sure to Link also the EXPAND library with this file.
* (BTW: It is awful to convert Clipper5 code to Clipper87!)
* ------------------------------------------------------------------------
PUBLIC VGA		&& .t. if VGA, otherwise EGA.

Set ScoreBoard Off

Clear
If !EGAthere()
	Msg('Sorry, but this program requires at least an EGA adaptor',;
	    'Press any key to Quit.')
	Inkey(0)
	Clear
	QUIT
Endif

VGA = VGAthere()	&& Set VGA flag
PutHeader()
if VGA			&& Use appropriate database file
   Use VGAfonts
else
   Use EGAfonts
endif

Msg('[Enter]-Load Font, [Esc]-Quit, [F10]-View ASCII table',;
    '[Del]-Delete Font, [Ins]-Add blank, [F3]-Edit Name, [F4]-Edit Description',;
    '[F5]-Read font from File, [F6]-Pack databse')

@ 4,0 TO 19,79 

Declare h[1], f[1]
h[1] = [Fontname     Description]
f[1] = [FONTNAME+'   '+FONTINFO]

dbEdit(5,1,18,78,f,"User",'',h)

use
clear
quit

Function User
*
* dbEdit() trap
*
Parameter Mode,Ptr
Private cSave, RetVal

if Mode<>4		&& Only on Key exception.
	return 1
endif

cSave = SaveScreen(20,0,24,79)

retVal = 1

begin sequence
do case
case LastKey() = 27
  if ask('Quit the program?')
     retval = 0
  end
case Lastkey() = 13
  LoadFont(0,FONTDATA,if(VGA,16,14))
case Lastkey() = -9
  ShowAscii()
case Lastkey() = 7
  if ask('Delete font '+FontName+' from the database?')
     delete
     skip
     if eof()
        skip -1
     endif
  end
  retval = 2		&& redraw database
case lastkey()= 22
  Append Blank
  go Bottom
  retval = 2
case lastkey()= -2
  replace FONTNAME with Prompt('Enter new Name:',FONTNAME)
case lastkey()= -3
  replace FONTINFO with Prompt('Enter description:',FONTINFO)
case lastkey()= -4
  replace FONTDATA with MemoRead(Prompt('Enter file name of font to read',''))
case lastkey()= -5
  pack
  retval = 2
endcase
end

RestScreen(20,0,24,79,cSave)
return retval

Function ShowAscii
*
* Show the Complete ASCII table
*
private i,j,scr

save screen to scr

@ 4,0 clear
@ 4,0 TO 21,79
For i = 0 to 15 
	For j = 0 to 15
		@ 5+i,2+5*j say chr(i*16+j)
	next j
next i
Center(23,'Press any key to resume')
inkey(0)
restore Screen from Scr
return (0)

Function PutHeader
@ 0,0 to 3,79
center(1,if(VGA,'VGA','EGA')+' Text mode Fonts Demonstration')
center(2,'(Load fonts into the video adaptor from Fonts database)')
return (0)

* ---------------------------------------------------------------------------
*                    GENERAL PURPOSE ROUTINES
* ---------------------------------------------------------------------------
Function Msg
parameter s,t,v
* /* Put up to 3 messages on the bottom of the screen.. */
@ 20,0 clear
@ 20,0 to 21+pcount(),79
center(21,s)
if pcount() >= 2
   center(22,t)
endif
if pcount() >= 3
   center(23,v)
endif

Function Prompt
parameter s,x
private Orig
orig = Alltrim(x)
msg('','')
@ 21,1 say s
orig = orig + space(78 - len(orig))
@ 22,1 get orig
read
if LastKey() = 27
  break
Endif
return AllTrim(orig)

Function Center
parameter Row,S
@ Row, 40 - (len(s)/2) say s
return (0)

Function Ask
parameter s
private choice
msg(s,'')
@ 22,35 prompt " No " 
@ 22,40 prompt " Yes " 
choice = 1
Menu to Choice
if Choice = 0
   Break
Endif
Return (Choice=2)
