* ------------------------------------------------------------------------
* Program......: EXPFNT50.PRG
* Author.......: Pepijn Smits.
* Version......: 1.0
* Date.........: Dec 1990.
* Copyright....: (c)1990, Pepijn Smits.
* Notes........: Clipper 5.01 'Demo' program, demonstrates the use of
*                the EGA/VGA font routines.
*
* This does not DEMO the 512 chars mode, or other blocks.
* But it's good enough, I hope.
* It is also a geed Demo of typical usage of the MouseEdit() Function.
* ------------------------------------------------------------------------

#include "Inkey.ch"

PUBLIC VGA		// .t. if VGA, otherwise EGA (no EGA/VGA aborts demo)

VGA := init()		// check if machine at least EGA, maybe VGA.

clear
PutHeader()
if VGA			// Use appropriate database file
   Use VGAfonts
else
   Use EGAfonts
endif

Msg('[Enter]-Load Font, [Esc]-Quit, [F10]-View ASCII table',;
    '[Del]-Delete Font, [Ins]-Add blank, [F3]-Edit Name, [F4]-Edit Description',;
    '[F5]-Read font from File, [F6]-Pack databse')

@ 4,0 TO 19,79 

MouseEdit(5,1,18,78,;
      'Fontname     Description',{||FONTNAME+'   '+FONTINFO},{|i|User(i)})

use
clear
quit

Function User()
*
* This is the MouseTrap for the MouseEdit() call.
*
Local nRetKey := LastKey()
local cSave := SaveScreen(20,0,24,79)
begin sequence
do case
case nRetKey = K_ESC
  nRetKey := 32
  if ask('Quit the program?')
     nRetKey := K_ESC
  end
case Lastkey()=K_ENTER
  LoadFont(0,FONTDATA,if(VGA,16,14))
  nRetkey := 32
case Lastkey()=K_F10
  ShowAscii()
  nRetKey := 32
case Lastkey()=K_DEL
  if ask('Delete font '+FontName+' from the database?')
     delete
  end
  nRetkey := 2
case lastkey()=K_INS
  Append Blank
  go Bottom
  nRetKey := 2
case lastkey()=K_F3
  nRetkey := 32
  replace FONTNAME with Prompt('Enter new Name:',FONTNAME)
case lastkey()=K_F4
  nRetkey := 32
  replace FONTINFO with Prompt('Enter description:',FONTINFO)
case lastkey()=K_F5
  nRetkey := 32
  replace FONTDATA with MemoRead(Prompt('Enter file name of font to read',''))
case lastkey()=K_F6
  pack
  nRetKey := 2
endcase
end
RestScreen(20,0,24,79,cSave)
return(nRetKey)

Function ShowAscii
*
* Show the Complete ASCII table
*
local i,j
local scr
save screen to scr

@ 4,0 clear TO 22,79
@ 4,0 TO 22,79
@ 23,0 Clear
@ 23,0 say "Press any key to resume"

For i = 0 to 15 
	For j = 0 to 15
		@ 5+i,3+5*j say chr(i*16+j)
	next j
next i

MouseKey()
restore Screen from Scr
return (nil)

Function Init
*
* Check if EGA/VGA, if Not quit.
*
Local VGA
if EGAthere()
   * EGA or VGA allright, maybe VGA?
   VGA := VGAthere()
else
   ?? 'Sorry, but you need an EGA or a VGA adaptor to run this program.'
   quit
endif
return (VGA)

Function PutHeader
@ 0,0 to 3,79
center(1,if(VGA,'VGA','EGA')+' Text mode Fonts Demonstration')
center(2,'(Load fonts into the video adaptor from Fonts database)')
return(NIL)


* ---------------------------------------------------------------------------
*                    GENERAL PURPOSE ROUTINES
* ---------------------------------------------------------------------------

Function Msg(s,t,v)
/* Put up to 3 messages on the bottom of the screen.. */
@ 20,0 clear
@ 20,0 to 21+pcount(),79
center(21,s)
if pcount() >= 2
   center(22,t)
endif
if pcount() >= 3
   center(23,v)
endif

Function Prompt(s,orig)
/* prompt the user for input */
msg('','')
@ 21,1 say s
orig := orig + space(78 - len(orig))
s := MouseGet(22,1,orig)
if LastKey() = K_ESC
  break
End
return AllTrim(S)

Function Center(Row,S)
@ Row, 40 - (len(s)/2) say s
return (NIL)

Function Ask(s)
local choice
local A := { { 22, 35, " No " }, { 22 ,41, " Yes " } }
@ 20,0 clear
@ 20,0 to 23,79
center(21,s)
Choice = MouseMenu(a)
if Choice = 0
   Break
Endif
Return ( Choice==2 )
