; ------------------------------------------------------------------------
; File........:	CPU.ASM
; Author......:	Pepijn Smits
; Date........:	July 1994
; Copyright...:	(c)1994 by Softwarebureau Pepijn Smits
; Assembler...:	Microsoft Assembler (MASM) v5.10
; Notes.......:	CA-Clipper 5.2x Assembly code for CPU() Function.
; ------------------------------------------------------------------------
; Syntax in Clipper:
;      
;	CPU()	--> nCPU
;
;	nCPU can be one of
;
;	1	->	8088 or 8086 or 80186 based computer
;	2	->	80286 based computer
;	3	->	i386 based computer
;	4	->	i486 based computer
;	5	->	Pentium based computer
;
; The ASM code to identify the 8088/8086/80286/i386/i486 CPUs is based
; on various anonymous sources and some research of my own. The original
; code was apparently released by Intel itself.
;
; The code to identify the Pentium is based on a public domain routine
; from Michael Holin (no adres or CIS ID known), I have nibbled it a bit
; so it will work with Clipper.
; ------------------------------------------------------------------------
PUBLIC	CPU
EXTRN	__RETNI:FAR

CPUCODE		segment 'CODE'
ASSUME		cs:CPUCODE

CPU		PROC	FAR
		call	GETCPU
		cmp	ax,4
		jne	CPU_EXIT
		call	PENTIUM
		add	ax,4
CPU_EXIT:	push	ax
		call	__RETNI
		pop	ax
		ret
CPU		ENDP

getcpu  proc    near			; returns 1..4 in AX (80088 thru 486)
        pushf                           ; save copy of flags and
        push    bx                      ; other affected registers
        push    cx
        pushf                           ; now try to clear bits 12-15
        pop     ax                      ; of CPU flags
        and     ax,0fffh
        push    ax                      ; set modified CPU flags
        popf
        pushf
        pop     ax                      ; get flags again
        and     ax,0f000h               ; if bits 12-15 are still       
        cmp     ax,0f000h               ; set, this is 8086/88
        jne     cpu1                    ; jump, not 8086/88
        mov     ax,1                    ; set AX = 86/88 CPU type
        jmp     short cpux              ; and exit

cpu1:   or      ax,0f000h               ; must be 286 or later, 
        push    ax                      ; now try to set bits 12-15
        popf                            ; of CPU flags
        pushf
        pop     ax                      ; if bits 12-15 can't be
        and     ax,0f000h               ; set, this is a 286
        jnz     cpu2                    ; jump, not 80286
        mov     ax,2                    ; set AX = 286 CPU type
        jmp     short cpux              ; and exit

; We've got to enable 386 instructions here!
; Is OK: as it is at least a 386 when we get here!

.386c	

cpu2:   mov     bx,sp                   ; 386 or later, save SP
        and     sp,not 3                ; avoid stack alignment fault
        pushfd                          ; get value of EFLAGS
        pop     eax
        mov     ecx,eax                 ; save copy of EFLAGS 
        xor     eax,40000h              ; flip AC bit in EFLAGS
        push    eax                     ; try and force EFLAGS
        popfd
        pushfd                          ; get back EFLAGS value
        pop     eax
        mov     sp,bx                   ; restore old stack pointer
        xor     eax,ecx                 ; can AC bit be changed?
        jnz     cpu3                    ; no, jump, not a 386
        mov     ax,3                    ; set AX = 386 CPU type
        jmp     short cpux              ; and exit

cpu3:   mov     ax,4                    ; set AX = 486 CPU type 

cpux:   pop     cx                      ; restore registers
        pop     bx
        popf                            ; restore original flags

	ret
getcpu  endp

pentium   proc   near          ; returns 0 or 1 in AX (1 when pentium)
          cli                  ; Disable ints
          mov    ebx,esp       ; Save SP
          and    esp,0FFFCh    ; Round SP to nearest DWORD
          pushfd               ; Push D Flag regs..
          pop    eax           ; And put'em in AX
          mov    ecx,eax       ; And in CX
          xor    eax,1 shl 21  ; "Turn" the ID bit
          push   eax           ; And try to move this 
          popfd                ; into the Flags
          pushfd               ; Put the Flags in eax again
          pop    eax           ; here..
          push   ecx           ; restore orig flags..
          popfd                ; 
          xor    eax,ecx       ; Test the bits
          shr    eax,21        ; We're only interested in bit 21
          and    eax,1h        ; all other 0
          mov    esp,ebx       ; Restore SP
          sti                  ; Interrupts on again
          ret                  ; Return to caller
pentium   endp

CPUCODE		ENDS
		END
