PUBLIC   __CBALL

EXTRN    __PARINFO:FAR
EXTRN    __PARCLEN:FAR
EXTRN    __PARC:FAR
EXTRN    __PARNI:FAR
EXTRN    __RETCLEN:FAR
EXTRN    __RETNI:FAR

SEGMENT  _CLIPBIT  WORD      PUBLIC    "CODE"
         ASSUME    CS:_CLIPBIT

PROC     __CBALL   FAR

         PUSH      BP                        ; Save BP
         MOV       BP,SP                     ; Set up stack reference
         SUB       SP,12                     ; Create local vars on stack
         MOV       [WORD PTR BP - 2],DX      ; Load instruction sequence into
         MOV       [WORD PTR BP - 4],AX      ; local variable
         MOV       [WORD PTR BP - 6],0       ; Initialize return value
         LEA       AX,[BP - 4]               ; Get IP of bit operation code
         MOV       [WORD PTR BP - 12],AX     ; Store in local var
         MOV       [WORD PTR BP - 10],SS     ; Store CS of bit op code

         XOR       AX,AX                     ; Prepare to count params
         PUSH      AX                        ; Save on stack
         CALL      __PARINFO                 ; Call parameter info routine
         ADD       SP,2                      ; Realign stack
         MOV       BX,2                      ; Param count should be 2
         CMP       [BYTE PTR BP - 4],0F7h    ; Unless NOT or NEG requested
         JNE       HOWMANY                   ; If not, don't worry
         DEC       BX                        ; NOT and NEG use only one param
HOWMANY: CMP       AX,BX                     ; See if two parameters passed
         JNE       DONE_N                    ; If not, return zero

         CMP       [BYTE PTR BP - 4],0F7h    ; See if NOT or NEG requested
         JE        TEST1                     ; If so, no second param

TEST2:   MOV       AX,2                      ; Prepare to test second param
         PUSH      AX                        ; Save on stack
         CALL      __PARINFO                 ; Call parameter info routine
         ADD       SP,2                      ; Realign stack
         TEST      AX,2                      ; See if parameter is numeric
         JZ        DONE_N                    ; If not, return zero

TEST1:   MOV       AX,1                      ; Prepare to test first param
         PUSH      AX                        ; Save on stack
         CALL      __PARINFO                 ; Call parameter info routine
         ADD       SP,2                      ; Realign stack
         TEST      AX,3                      ; See if character or numeric
         JZ        DONE_N                    ; If not, return zero

WHICH:   TEST      AX,1                      ; See if character
         MOV       AX,1                      ; Specify first parameter
         PUSH      AX                        ; Save on stack
         JNZ       GET_C                     ; If not, use __PARC
         
GET_N:   CALL      __PARNI                   ; Get param as integer
         MOV       [WORD PTR BP - 8],OFFSET _CLIPBIT:DONE_N
                                             ; Store offset of return handler
         JMP       SHORT GET_2               ; Skip over __PARC call

GET_C:   CALL      __PARC                    ; Get param as character
         MOV       ES,DX                     ; Put segment portion into ES
         MOV       BX,AX                     ; Put offset portion into BX
         MOV       AX,[WORD PTR ES:BX]       ; Load value into AX
         MOV       [WORD PTR BP - 8],OFFSET _CLIPBIT:DONE_C
                                             ; Store offset of return handler

         CMP       [BYTE PTR BP - 4],0F7h    ; See if NOT or NEG requested
         JE        MANIP                     ; If so, no second param

GET_2:   ADD       SP,2                      ; Realign stack
         MOV       [WORD PTR BP - 6],AX      ; Put param into local var
         MOV       AX,2                      ; Specify second param
         PUSH      AX                        ; Save on stack
         CALL      __PARNI                   ; Retrieve second parameter
         ADD       SP,2                      ; Realign stack
         MOV       CX,AX                     ; In case of shift or rotate

MANIP:   CALL      [DWORD PTR BP - 12]       ; Execute bit instruction
         JMP       [WORD PTR BP - 8]         ; Jump to return handler

DONE_N:  PUSH      [WORD PTR BP - 6]         ; Put return value on stack
         CALL      __RETNI                   ; Return value to Clipper app
         JMP       SHORT EXIT                ; Go to exit handler

DONE_C:  MOV       AX,2                      ; Length of string
         PUSH      AX                        ; Save on stack
         LEA       AX,[WORD PTR BP - 6]      ; Get address of return value
         PUSH      SS                        ; Segment of return value
         PUSH      AX                        ; Offset of return value
         CALL      __RETCLEN                 ; Return value to Clipper app

EXIT:    MOV       SP,BP                     ; Reset stack pointer
         POP       BP                        ; Restore BP
         RETF                                ; Return to application

ENDP     __CBALL
ENDS     _CLIPBIT
END
