
* Program..: MATHDEMO.PRG     DEMO PROGRAM FOR MATH FUNCTIONS
* Author...: MAURICE J. HALMOS
* Date.....: 8/20/89
* Notice...: Copyright (c) 1989, MAURICE J. HALMOS, All Rights Reserved
* Notes....:                     Video-Comp Electronics
* Revised..: 8/20/89
* Revised..: 5/23/92


clear

fsingle="Ŀ"
fdouble="ͻȺ"

text

                                Welcome to  
                            CLIPMATH Ver: 1.1

               This is a demo program to show some of the
                    features of the CLIPMATH library

    The library is written in C and contains,

         8 -  Trigonometric functions   (sin(x), cos(x), tan(x),...)

         7 -  Power functions           (exp(x), sinh(x), log(x),...)

         6 -  Special Bessel functions  (Jn(x), Yn(x),...)

         5 -  General math functions    (sqrt(x), mod(x,y), ...)

         5 - Financial functions        (PMT, amort, present value,...)

  These functions allow you to quickly calculate values using the speed
  of C.  The library is compatible with CLIPPER summer 87 and other
  third party libraries.

endtext
@1,23,4,48 box fdouble
@7,2,19,77 box fsingle
@24,1 say""
wait
clear

text






                                Attention users of 
                                    CLIPGRAF
                           the CLIPPER Graphics library


      This math library is fully compatible with CLIPGRAF.  You can now
      quickly calculate sine and cosines to generate fast arcs and pies.

      If you are a registered user of the graphics library, you get
      a $5 discount from the registration fee of CLIPMATH.


endtext
@ 4,2,19,78 box fsingle
@ 5,24,11,57 box fdouble
@24,1 say ""
wait
clear
m_init()

********************************  TRIG - BESSEL PLOT  *******************
clear
ymax=1.1
@ (1-1/ymax)*12-1,9,(1+1/ymax)*12+1,71 box fsingle
@ 14,9,14,71 box fsingle
@ 2,40-17 say 'Trigonometric and Bessel Functions'
@ 1,40-19,3,40+19 box fdouble
*
* Just for illustration, I define the mplot function at the end of the program.
* it is not very fast, but it serves its purpose.
*
for n=0.0 to 60.0
  expm=m_exp(-n/30)
  mplot(m_sin(n/7)*expm/ymax-.2,n+10,"*")
  mplot(m_j0(n/7)/ymax-.2,n+10,"")
next
@8,30 say 'sin(x)*exp(-x)'
@19,20 say 'Bessel J0(x)'
@23,1 say ""
wait

**********************  FINANCIAL CALCULATOR  *************************
CLEAR
prin=6300
intr=16.25
nyears=3
mpay=222.25
****                                 ***********                **********
@ 2,30 say "FINANCIAL CALCULATOR"
@ 1,28,3,51 BOX fdouble
@ 5,10,23,70 box fsingle
@ 7,40-11 say "LOAN PAYMENT CALCULATOR"
@ 15,40-7 say "Monthly Payment"
@ 16,30,20,50 box fdouble

again=.t.
do while again
  @ 10,40-11 SAY "Principal = $" get prin picture "999,999.99"
  @ 11,40-5 say "APR = %" get intr picture "99.99"
  @ 12,40-17 say "Number of Years =  " get nyears picture "99"
  read
*            
*   Print result,
*   
  @ 18,40-5 say m_pmt(prin,intr/1200,nyears*12) picture "$999,999.99"
  @ 22,40-3 say "AGAIN " get again
  read
enddo
clear

*******************************  FV *******************************
nmonth=nyears*12
@ 2,30 say "FINANCIAL CALCULATOR"
@ 1,28,3,51 BOX fdouble
@ 5,10,23,70 box fsingle
@ 7,40-11 say "FUTURE VALUE CALCULATOR"
@ 15,40-11 say "Value at End of Period"
@ 16,30,20,50 box fdouble

again=.t.
do while again
  @ 10,40-22 SAY "Monthly Installments = $" get mpay picture "9,999.99"
  @ 11,40-5 say "APR = %" get intr picture "99.99"
  @ 12,40-18 say "Number of Months =  " get nmonth picture "9999"
  read

  @ 18,40-5 say m_fv(mpay,intr/1200,nmonth) picture "$999,999.99"
  @ 22,40-3 say "AGAIN " get again
  read
enddo
clear

*******************************  PV *******************************
@ 2,30 say "FINANCIAL CALCULATOR"
@ 1,28,3,51 BOX fdouble
@ 5,10,23,70 box fsingle
@ 7,40-11 say "PRESENT VALUE CALCULATOR"
@ 15,40-20 say "Present Value (amount of loan to pay off)"
@ 16,30,20,50 box fdouble

again=.t.
do while again
  @ 10,40-22 SAY "Monthly Installments = $" get mpay picture "9,999.99"
  @ 11,40-5 say "APR = %" get intr picture "99.99"
  @ 12,40-18 say "Number of Months =  " get nmonth picture "9999"
  read

  @ 18,40-5 say m_pv(mpay,intr/1200,nmonth) picture "$999,999.99"
  @ 22,40-3 say "AGAIN " get again
  read
enddo
clear


*******************************  SF *******************************
@ 2,30 say "FINANCIAL CALCULATOR"
@ 1,28,3,51 BOX fdouble
@ 5,10,23,70 box fsingle
@ 7,40-11 say "SINKING FUND CALCULATOR"
@ 15,40-14 say "Monthly Instalments Required"
@ 16,30,20,50 box fdouble

again=.t.
do while again
  @ 10,40-22 SAY "  Final Goal Desired = $" get prin picture "999,999.99"
  @ 11,40-5 say "APR = %" get intr picture "99.99"
  @ 12,40-18 say "Number of Months =  " get nmonth picture "9999"
  read

  @ 18,40-5 say m_sf(prin,intr/1200,nmonth) picture "$999,999.99"
  @ 22,40-3 say "AGAIN " get again
  read
enddo
clear


*
*       END of demonstration
*

text
     Remember:
     ͻ
                                  CLIPMATH                             
                                by VideoSoft                           
                               Serial #1000002                         
                                 Version 1.1                           
                 Copyright (c) Video-Comp Electr.  1989                
                                                                       
      This is a shareware program.  As such, it may be freely copied   
      and distributed for evaluation.                                  
      If you would like to use it, you must purchase a license.  One   
      license per used copy is required.                               
      Licenses cost $15.  Include your name and address along with the 
      serial number above.                                             
                                                                       
      Send to:                                                         
                VideoSoft/Video-Comp Electr.                           
                Maurice J. Halmos                                      
                15000 Archwood St.                  PRESS ANY KEY...   
                Van Nuys, CA 91405  USA                                
     ͼ

     This screen will not appear the first time you use CLIPMATH if you
     register.
endtext
@24,1 SAY ""
WAIT

*
*  Definition of the m plot function
*

function mplot
PARAM y,x,dot
@(1-y)*12,x say dot
return .t.


