/*********************************************************************
CLIPMAKE. This Turbo C program is a make utility for Clipper placed in
the public domain by:
                      M.J. Magan
                      Pastoor van Arsplein 15
                      5622 CH Eindhoven
                      The Netherlands

Run CLIPMAKE without parameters for an explanation of the syntax and use.
Example: The files MODULE1.CLP and MODULE2.CLP contain a list of programs
to be compiled by Clipper. A batch file that will recompile the modules
only if necessary (if one of the program files has been changed since
the last compilation) could be:

     echo off
     clipmake module1
     if errorlevel 2 goto end
     if errorlevel 1 goto skip1
     clipper @module1
     :skip1
     clipmake module2
     if errorlevel 2 goto end
     if errorlevel 1 goto skip2
     clipper @module2
     :skip2
     plink86 file module1,module2
     :end

*********************************************************************/

# include <stdio.h>
# include <dir.h>

int argc;
char *argv[2], *env[2];
main(int argc, char *argv[])
{
  struct ffblk ffblk;
  char clpname[80], prgname[80];
  int found;
  unsigned int objtime, objdate;
  FILE *ptr;

  /* Check if a command line parameter has been specified */
  if (argc<2) {
    printf("\nCLIPMAKE, the make utility for Clipper. (C) 1987 M.J. Magan\n\n");
    printf("Syntax: CLIPMAKE <filename.CLP>        ");
    printf("Do not include the .CLP extension.\n\n");
    printf("DOS error level returned:\n");
    printf("0 = One or more .PRG files newer than the .OBJ file or .OBJ file does not exist\n");
    printf("1 = .OBJ file newer than all .PRG files\n");
    printf("2 = Error (File not found)\n\n");
    exit(2);
  }

  /* Get Date and Time of object file */
  strcpy(clpname,argv[1]);
  strcat(clpname,".OBJ");
  found = !findfirst(clpname,&ffblk,0);
  if (found) {
    objtime=ffblk.ff_ftime;
    objdate=ffblk.ff_fdate;
  }
  else  /* Object file does not exist */
    exit(0);

  /* Process the .CLP file */
  strcpy(clpname,argv[1]);
  strcat(clpname,".CLP");
  found = !findfirst(clpname,&ffblk,0);
  if (found) {
    ptr=fopen(clpname,"r");  /* open .CLP file */
    while(fscanf(ptr,"%s",prgname)!=EOF) {
      strcat(prgname,".PRG");
      found = !findfirst(prgname,&ffblk,0);
      if (found) {
        if ( objdate < (unsigned)ffblk.ff_fdate )
          exit(0);
        else if ( (objdate == (unsigned)ffblk.ff_fdate) && (objtime < (unsigned)ffblk.ff_ftime) )
          exit(0);
      }
      else {
        printf("Clipmake error: File %s not found.\n", prgname);
        exit(2);
      }
    }
    exit(1); /* no .PRG files newer than .OBJ */
  }
  else { /* .CLP file does not exist */
    printf("Clipmake error: File %s not found.\n", clpname);
    exit(2);
  }
}
