/*=======================================================================
    Program : dmosec.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  09-07-1994   05:28:08
     System : CLIX DEMO
    Compile : /m/n

      Notes : Security functions demo

=======================================================================*/
#include "clxcmd.ch"

/*-----------------------------------------------------------------------
   Function: DoSecurity()
-----------------------------------------------------------------------*/
FUNCTION DoSecurity()
LOCAL cScr,nLevel,cUser,cW
    save screen to cScr
    ScrHead("SECURITY FUNCTIONS",{"+w/b","+r/b","+b/*gr","n/w"},2,.f.)
    pushcolor("w/b")

    @  6, 3 say "CLIX security functions allow you to hide sensitive data with data"
    @  7, 3 say "encryptions, or restrict user access to certain modules and/or data"
    @  8, 3 say "with authorization levels. CLIX' own login routines may be used, or"
    @  9, 3 say "use your network's login procedures and obtain the sucurity levels"
    @ 10, 3 say "from the USER database."

    setcolor("+GR/B")
    @ 12, 10 say " 'Password' data entry function echoes back '*'"
    @ 13, 10 say " Data encryption"
    @ 14, 10 say " User password protected login with security levels"
    @ 15, 10 say " System Administrator's maintenance modules for USER database"
    Pause(22)

    ScrHead("SECURITY FUNCTIONS",{"+w/b","+r/b","+b/*gr","n/w"},2,.f.)
    @  5,3 say "The CLIX security system is based loosely on the Novell Netware style of"
    @  6,3 say "security. Passwords have an expiration date associated with them; when this"
    @  7,3 say "date is exceeded, the login procedure will inform the user that they must"
    @  8,3 say "change their password. The expiration period is automatically set to 3"
    @  9,3 say "months."
    @ 10,3 say "A user may change his/her password at any time by running the ChgPassWord()"
    @ 11,3 say "function. A System Administrator (user level == 99) may add or delete"
    @ 12,3 say "users, and may reset other people's passwords to a temporary value."
    @ 13,3 say "A temporary password is one which is expired, in which case the user"
    @ 14,3 say "logging in has 5 'grace' logins to change their password to a private"
    @ 15,3 say "value."
    @ 16,3 say "Passwords are strictly private to the individual - even a System Admin-"
    @ 17,3 say "istrator will not be able to see what someone else's password is (if a"
    @ 18,3 say "user forgets their password or gets locked out, the S.A. will be able to"
    @ 19,3 say "reset their password to a known, temporary value."
    Pause(22)

    #ifndef SW
      cW:=PopWind(16,8,21,70,"+w/bg",,.t.)
      setcolor("+w/bg")
      @ 17,10 say "Try the login procedure with UserName 'BIGBOSS' and password"
      @ 18,10 say "'THE MAN', then UserName 'HERBERT' and password 'LIL PION'."
      @ 19,10 say "('BIGBOSS' will access the User Maintenance modules)"
      @ 17,49 say "BIGBOSS"  color "+gr/bg"
      @ 18,11 say "THE MAN"  color "+gr/bg"
      @ 18,36 say "HERBERT"  color "+gr/bg"
      @ 18,59 say "LIL PION" color "+gr/gb"

      nLevel := UserLogin(@cUser)
      Dialog(trim(cUser)+" user level is "+str(nLevel,2))
      Unpop(cW)

      do case
          case nLevel == 0
              cW:=PopWind(16,8,20,70,"+w/r",,.t.)
              setcolor("+w/r")
              Blat()
              @ 17,10 say "Normally here you would quit the application, since the"
              @ 18,10 say "user has an access level of 0."
              Pause(19)
              Unpop(cW)
              ClixSet("USERLEVEL", 99)

          case trim(ClixSet("USERID")) == "BIGBOSS"
              UserMaint()

          case Between(nLevel,1,9)
              cW:=PopWind(16,8,21,70,"+w/r",,.t.)
              setcolor("+w/r")
              @ 17,10 say "As you exit the Security demo, notice how some of the"
              @ 18,10 say "menu options are 'greyed' and inaccessible. The current"
              @ 19,10 say "user does not have a UserLevel high enough to access"
              @ 20,10 say "them (log back in as BIGBOSS to regain full access)."
              Pause(21)
              Unpop(cW)
      endcase

    #else
      SWMsg()
    #endif
    popcolor()
    restore screen from cScr
RETURN nil



