/*=======================================================================
    Program : testlook.prg
    (c) 1994 BERNATH COMPUTER all rights reserved
       Date : Sat  08-20-1994   12:38:01
     System : CLIX SAMPLE
    Compile : /m/n

      Notes : sample of LookUp() validation with ability to add a missing
              record to the validation database
              This uses the DBFCDX driver in Clipper 5.2

=======================================================================*/
#include "clxcmd.ch"
#include "samples.ch"

/*
    File DISTRIB.DBF
*/
#define DST_DISTRIBUTR        1
#define DST_DISTNAME          2
#define DST_COUNTRY           3
/*
    File COUNTRY.DBF
*/
#define CTY_COUNTRY           1
#define CTY_CNTRYNAME         2


FUNCTION Main()
LOCAL cCountry:="   ",cOrder:=space(8),cDistrib:=space(8),cPartNo:=space(10)
LOCAL cLColors:="n/bg,+w/n,+w/bg,+bg/n,n/w"
    set confirm on
    set scoreboard off
    set message to 24 center color "+W/B"
    REQUEST DBFCDX
    RddSetDefault("DBFCDX")
    ClixSet("SYSTITLE", _SYSTITLE)

    ScrHead("Test of LookUp() validation function",{"w/b","+w/b","+gr/b","w/b"})
    setcolor("w/b,b/w")

    @ 5,5 say "Country:    " get cCountry ;
      message "Enter the Country Code (? for listbox)" ;
      valid Lookup(_DATAPATH+"COUNTRY","CNTYCODE",cCountry,/* cMask */,/* bFor */,;
        {|| PutGet("cCountry",country->COUNTRY)},1,"Invalid Country Code",;
        {"COUNTRY","CNTRYNAME"},{"Code","Country"},;
        {|| DispLUText(country->CNTRYNAME,5,30,"+r/b")},cLColors,/* lNoBrowse */,;
        {|aF,nEM| EditCntry(aF,nEM)},/* bPostProc */,{cCountry,nil},.t.)

    @ 6,5 SAY "Distributor:" get cDistrib pict "@!" ;
      message "Enter the Distributor Code (? for listbox)" ;
      valid Lookup(_DATAPATH+"DISTRIB","DISTCODE",cCountry+cDistrib,cCountry,/* bFor */,;
        {|| PutGet("cDistrib",distrib->DISTRIBUTR)},1,"Invalid Distributor Code",;
        /* aFld */,/* aHdr */,{|| DispLUText(distrib->DISTNAME,6,30,"+r/b")},;
        cLColors,/* lNoBrowse */,{|aF,nEM| EditDist(aF,nEM)},;
        /* bPostProc */,{cDistrib,nil,cCountry},.t.)

    @ 8,5 say "Export Order#:" get cOrder pict "999-9999" ;
      message "Enter the Export Order Number"

    @ 9,5 say "        Part#:" get cPartNo pict "@!" ;
      message "Enter the Part Number"

    read


RETURN nil


/*------------------------------------------------------------
   FUNCTION.....: EditDist(aF,nEdMode)
 
   DESCRIPTION..: Edit UDF for DistMaint()
------------------------------------------------------------*/
FUNCTION EditDist(aF,nEdMode)
LOCAL cKey,GetList:={}

    @ 6,10 say "Country Code:     " get aF[DST_COUNTRY] pict "999" ;
      when .f.

    @ 8,10 say "Distributor Code: " get aF[DST_DISTRIBUTR] pict"999999" ;
      message "Enter the Distributor Code" ;
      valid NotEmpty(aF[DST_DISTRIBUTR])

    @ 10,10 say "Distributor Name: " get aF[DST_DISTNAME] pict "@!" ;
      message "Enter the Distributor Name" ;
      valid NotEmpty(aF[DST_DISTNAME])


    IF nEdMode > 0
        read
        IF lastkey() <> 27
            cKey := aF[DST_DISTRIBUTR]
        ENDIF
    ELSE
        clear gets
    ENDIF

RETURN (cKey)

/*------------------------------------------------------------
   FUNCTION.....: EditCntry(aF,nEdMode)
 
   DESCRIPTION..: Edit UDF for CntryMaint()
------------------------------------------------------------*/
FUNCTION EditCntry(aF,nEdMode)
LOCAL cKey,GetList:={}

    @ 6,10 say "Country Code: " get aF[CTY_COUNTRY] pict"999" ;
      message "Enter the Country Code" ;
      valid NotEmpty(aF[CTY_COUNTRY])

    @ 8,10 say "Country Name: " get aF[CTY_CNTRYNAME] pict "@!" ;
      message "Enter the Country Name" ;
      valid NotEmpty(aF[CTY_CNTRYNAME])

    IF nEdMode > 0
        read
        IF lastkey() <> 27
            do case
                case OrdName(indexord()) == "CNTYCODE"
                    cKey := aF[CTY_COUNTRY]
                case OrdName(indexord()) == "CNTYNAME"
                    cKey := aF[CTY_CNTRYNAME]
            endcase
        ENDIF
    ELSE
        clear gets
    ENDIF

RETURN (cKey)

