/*=======================================================================
    Program : amortize.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Fri  09-24-1993   16:45:42
     System : CLIX
    Compile : clipper amortize /m/n
              clipper getsyspp /m/n
              rtlink fi amortize,getsyspp lib clix

      Notes : Creates an amortization schedule using CLIX financial
              functions.

=======================================================================*/
#include "clxcmd.ch"
#include "samples.ch"

#define _PRINCIPAL      1
#define _RATE           2
#define _TERM           3
#define _PAYMENT        4

FUNCTION Main()
LOCAL cOutFile,nPrinc:=200000, nIntRate:=10, nTerm:=360,cTitle:=space(36)
LOCAL GetList:={},aMort,dDate,cSayGet,nYrPmt,nMoPmt
LOCAL nGrandInt,nGrandPrin
LOCAL nMonth,aTTL,nLine,nPg,nBalance,nMoInt,nYrPrin,nYrInt,dPrevDate
LOCAL aHdr:={" Pmt  Payment   Principal    Interest",;
             " No.  Date           Paid        Paid     Payment      Balance",;
             "----  --------  ---------   ---------   ---------   ----------"}
LOCAL cTotLine:="                =========   =========   ========="
LOCAL cGTotLine:="                =========   ========="

    ClixSet("SYSTITLE", _SYSTITLE)
    set scoreboard off
    set confirm on
    LoadCSet("DEFAULT", _DATAPATH)
    cSayGet := SayGetClr(8)
    pushcolor(cSayGet)

    do while .t.
        dDate:=BOM(date()+30)
        ScrHead("Amortization Schedule",8)
        @  5,10 say "Title for amortization chart:"
        @  6,10 get cTitle
        @  8,10 say "Principal of Loan:    " get nPrinc pict "9999999.99" ;
          valid GtZero(nPrinc)
        @ 10,10 say "Annual interest rate: " get nIntRate pict "99.999" ;
          valid GtZero(nIntRate)
        @ 12,10 say "Term of loan (months):" get nTerm pict "999" ;
          valid GtZero(nTerm)
        @ 14,10 say "Start date for chart: " get dDate pict "@D"
        read
        if lastkey() == 27
            exit
        endif
        aMort := MortPart({nPrinc,nIntRate,nTerm,0},_PAYMENT)
        @ 16,25 say "Your monthly payment will be "+Currency(aMort[4])
        Pause()

        cOutFile := MakeTemp()
        set alternate to (cOutFile)
        set alternate on
        set console off
        nMoPmt:=aMort[_PAYMENT]
        nPg:=0
        nLine:=99
        nBalance:=nPrinc
        nMoInt:=nIntRate/1200
        dPrevDate := dDate
        nYrPrin:=0
        nYrInt:=0
        nYrPmt:=0
        nGrandPrin:=0
        nGrandInt:=0
        aTTL:={cTitle, ;
               "Principal = "+Currency(nPrinc)+"   Rate = "+;
                transform(nIntRate, "99.999")+"  Term = "+;
                Dig2Str(nTerm)+" months"}
        for nMonth:=1 to nTerm
            nLine:=PgHead(nLine, @nPg, aTTL, aHdr)
            aMort[_TERM] := nTerm - nMonth + 1
            aMort:=MortPart(aMort, _PAYMENT)
            nInt:=nMoInt*nBalance
            nPrin:=aMort[_PAYMENT]-nInt
            nBalance -= nPrin
            aMort[_PRINCIPAL] := nBalance
            if year(dDate) <> year(dPrevDate)
                ? cTotLine
                ? "  Totals "+str(year(dPrevDate),4)+":  "+transform(nYrPrin,"99,999.99")+;
                  "   "+transform(nYrInt,"99,999.99")+"   "+transform(nYrPmt,"99,999.99")
                ?
                nLine += 3
                dPrevDate := dDate
                nYrPrin:=0
                nYrInt:=0
                nYrPmt:=0
            endif
            ? str(nMonth,3)+".  "+dtoc(dDate)+"   "+transform(nPrin,"9,999.99")+;
              "    "+transform(nInt,"9,999.99")+"    "+transform(nMoPmt,"9,999.99")+;
              "   "+transform(nBalance,"999,999.99")
            nYrPrin += nPrin
            nYrInt  += nInt
            nYrPmt  += nMoPmt
            nGrandInt += nInt
            nGrandPrin += nPrin
            nLine++
            dDate := NextMonth(dDate)
        next
        nLine:=PgHead(nLine, @nPg, aTTL, aHdr)
        ? cTotLine
                ? "  Totals "+str(year(dPrevDate),4)+": "+transform(nYrPrin,"999,999.99")+;
                  "  "+transform(nYrInt,"999,999.99")+"  "+transform(nYrPmt,"999,999.99")
        ?
        ? cGTotLine
                ? "Grand Total:   "+transform(nGrandPrin,"999,999.99")+;
                  "  "+transform(nGrandInt,"999,999.99")

        set alternate off
        set alternate to
        set console on
        ViewFile(cOutFile, "Amortization Chart")
        erase (cOutFile)

    enddo
    popcolor()
RETURN nil


