/*=======================================================================
    Program : dmooth2.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  11-17-1993   08:01:49
     System : CLIX DEMO
    Compile : /m/n

    Contains: DoSetIt(), DoCgoDict(), DoStack()
=======================================================================*/
#include "clxcmd.ch"

/*-----------------------------------------------------------------------
   Function: DoSetIt()
-----------------------------------------------------------------------*/
FUNCTION DoSetIt()
LOCAL cScr
    save screen to cScr
    setblink(.f.)
    ScrHead("ClixSet() set function",{"/*gr","+r/*gr","+gr/b","n/*gr"},3,.t.)
    pushcolor("+gr/n")
    @  8,3 clear to 19,75
    @  8,4 say "The ClixSet() function works in a similar manner to Clipper's SET()"
    @  9,4 say "function except all the entries are user defined. Each entry has a "
    @ 10,4 say "label to identify it, then the actual data item to be stored. The" 
    @ 11,4 say "entries can be accessed globally and so are good replacements for using"
    @ 12,4 say "PUBLIC variables."
    @ 14,20 say "Item := ClixSet(cLabel [,Item])" color "+r/n"
    @ 16,4 say "ClixSet() works as a get/set function; if you pass the second parameter"
    @ 17,4 say "Item it will be added to the ClixSet entries or replaced if it already"
    @ 18,4 say "exists, and the function returns the current value of Item (or NIL)."
    @ 19,4 say "Items can be any valid Clipper datatype."
    Pause(23)
    popcolor()
    restore screen from cScr
RETURN nil

/*-----------------------------------------------------------------------
   Function: DoCgoDict()
-----------------------------------------------------------------------*/
FUNCTION DoCgoDict()
    save screen to cScr
    setblink(.f.)
    ScrHead("Cargo Dictionary",{"/*gr","+r/*gr","+gr/b","n/*gr"},3,.t.)
    pushcolor("+gr/n")
    @  8,3 clear to 19,76
    @  8,5 say "Clipper's predefined objects have a :cargo instance variable to store"
    @  9,5 say "user defined data items. If you need to store multiple items the obv-"
    @ 10,5 say "ious choice is an array, and you can use #defines for the elements. But"
    @ 11,5 say "what if other functions need to access the :cargo array; how do you"
    @ 12,5 say "keep them from stepping on each other?"
    @ 13,5 say "The answer is a cargo dictionary. You add data items to an object's "
    @ 14,5 say ":cargo variable by associating them with a unique label; then the items"
    @ 15,5 say "can be accessed by that label without interfering with other routines"
    @ 16,5 say "that may be adding their own data elements."
    @ 18,5 say "Clix's BROWSE command and GET system use the cargo dictionary extensiv-"
    @ 19,5 say "ely."
    Pause(23)
    @  8,3 clear to 19,76
    setcolor("+r/n")
    @ 10,5 say "CargoNew(o)"
    @ 12,5 say "CargoPut(o,{label,item})"
    @ 14,5 say "CargoGet(o,label)"
    @ 16,5 say "CargoDel(o,label)"
    setcolor("+gr/n")
    @ 10,30 say "- initialize a :cargo variable"
    @ 12,30 say "- add or replace data in :cargo with a label"
    @ 14,30 say "- retrieve an item from :cargo by its label"
    @ 16,30 say "- remove an item from :cargo"
    Pause(23)
    popcolor()
    restore screen from cScr

RETURN nil
/*-----------------------------------------------------------------------
   Function: DoStack()
-----------------------------------------------------------------------*/
FUNCTION DoStack()
    save screen to cScr
    setblink(.f.)
    ScrHead("Stacks",{"/*gr","+r/*gr","+gr/b","n/*gr"},3,.t.)
    pushcolor("+gr/n")
    @  8,3 clear to 19,76
    @  8,5 say "Stacks provide a way to save data temporarily and then restore it."
    @  9,5 say "For example, how often have you done this?"
    setcolor("+g/n")
    @ 10,10 say "LOCAL cOldColor"
    @ 11,10 say 'cOldColor := setcolor("+gr/b,+gr/n")'
    @ 12,10 say "// do some stuff"
    @ 13,10 say "setcolor(cOldColor)"
    setcolor("+gr/n")
    @ 15,5 say "With a stack, you could PUSH (add to the stack) the old color, then"
    @ 16,5 say "when you wanted to restore it, you would POP it back off the stack."
    @ 17,5 say "An advantage of stacks is that that can be nested to as many levels"
    @ 18,5 say "as you desire, as long as you have a POP for every PUSH."
    Pause(23)
    @  8,3 clear to 20,76
    @  8,5 say "CLIX provides both user defined and pre-defined stacks:"
    @ 10,5 say "Predefined stacks:" color "+b/n"
    setcolor("+g/n")
    @ 11,10 say "PushColor(), PopColor() - color stack"
    @ 12,10 say "PushDbf(), PopDbf() - saves area#, alias(), recno(), indexord()"
    @ 13,10 say "PushKeys(), PopKeys() - saves current SET KEY's"
    @ 15,5  say "User Defined Stack functions:" color "+b/n"
    @ 16,10 say "PushStack(), PopStack() - push/pop items"
    @ 17,10 say "GetStack() - returns stack as an array"
    @ 18,10 say "TopStack() - move item to top of stack"
    @ 19,10 say "DelStack() - delete item from stack"
    @ 20,10 say "SrchHndl() - locate an item in the stack"
    Pause(23)
    popcolor()
    restore screen from cScr

RETURN nil





