/*=======================================================================
    Program : dmolook.prg
    (c) 1994 BERNATH COMPUTER
       Date : Mon  08-29-1994   12:22:42
     Author : Scott Bernardi
     System : CLIX DEMO
    Compile : /m/n

      Notes : Demo of LookUp() validation function

=======================================================================*/
#include "clxcmd.ch"
#include "look.ch"

#define _VIEW       0
#define _ADD        1
#define _CHG        2

/*-----------------------------------------------------------------------
   Function: DoLookup()
-----------------------------------------------------------------------*/
FUNCTION DoLookup()
LOCAL cScr
    save screen to cScr
    pushcolor("w/b")
    setblink(.f.)
    ScrHead("LOOKUP VALIDATION",{"+w/b","+gr/b","n/*gr","w/b"},3,.t.)
    @  7,5 clear to 21,75
    @  7,7 SAY "A very common requisite for applications is to have lookup tables"
    @  8,7 SAY "for short hand codes used by the system. For example, you may have"
    @  9,7 SAY "a Customer file accessed by a Customer number, to save having to"
    @ 10,7 SAY "key in the customer's entire name. But '10354' is hardly intuitive,"
    @ 11,7 SAY "so it is useful to verify the customer's full name by looking it up"
    @ 12,7 SAY "in the Customer file and displaying it (this also preserves referen-"
    @ 13,7 SAY "tial integrity by preventing the input of invalid customer numbers)."
    @ 14,7 SAY "Furthermore, if you know the customer name but not the number, it"
    @ 15,7 SAY "is useful to be able to pop up a listbox of customer names and num-"
    @ 16,7 SAY "bers to choose from. And to be really convenient, let's have the"
    @ 17,7 SAY "ability to add new customers without having to jump out to the custo-"
    @ 18,7 SAY "mer data entry screen."
    @ 19,7 SAY "CLIX provides all this from a single function call in a VALID"
    @ 20,7 SAY "statement!"
    Pause(23)
    setcolor("+w/b")
    @  7,5 clear to 21,76
    @  7,7 say "Syntax:" color "+gr/b"
    @  8,10 say "@ R,C SAY <text> GET <var>                                    ;"
    @  9,10 say "VALID Lookup(cDbf, Idx, cLookupKey [,cMask] [,bFor], bRetVar  ;"
    @ 10,10 say "    [,SkipNum], cErrMsg, aFlds, aHdrs [,bEvalAfter] [,cKolors];"
    @ 11,10 say "    [,lNoBrowse] [,bAddGets] [,bPostAdd] [,axDefaults]        ;"
    @ 12,10 say "    [,lIsTag] [lUnique], [nMaxwidth], [cAltTitle])"

    setcolor("w/b")
    @ 15,7 say "In the following example of entering invoices, the Customer Key"
    @ 16,7 say "field is tied to a lookup database. Try it out!"
    Pause(23)
    DemoLookUp()
    popcolor()
    restore screen from cScr
RETURN nil


STATIC FUNCTION DemoLookUp()
LOCAL bEdBlock:={|aF,nEM| InvEntry(aF,nEM)}
    select 0
    NetUse("CUSTOMER")
    set index to CUSTKEY
    select 0
    NetUse("INVOICE")
    set index to INVNUM
    set relation to KEY into CUSTOMER

    EDIT WITH bEdBlock TITLE "Invoice Entry"
    close data

RETURN nil

STATIC FUNCTION InvEntry(aF,nEM)
LOCAL cKey,GetList:={}
    if nEM == _ADD
        aF[IV_TRAN_DATE] := date()
    endif


    @ 6,5 say "Invoice#    " get aF[IV_INV_NO] pict "999999" ;
      message "Enter the Invoice number" ;
      valid Notempty(aF[IV_INV_NO])

    @ 7,5 say "Customer Key" get aF[IV_KEY] pict "@!" ;
      message "Enter the Customer Key (? for listbox)" ;
      VALID Lookup("CUSTOMER","CUSTKEY",aF[IV_KEY],,,{|| PutGet("aF",customer->KEY,{IV_KEY})},;
        1,"Invalid Customer#",{"KEY","NAME","COMPANY"},{"Key","Name","Company"},;
        {|| DispLUText(customer->NAME,7,30,"+gr/b")},,,{|aF,nEM| AddCust(aF,nEM)},,;
        {aF[IV_KEY],,,,,,,,,,,,,,,,,,},,,,"Add Customer")

    @  9,5 say "Item#" get aF[IV_ITEM_NO] pict "999" ;
       message "Enter the Line Item #"

    @  9,25 say "Date" get aF[IV_TRAN_DATE] pict "@D" ;
       message "Enter the transaction date"

    @ 10,5 say "Qty  " get aF[IV_QUANTITY] pict "9999" ;
      message "Enter the line item quantity"

    @ 10,25 say "Desc" get aF[IV_TRAN_DESC] pict "@!" ;
      message "Enter the description of the item"

    if nEM > 0
        read
        if lastkey() <> 27
            cKey := aF[IV_INV_NO]
        endif
    else
        clear gets
    endif
RETURN(cKey)

STATIC FUNCTION AddCust(aF,nEM)
LOCAL cKey,GetList:={}

    @  6, 5 say "Key  " get aF[CU_KEY] pict "@!" ;
      message "Enter the Customer Key"

    @  7, 5 say "Name " get aF[CU_NAME] ;
      message "Enter the Customer Name"

    @  8, 5 say "Company" get aF[CU_COMPANY] ;
      message "Enter the Company Name"

    @  9, 5 say "Address" get aF[CU_ADDRESS1] ;
      message "Enter the address"

    @ 10, 5 say "       " get aF[CU_ADDRESS1] ;
      message "Enter the address"

    @ 11, 5 say "   City" get aF[CU_CITY] ;
      message "Enter the City"

    @ 11,40 say "State" get aF[CU_STATE] ;
      message "Enter the State"

    @ 11,55 say "Zip" get aF[CU_ZIP] ;
      message "Enter the Zip code"

    @ 13, 5 say "Phone  " get aF[CU_PHONE] pict "(999)999-9999" ;
      message "Enter the phone number"

    if nEM > 0
        read
        if lastkey() <> 27
            cKey := aF[CU_KEY]
        endif
    else
        clear gets
    endif
RETURN(cKey)
