/*=======================================================================
    Program : dmorec.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Mon  11-22-1993   16:39:03
     System : CLIX DEMO
    Compile : /m/n

      Notes : demo of record manipulation functions


=======================================================================*/
#include "clxcmd.ch"
#include "set.ch"

/*-----------------------------------------------------------------------
   Function: DoRecManip()

-----------------------------------------------------------------------*/
FUNCTION DoRecManip()
LOCAL cScr,nOpt:=1,cW,nMsgRow
LOCAL aColor:={"+w/b","b/*w","+gr/b","n/b","+bg/b"}
LOCAL aMnu:={"Scatter() / ~Gather()",;
             "~RecCopy()           ",;
             "Copy~Fields()        ",;
             "Seek~Last()          ",;
             "~Sum()               ",;
             "~Exit                " }
LOCAL aMsg:={"Copy database fields to array / save fields in array to disk",;
             "Copy records to another similar database",;
             "Copy fields from record in one database to a dissimilar database",;
             "Seek the LAST occurence of a key",;
             "Add a value to a numeric field in a database",;
             "Return to Main Menu" }
    save screen to cScr
    PushMsgStyle({22,,,78,_MT_SWIN})

    ScrHead("RECORD MANIPULATION",{"+w/b","+r/b","+b/*gr","n/w"},2,.f.)

    pushcolor("b/*w")
    do while .t.

        nOpt := AutoMenu(aMnu, aMsg, nOpt, aColor)
        if nOpt==0 .or. nOpt==len(aMnu)
            exit
        endif
        cW:=PopWind(10,10,19,70,"n/*w",,,,1)
        do case
            case nOpt == 1
                @ 11,12 say "aAr := Scatter([nArea])" color "r/*w"
                @ 12,14 say "Scatter() " color "r/*w"
                @ 12,col() say "copies the fields from the current record into"
                @ 13,14 say "an array."
                @ 15,12 say "Gather(aAr [,nArea]) " color "r/*w"
                @ 16,14 say "Gather() " color "r/*w"
                @ 16,col() say "replaces the contents of the array into the"
                @ 17,14 say "current record."
            case nOpt == 2
                @ 11,12 say "RecCopy(FromArea, ToArea [,lAppend] [lMove])" color "r/*w"
                @ 13,14 say "RecCopy() " color "r/*w"
                @ 13,col() say "copies records from a source database into a"
                @ 14,14 say "similar destination database. If lAppend is .t.,"
                @ 15,14 say "the desination record is appended, else it replaces"
                @ 16,14 say "the current destination record. If lMove is .t.,"
                @ 17,14 say "the source record is deleted."
            case nOpt == 3
                setcolor("r/*w")
                @ 11,12 say "CopyFields(FromArea, ToArea, aaFlds [,bKey] [,bWhile] ;"
                @ 12,12 say "           [,bFor] [,nNext] [,lRest] [,lNoAppend])"

                @ 14,12 say "COPY FIELDS FROM AREA <nSA> TO AREA <nDA> MAP <aaFlds> ;"
                @ 15,12 say "   [KEY <bKey>] [WHILE <bWhile>] [FOR <bFor>]          ;"
                @ 16,12 say "   [NEXT <nNext>] [REST] [NOAPPEND]"
                setcolor("b/*w")
                Pause(19,,"n/*w")
                @ 11,12 clear to 18,69
                @ 11,12 say "CopyFields() " color "r/*w"
                @ 11,col() say "can copy fields from a source into a dissim-"
                @ 12,12 say "ilar database, as long as the fields are compatible."
                @ 13,12 say "Scoping of the source database is available, and a "
                @ 14,12 say "relationship lookup can be done on the destination "
                @ 15,12 say "database. The field map can contain codeblocks, so "
                @ 16,12 say "calculations or modifications can be performed before" 
                @ 17,12 say "copying the data, permitting CopyFields() to act like "
                @ 18,12 say "a generalized UPDATE routine."
            case nOpt == 4
                @ 11,12 say "lFound := SeekLast(KeyVal)" color "r/*w"
                @ 13,14 say "SeekLast() " color "r/*w"
                @ 13,col() say "performs a seek for the LAST occurence of"
                @ 14,14 say "KeyVal, and returns .t. if KeyVal is found."
            case nOpt == 5
                @ 11,12 say "Sum(cFldName [,nArea] ,nAddVal)" color "r/*w"
                @ 13,14 say "Sum() " color "r/*w"
                @ 13,col() say "adds a value to the specified numeric"
                @ 14,14 say "field in the current record in the specified"
                @ 15,14 say "workarea."
        endcase
        Pause(19,,"n/*w")
        UnPop(cW)
    enddo
    popcolor()
    PopMsgStyle()
    restore screen from cScr

RETURN nil


