/*=======================================================================
    Program : demomain.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  09-07-1994   05:37:21
     System : CLIX DEMO
    Compile : /m/n

    Contains: DoMain()
=======================================================================*/
#include "clxcmd.ch"
#include "inkey.ch"
#include "fades.ch"

/*-----------------------------------------------------------------------
       Proc: DoMain()
      Notes: Main demo menu

-----------------------------------------------------------------------*/
procedure DoMain()
LOCAL aEffMnu,aDEMnu,aMLMnu,aWinMnu,aDBMnu,aPAMnu,aOthMnu,aQuitMnu,aMainMnu
aEffMnu:={ ;
           {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
           {"~Fades","Slideshow-type fades for screen images",{|| DoFades()},.t.},;
           {"~Palette","Redefine EGA 64 color palette",{|| DoPalette()},{|| ChkLevel(10)}},;
           {"~Sound","Sound effects",{|| DoSound()},.t.},;
           {"~Line Draw","Line drawing with intelligent intersections",{|| DoLineDraw()},.t.},;
           {"Fill ~BG","Fill background for a wallpaper effect",{|| DoFillBG()},.t.};
         }

aDEMnu:={ ;
          {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
          {"Enhanced ~GET","Enhancements to GET system",{|| DoGetDemo()},.t.},;
          {"~Check Boxes","Mouseable checkbox enhancement to GET system",{|| DoChkBox()},.t.},;
          {"~Radio Buttons","Mouseable radio button enhancement to GET system",{|| DoRadio()},.t.},;
          {"~Incremental Date","Cycle through dates with arrow keys, etc",{|| DoDateInc()},.t.},;
          {"~Hotspots","Hotspots and command buttons respond to mouse clicks",{|| DoHotSpot()},.t.},;
          {"Combo/~ListBox","Enhancement to GET system pops up a listbox",{|| DoLBox()},.t.},;
          {"~Dialog box","Enhancement of Alert() function is mouse aware",{|| DoDialog()},.t.},;
          {"Lookup ~Validation","Validate fields against a lookup DBF, with browsing",{|| DoLookup()},.t.},;
          {"Ge~Neric Data Entry","Generic data entry module for file maintenance",{|| DoGened()},{|| ChkLevel(10)}};
        }

aMLMnu:={ ;
          {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
          {"~BROWSE command","Command interface to tbrowse with many features",{|| DoBrows()},.t.},;
          {"Parent/~Child Browse","Browse multiple related windows",{|| DoMultiBr()},.t.},;
          {"~Picklists","Single select and multiple tag picklists",{|| DoPickList()},.t.},;
          {"~Tag Lists","Tag database records for processing",{|| DoTagList()},.t.},;
          {"Popup ~Fields","Two types of popup lists of database fields",{|| DoPopFlds()},.t.},;
          {"Pull~Down Menu System","Mouse aware pulldown menu system",{|| DoPDown()},{|| ChkLevel(10)}},;
          {"~Inactive Menu Item","",,.f.},;
          {"~Auto Menus","Automatically centered menu function",{|| DoAutoMenu()},.t.} ;
        }

aWinMnu:={ ;
           {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
           {"Fancy ~Boxes","Additional box types including a 3-D look",{|| DoBox()},.t.}, ;
           {"Popup ~Windows","Simple popup windows have various fade in types",{|| DoPopWin()},.t.},;
           {"Window ~Objects","Window objects are movable, resizable",{|| DoWinObj()},{|| ChkLevel(10)}} ;
         }

aDBMnu:={ ;
          {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
          {"~DbfOpen","Intelligent database open routine checks for existance of files and indexes",{|| DoDbfOpen()},.t.},;
          {"~Network","Network locking functions",{|| DoNet()},.t.},;
          {"~Record Manipulation","Scatter/Gather, CopyRec, etc",{|| DoRecManip()},.t.},;
          {"~Index Dictionary","Maintain a dictionary of indexes and keys",{|| DoIdxDict()},{|| ChkLevel(10)}} ;
        }

aOthMnu:={ ;
           {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
           {"~Printer Drivers","Modules for maintaining and using printer drivers", {|| DoPrtDrv()},.t.},;
           {"~Security","Login with passwords, data encryption",{|| DoSecurity()},.t.},;
           {"~Mouse Control","Routines for controlling and responding to the mouse", {|| DoMouse()},.t.},;
           {"~Filer","File pick routine",{|| Filer(,"+w/rb,rb/*w,+gr/rb,+rb/rb")},{|| ChkLevel(10)}}, ;
           {"-"},;
           {"S~Tacks","Various functions using stacks",{|| DoStack()},.t.},;
           {"~Color","Color schemes, color manager",{|| DoColor()},.t.},;
           {"~Help System","Popup help system is easy to implement",{|| DoHelp()},.t.},;
           {"Cli~XSet","Works like user defined set() functions",{|| DoSetIt()},.t.},;
           {"Cargo ~Dictionary","Use labels to access data stored in Cargo variables of Clipper objects",{|| DoCgoDict()},.t.},;
           {"t~Ext Files","View a text file, text file functions analagous to database functions",{|| DoText()},.t.};
         }

aQuitMnu:={ ;
            {"+w/r","+w/n","+gr/r","gr/r","n/bg"},;
            {"~Ordering Info","Print order form",{|| DoOrder()},.t.},;
            {"~Exit","Exit CLIX demo",{|| QuitApp()},.t.} ;
          }



aMainMnu:={ {"w/b","+w/n","+gr/b","n/b","n/bg"},;
            {"~Effects","Special screen effects and sound",aEffMnu,.t.,K_ALT_E},;
            {"d~Ata Entry","Enhanced GET system, hotspots",aDEMnu,.t.,K_ALT_A},;
            {"~Menus/Lists","Mouseable menus, picklists, taglists, browsers",aMLMnu,.t.,K_ALT_M},;
            {"~Windows","Windows and boxes",aWinMnu,.t.,K_ALT_W},;
            {"Data~Base","Data handling, network functions, index dictionary",aDBMnu,{|| ChkLevel(10)},K_ALT_B},;
            {"~Other","Printer, Filer, Help system, mouse control, security",aOthMnu,.t.,K_ALT_O},;
            {"~Quit","Ordering information, Exit Demo",aQuitMnu,.t.,K_ALT_Q} ;
          }

    external ListFunc
    set key K_ALT_F to ListFunc
    #ifndef SW
      external HelpDesign
      external Help
      set key K_ALT_F1 to HelpDesign
      set key K_F1 to Help
    #endif

    set message to 24 center
    ScrHead("Main Menu",{"+w/b","+gr/b","+w/r","w/b"},3,.t.)
    setcolor("w/b")
    @ 5,0
    setcolor("n/bg")
    @ 23,0 clear to 24,maxcol()
    MouseOn()
    DoPullDown(aMainMnu, 5, , .t., "C", 24, 23)

return


//--------------------------------------------------
function DoColor()
    ColorMgr()
return NIL


/*-----------------------------------------------------------------------
   Function: DoOrder()
-----------------------------------------------------------------------*/
function DoOrder()
local nChoice:=1
    nChoice := Dialog("Print Order Form?",{"Yes","No"})
    if nChoice == 1
          PrintFile("ORDER.FRM")
    endif
RETURN nil

STATIC FUNCTION QuitApp()
LOCAL nAbort:=Dialog("Do you wish to exit?",{"Yes","No"})
    if nAbort == 1
        cImg := ReadScrn("clix.img")                    // read screen image
        setblink(.t.)
        Fade(F_VSTRIPE, cImg)                           // vertical stripe fade
        Dialog("Thanks for trying CLIX!")
        MouseOff()
        set cursor on
        quit
    endif
RETURN nil

/*-----------------------------------------------------------------------
   Function: SWMsg()
      Notes: message informing that the function(s) are available only in
             the registered version

-----------------------------------------------------------------------*/
FUNCTION SWMsg()
    MsgBox({"These functions are only available in",;
            "the registered version of CLIX. See",;
            "order form to register."},,{|| blip()},.t.,.t.)
RETURN nil

#ifdef SW
FUNCTION ChkLevel(nReqLevel)
RETURN .t.

FUNCTION Filer()
    SWMsg()
RETURN nil
#endif
