/*=======================================================================
    Program : clxdemo.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  09-07-1994   05:41:08
     System : CLIX DEMO
    Compile : /m

      Notes : clix demo

=======================================================================*/
#include "clxcmd.ch"
#include "fades.ch"
#include "clxbox.ch"

#define _SCR_UP          1
#define _SCR_DOWN       -1
#define K_CTRL_F10      -29
#define K_CTRL_F9       -28

INIT FUNCTION Main(cParm)

local cImg,nButtons


    #ifndef SW
      external DispStack
      external PopAscii
    #endif
    set scoreboard off
    set confirm on
    set bell off
    set exclusive off
    set cursor off
    ClixSet("SYSTITLE", "CLIX Clipper 5.x Library")
    ClixSet("SCRHEAD",{.t.,.t.,"Alt-F Function List", nil})
    ClixSet("USERLEVEL", 99)

    if cParm==NIL .or. .not. "/S" $(upper(cParm))

        cImg := ReadScrn("clix.img")                    // read screen image
        setblink(.t.)
        Fade(F_SPARKLE, cImg)                           // sparkle fade
        //Fade(F_VSTRIPE, cImg)
        inkey(2)
        Twiddle()

        FillBg("n/bg")
        DrawBox(1,3,4,74,"+w/b",B_DOUBLE, .t., , pDB_PULLDOWN)
        @ 2,5 say padc("CLIX full-featured library for Clipper 5.2", 68) color "+w/b"
        @ 3,5 say padc("by BERNATH COMPUTER", 68) color "+w/b"
        PopWind(7,5,22,72,"+gr/r",B_DOUBLE,.t.,,pDB_EXPLODE)
        @ 8,7 say padc("WELCOME TO CLIX!",62) color "+w/r"
        setcolor("w/r")
        @ 10,7 say "Clipper is an excellent development tool and langauge, but a"
        @ 11,7 say "number of features that are taken for granted in other modern"
        @ 12,7 say "Xbase adaptations are missing.  Clipper's saving grace is its"
        @ 13,7 say "extensibility - these features can be added, but who is going"
        @ 14,7 say "to do the developing?"

        @ 16,7 say padc(" ENTER CLIX!! ",62) color "+w/r"

        @ 18,7 say "We have done the nuts and bolts programming of these 'gotta"
        @ 19,7 say "have' features so you can concentrate your efforts on appli-"
        @ 20,7 say "cations development."

        MouseInit(@nButtons)
        MouseOn()
        Pause(21,7,"+gr/r")
        ScrollBox(8,6,21,71,_SCR_UP)

        @  8,7 say "CLIX has over 300 functions covering new GET types, browsers,"
        @  9,7 say "list boxes and picklists, pulldown menus, windows, mouse con-"
        @ 10,7 say "trol, security, network functions, color schemes, special ef-"
        @ 11,7 say "fects, printer control, a help system, stacks, random functions,"
        @ 12,7 say "sound, conversion functions, index dictionary, and lots more!"

        @ 14,7 say "Documentation is provided in a Norton Guides database (included"
        @ 15,7 say "in this demo), and a manual on disk which may be printed. Numer-"
        @ 16,7 say "ous example files (including the source code to this demo) are"
        @ 17,7 say "provided.  Source code to the entire library is included with"
        @ 18,7 say "the registered version."

        Pause(21,7,"+gr/r")
        ScrollBox(8,6,21,71,_SCR_DOWN)
    else
        MouseInit(@nButtons)
        MouseOn()
    endif

    LoadCSet()                                      // load default color set
    #ifndef SW
      set key K_CTRL_F10 to DispStack
      set key K_CTRL_F9 to PopAscii
    #endif

    DoMain()                                        // main menu module

    cImg := ReadScrn("clix.img")                    // read screen image
    setblink(.t.)
    Fade(F_VSTRIPE, cImg)                           // vertical stripe fade
    Dialog("Thanks for trying CLIX!")

    MouseOff()                                      // don't forget to turn
                                                    // the mouse off before
                                                    // terminating!
    set cursor on
RETURN nil

