/*=======================================================================
    Program : SAMPRPT.PRG
    (c) 1994 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:32:52
     System : CLIX SAMPLE PROGRAM
    Compile : /m/n/b

      Notes : This is a sample program illustrating the use of RouteOut()
              to route printer output on a network system.

=======================================================================*/
#include "clxcmd.ch"
#include "prmnt.ch"
#include "netcap.ch"
#include "samples.ch"

FUNCTION Main()
    LoadCSet("DEFAULT")
    ClixSet("NETWORK",.t.)        // let's at least pretend we're on a network
    ClixSet("SYSTITLE", _SYSTITLE)
    InvRpt()
RETURN nil

/*-----------------------------------------------------------------------
   Function: InvRpt()
      Notes: prints a report of invoice


       Uses:
  Revisions:
-----------------------------------------------------------------------*/
STATIC FUNCTION InvRpt()
LOCAL cLoKey:=space(8),cHiKey:="ZZZZZZZZ",dDate:=date(),cTempFile
LOCAL cPort,cPrtName,cQueue,nPg:=0,nLine:=99

    // open files and set relations
    OpenDbf("INVOICE","INVCUST",,,_DATAPATH)
    OpenDbf("CUSTOMER","CUSTKEY",,,_DATAPATH)
    set relation to KEY into INVOICE

    setcolor(SayGetClr(3))

    do while .t.
        ScrHead("Invoice Report by Customer", 6, 3, .t.)
        // get report scope
        @  8,25 say " Lowest Customer to process:" get cLoKey pict "@!"
        @  9,25 say "Highest Customer to process:" get cHiKey pict "@!"
        @ 10,25 say "Report Date:" get dDate
        read
        if lastkey() == 27
            exit
        endif
        cOut := RouteOut("0",.f.,12,25)   // get output routing
        if cOut == chr(27)
            exit
        endif

        select CUSTOMER

        if !empty(cLoKey)
            seek cLoKey
            if eof()
                ErrMsg("No customers in range.")
                loop
            endif
        else
            go top
        endif

        StatWin("Printing.......")
        cTempFile:=TempFile()
        set console off
        set alternate to (cTempFile)
        set alternate on
        SendEsc("CPI17")

        // print report
        do while !eof() .and. KEY <= cHiKey
            nLine:=PgHead(nLine,@nPg,"Customer Invoice Report",,.t.)
            if invoice->(eof())
                skip
                loop
            endif
            ?
            ? NAME+" "+padr(trim(ADDRESS1)+" "+trim(ADDRESS2),45)+" "+trim(CITY)+", "+STATE+" "+ZIP
            nLine += 2
            select INVOICE
            nCharges:=nPmts:=nShip:=0
            do while !eof() .and. KEY == CUSTOMER->KEY
                do case
                    case TRAN_TYPE==1 .or. TRAN_TYPE==2
                        nCharges += AMOUNT
                    case TRAN_TYPE==3 .or. TRAN_TYPE==5
                        nShip += AMOUNT
                    case TRAN_TYPE==4
                        nPmts += AMOUNT
               endcase
               skip
            enddo
            ? "Charges: "+Currency(nCharges)+"  Shipping: "+Currency(nShip)+"  Payments: "+Currency(nPmts)
            nLine++

            select CUSTOMER
            skip
        enddo

        qqout(_PG_EJECT)
        SendEsc("CPI10")
        set console on
        set alternate off
        set alternate to

        // view file or copy file to printer
        do case
            case cOut == "S"
                FileView("Customer Invoice Report", cTempFile)

            otherwise
                cPort := SetIt("PRTPORT")
                cPrtName := SetIt("PRTNAME")

                if cOut == "N"
                    cQueue := SetIt("QUEUENAME")
                    CAPTURE QUEUE cQueue
                else
                    if !PrtReady(val(right(cPort,1)))
                        loop
                    endif
                endif

                PrintFile(cTempFile, cPort, .f.)

                if cOut == "N"
                    EndCap
                endif
                StatWin("Printing completed.", .t.)
        endcase
        StatWin()
        if file(cTempFile)
            erase (cTempFile)
        endif

    enddo
    StatWin()
    close data
RETURN nil


