/*=======================================================================
    Program : testmlti.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:42:14
     System : CLIX
    Compile : clx TESTMLTI

      Notes : Sample program for MultiBrowse()

=======================================================================*/
#include "clxcmd.ch"
#include "inkey.ch"
#include "samples.ch"

FUNCTION Main()
LOCAL aaFlds:={},aaHdr:={},aCaps:={},aaHot:={},aaFunc:={},aaInst:={}
LOCAL aKolors:={ "b/bg,+bg/b,+w/bg,+gr/bg,+bg/bg",;
                 "n/g,+gr/n,+gr/g,+w/g,+g/g"  }
LOCAL aaCoords:={},nButton
                  
aRel:={nil, "customer->KEY"}

    OpenDbf("INVOICE","INVCUST",,,_DATAPATH)
    OpenDBf("CUSTOMER","CUSTKEY",,,_DATAPATH)
    set relation to KEY into INVOICE
    // define parameters for top CUSTOMER box
    aadd(aaFlds, {"KEY","NAME",{|| padr(trim(ADDRESS1)+" "+trim(ADDRESS2),36)},{|| CSZ(CITY,STATE,ZIP)},"COMPANY"})
    aadd(aaHdr, {"Key", "Name", "Address", "City/State/Zip","Company"})
    aadd(aCaps, "ENTER to Edit")
    aadd(aaHot, {K_ENTER})
    aadd(aaFunc, { {|| Alert("You pressed ENTER")} } )
    aadd(aaCoords, {1,2,11,78})


    // define parameters for bottom INVOICE box
    aadd(aaFlds, {"INV_NO","TRAN_DATE","TRAN_DESC",{|| BlZero(QUANTITY,8)},{|| BlZero(UNIT_PRICE,10)},"AMOUNT"})
    aadd(aaHdr, {"Invoice#","Inv Date","Item Description","Quantity","Unit Price","Amount"})
    aadd(aCaps, "ENTER to Edit")
    aadd(aaHot, {K_ENTER})
    aadd(aaFunc, { {|| Alert("You pressed ENTER")} } )
    aadd(aaCoords, {12,2,24,78})
    setcolor("n/w")
    cls
    MouseInit(@nButton)
    MouseOn()
    MultiBrowse(,{"CUSTOMER","INVOICE"},aaFlds,aaHdr,aKolors,aaCoords,;
      {"CUSTOMERS","INVOICES"},{.f.,.t.},,aaHot,aaFunc,aCaps,aRel,;
      {.t.,.f.},nil,{1,1})

    close data
    MouseOff()
RETURN

// concatenate city, state, zip
STATIC FUNCTION CSZ(cCity, cState, cZip)
LOCAL cCSZ:=padr(trim(cCity)+", "+cState+" "+trim(if(right(cZip,5)=="-    ",left(cZip,5),cZip)), 36)
    if alltrim(cCSZ) == ","
        cCSZ := space(36)
    endif
RETURN(cCSZ)

STATIC FUNCTION BlZero(nVar,nW)
RETURN(if(nVar==0,space(nW),padl(str(nVar),nW)))
