/*=======================================================================
    Program : dmomenu.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Sat  07-24-1993   15:25:51
     System : CLIX LIBRARY
    Compile : /m/n

      Notes : menus



    Contains: DoAutoMenu(), DoPDown()
=======================================================================*/

#include "clxcmd.ch"
#include "inkey.ch"
#include "clxbox.ch"

/*-----------------------------------------------------------------------
   Function: DoAutoMenu()
-----------------------------------------------------------------------*/
function DoAutoMenu()
local aOpt:={" ~Employee         ",;
             " ~Consignees       ",;
             " ~POD              ",;
             " Purchase ~Orders  ",;
             " Ite~Ms Pending    ",;
             " ~Licenses         ",;
             " ~Harmonized Codes ",;
             " Carriers          ",;
             " ~Truck Bills      ",;
             " ~Bookings         ",;
             " ~Vessels          ",;
             " ~Shiplines        ",;
             " ~Invoice Codes    ",;
             " Ven~Dors          ",;
             " e~Xit             " }
local aMsg:={"Maintain Employee Records",;
             "Maintain Consignee codes, names, and addresses",;
             "Maintain Port of Discharge Codes",;
             "Maintain Purchase Orders",;
             "Maintain Purchase Order Line Items",;
             "Maintain Export Licenses",;
             "Maintain Harmonized Codes (Schedule B numbers)",;
             "Maintain Freight Carrier list",;
             "Maintain Inland Freight Truckbills",;
             "Maintain Bookings",;
             "Maintain Vessel Codes",;
             "Maintain Shipping Line Codes",;
             "Maintain Invoice G/L Codes",;
             "Maintain Vendor codes, names, and addresses",;
             "Exit menu" }
local aColor:={"+w/b","n/*w","+r/b","n/b","+w/b"}
local nOpt:=1,cScr,nMsgType
    nMsgType:=ClixSet("MSGTYPE", _MT_SWIN)
    save screen to cScr
    setblink(.f.)
    ScrHead("AUTOMATIC MENUS",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    pushcolor("n/*w,+w/b")
    @ 7,5 clear to 11,75
    @  7,7 say "The AutoMenu() function provides a simple way to format bar menus on"
    @  8,7 say "the screen without having to code the individual @ PROMPT commands."
    @  9,7 say "AutoMenu() will handle up to 17 menu items, and will automatically"
    @ 10,7 say "split them into two columns if there are more than 8."
    Pause(,,,"Press any key for a demonstation...")
    do while .t.
        ScrHead("Automatic Menu Example",{"+w/b","+r/b","+b/*gr","n/w"},2,.f.)
        nOpt := AutoMenu(aOpt,aMsg,nOpt,aColor)
        if nOpt==0 .or. nOpt==len(aOpt)
            exit
        else
            Dialog("You chose "+trim(strtran(aOpt[nOpt],"~","")))
        endif
    enddo

    popcolor()
    restore screen from cScr
    ClixSet("MSGTYPE",nMsgType)
return NIL

/*-----------------------------------------------------------------------
   Function: DoPDown()
-----------------------------------------------------------------------*/
function DoPDown()
local cScr,lBlink
local aNest2:={ ;
                {"+w/*b","+b/*w","+r/*b","+b/*b","n/*w"},;
                {"Option ~1","This is level 2 option 1",{|| Dialog("You chose option 1 of level 2")},.t.},;
                {"Option ~2","This is level 2 option 2",{|| Dialog("You chose option 2 of level 2")},.t.},;
                {"Option ~3","This is level 2 option 3",{|| Dialog("You chose option 3 of level 2")},.t.},;
                {"Option ~4","This is level 2 option 4",{|| Dialog("You chose option 4 of level 2")},.t.} ;
              }
local aNest:={ ;
               {"+w/b","b/*w","+r/b","n/b","n/*w"},;
               {"Item ~1","This is item number 1 or menu 1",{|| Dialog("You chose item 1.1")},.t.},;
               {"~Nested Levels","Select this item to see nested menus",aNest2,.t.},;
               {"Item ~3","This is item number 3 or menu 1",{|| Dialog("You chose item 1.3")},.t.} ;
             }
local aSyn:={  ;
               {"+w/r","b/*w","+gr/r","gr/r","n/*w"},;
               {"~Top Menu","Syntax for specifying the top (horizontal) menu",{|| TopMenu()},.t.},;
               {"~Pulldown Menu","Syntax for specifying the pulldown (vertical) menus",{|| Pdown()},.t.},;
               {"~Execute","Syntax for executing the pulldown menu system",{|| Exec()},.t.} ;
            }
local aUn:={ {nil,nil,nil,nil,nil},;
             {"","",nil,nil,.f.}  }
local aExit:={ ;
               {"+w/n","n/*w","+r/n","+n/n","n/*w"},;
               {"e~Xit","Quit",{|| ExitMenu()},.t.} ;
             }

local aMain:={ {"n/*w","+w/n","+r/*w","+gr/*w","n/*w"},;
               {"~Nested Menus","Demonstration of nested menus",aNest,.t.,K_ALT_N},;
               {"~Syntax","Syntax for the pulldown menu system",aSyn,.t.,K_ALT_S},;
               {"Unavailable","",aUn,.f.,K_ALT_U},;
               {"e~Xit","Exit the pulldown menu system demo",aExit,.t.,K_ALT_X} }

    save screen to cScr
    lBlink:=setblink(.f.)
    ScrHead("PULLDOWN MENUS",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    pushcolor("+w/b")
    @  7,5 clear to 17,75
    @  7,7 say "CLIX pulldown menus are easy to use, but still very flexible. They"
    @  8,7 say "are fully mouseable, with highlighted hotkeys, user defined colors"
    @  9,7 say "for each pulldown menu (they can all be different colors), and menus"
    @ 10,7 say "may be nested (ie, a menu option can call another menu), or a code"
    @ 11,7 say "block executed when a menu option is selected. The pulldown menus"
    @ 12,7 say "may have dividing bars, and a menu item can be rendered inactive"
    @ 13,7 say "with a logical parameter. Message lines which change as the selected"
    @ 14,7 say "items change can be be displayed. The menus will respond to any act-"
    @ 15,7 say "SETKEY values."
    @ 16,7 say "You know what features a good pulldown menu should have - CLIX has"
    @ 17,7 say "them all!"
    Pause(,,,"Press any key for a demostration....")

    ScrHead("PULLDOWN MENUS",{"n/*w","r/*w","+w/*n","n/w"},1,.f.)
    DrawBox(5,10,7,58,"n/*w")
    DoPullDown(aMain, 6, 12, .t., "C", 24, 23)
    popcolor()
    restore screen from cScr
    setblink(lBlink)
return NIL

static function PDown()
return NIL

static function Exec()
local cWind
    cWind:=PopWind(8,5,19,75,"+w/n",B_DOUBLE,.t.,"DoPullDown() syntax:",pDB_EXPLODE)
    @  9,8 say "DoPullDown(aMain,nRow,nStartCol,lShadow,cJus,nHorzMsgRow,;" color "+gr/n"
    @ 10,8 say "           nVertMsgRow)" color "+gr/n"
    pushcolor("+w/n")
    @ 11,10 say "aMain     (A) - main pulldown array"
    @ 12,10 say "nRow      (N) - row for the horizontal menu"
    @ 13,10 say "nStartCol (N) - start col for the horizontal menu"
    @ 14,10 say "lShadow   (L) - .t. if shadows on the pulldown menus are desired"
    @ 15,10 say "cJus      (C) - 'C' for Centered prompts, 'L' for left justified"
    @ 16,10 say "nHorzMsgRow (N) - row for messages for horizontal menu"
    @ 17,10 say "nVertMsgRow (N) - row for messages for vertical menus"
    Pause(18,10,"+gr/n")
    Unpop(cWind)
    popcolor()
return NIL

static function TopMenu()
local cWind
    cWind:=PopWind(8,5,20,75,"+w/n",B_DOUBLE,.t.,"Top Menu Array syntax:",pDB_EXPLODE)
    pushcolor("+w/n")
    @  9,7 say "aMain:={ ;"
    @ 10,7 say "          aColors,;"
    @ 11,7 say "                <for each horizontal prompt:>"
    @ 12,7 say "          {cPrompt,cMsg,<bBlock or aVMenu>,lActive,nHotKey},;"
    @ 13,7 say "         {"
    @ 15,7 say "This array should be passed to DoPullDown().  To have pulldown"
    @ 16,7 say "vertical menus called when a horizontal pad is chosen, a menu"
    @ 17,7 say "array should be passed as aVMenu, or a codeblock for no pulldown."

    Pause(19,10,"+gr/n")
    Unpop(cWind)
    popcolor()
return NIL


