/*=======================================================================
    Program : clxspget.prg
    (c) 1994 BERNATH COMPUTER all rights reserved
       Date : Fri  04-08-1994   22:32:25
     System : CLIX
    Compile : /m/n

      Notes : Numeric "spinner" get reader
              must link with getsyspp.prg


    Contains:
=======================================================================*/
#include "clxcmd.ch"
#include "events.ch"
#include "spinget.ch"
#include "Getexit.ch"

#define TESTMODE

#ifdef TESTMODE
FUNCTION MAIN()
LOCAL nV:=10,nB,cFoo:=space(10)
    MouseInit(@nB)
    MouseOn()
    cls
    @ 5,10 say "Spin Get" get nV picture "999" SPIN ;
      message "Press + or - to increment/decrement or Left/Right Click "
    @ 6,10 say "FooBar: " get cFoo
    read
    MouseOff()
RETURN nil
#endif

/*-----------------------------------------------------------------------
   Function: SpinGetRdr(oGet)
 Parameters: oGet - Get object
      Notes: "spinner" get reader
-----------------------------------------------------------------------*/
FUNCTION SpinGetRdr(oGet)
LOCAL cGetMsg,lSetMouse,nR,nC,nW
    #ifndef NO_MOUSE
      lSetMouse:=SetMouse()
    #endif
    nR:=oGet:row()
    nW:=len(oGet:picture)
    nC:=oGet:col()+nW
    @ nR,nC say ""
    CargoPut(oGet, {"HOTSPOT", {nR,nC}})
    if (GetPreValidate(oGet))
        oGet:setFocus()
        DispGetMsg(oGet)

        do while (oGet:exitState == GE_NOEXIT)
            if (oGet:typeOut)
                oGet:exitState := GE_ENTER
            endif

            do while (oGet:exitState == GE_NOEXIT)
                #ifndef NO_MOUSE
                  SetMouse(.t.)
                #endif
                SpinGetApplyKey(oGet, WaitEvent())
            enddo

            if (! GetPostValidate(oGet))
                oGet:exitState := GE_NOEXIT
            endif
        enddo
        oGet:killFocus()
        DispGetMsg(oGet, .t.)
        @ nR,nC say "  "
    endif
RETURN

/*-----------------------------------------------------------------------
   Function: SpinGetApplyKey(oGet, aEvent)
 Parameters: oGet - get object
             aEvent - event array returned by WaitEvent()
      Notes: handles keystrokes for spinner get reader
-----------------------------------------------------------------------*/
STATIC FUNCTION SpinGetApplyKey(oGet, aEvent)
LOCAL cKey,cur_set,nKey,aHot

    do case
        case aEvent[EV_TYPE] == EV_KEY
            nKey := aEvent[EV_KEY_VAL]
            cKey := upper(chr(nKey))
        case aEvent[EV_TYPE] == EV_SGL_CLICK
            aHot := CargoGet(oGet, "HOTSPOT")
            if aEvent[EV_ROW] == aHot[1] .and. aEvent[EV_COL] == aHot[2]
                if aEvent[EV_BTN] == EV_LEFT_BTN
                    cKey := "+"
                elseif aEvent[EV_BTN] == EV_RIGHT_BTN
                    cKey := "-"
                endif
            else
                // pass the event array to getsyspp's GetApplyKey in the nKey parm
                nKey := aEvent
            endif
        case aEvent[EV_TYPE] == EV_DBL_CLICK
            nKey := aEvent
    endcase

    do case
        case (cKey=="+" .and. oGet:type=="N")
            oGet:buffer:=transform(oGet:unTransform() + 1, oGet:picture)
            oGet:changed := .t.
            oGet:display()

        case (cKey=="-" .and. oGet:type=="N")
            oGet:buffer:=transform(oGet:unTransform() - 1, oGet:picture)
            oGet:changed := .t.
            oGet:display()

        otherwise
            GetApplyKey(oGet, nKey)
    endcase

RETURN
