*:*********************************************************************
*:
*:        Program: SWAPDEMO.PRG
*:
*:         System: SWAP DEMO for Clipper Swapping System
*:         Author: Kevin Bednar
*:      Copyright (c) 1991, Kevin Bednar
*:  Last modified: 03/19/91      1:42
*:
*:  Procs & Fncts: DEMO
*:
*:          Calls: DEMO           (procedure in SWAPDEMO.PRG)
*:
*:      Documented 03/19/91 at 01:45                SNAP!  version 4.02
*:*********************************************************************
PUBLIC swap_cmd,swap_drv,err       && Define Global Variables
PRIVATE sswap_cmd,sswap_drv        && Define Private Variables
EXTERNAL clipswap                  && Define Swap Procedure as External
sswap_cmd = "                   "  && Initialize Variables
sswap_drv = " "
DO demo
*!*********************************************************************
*!
*!      Procedure: DEMO
*!
*!      Called by: SWAPDEMO.PRG                  
*!               : DEMO           (procedure in SWAPDEMO.PRG)
*!
*!          Calls: DEMO           (procedure in SWAPDEMO.PRG)
*!               : CLIPSWAP.PRG
*!
*!*********************************************************************
PROCEDURE demo
SET COLOR TO "gr+/b,b+/w,,b,w+/b"
CLEAR SCREEN
@6,18 SAY "SWAP SYSTEM FOR CLIPPER S'87 DEMO PROGRAM "
@8,16 TO 13,60 DOUBLE
@9,17say SPACE(42)
@10,17 SAY "Command to execute: "  && Command to execute upon swapping
@10,37 GET sswap_cmd
@10,57 SAY SPACE(3)
@11,17 SAY "Drive to swap to: "    && Drive to swap to
@11,35 GET sswap_drv
@11,36 SAY SPACE(23)
@12,17say SPACE(42)
READ
swap_cmd = sswap_cmd
swap_drv = sswap_drv
IF ! Isdrive(sswap_drv)            && Check to see if drive is valid
   CLEAR SCREEN                     && Display error if not
   @10,28 SAY "Drive not available."
   @11,30 SAY "Please Re-enter."
   @12,24 SAY "Press any key to continue."
   INKEY(0)
   demo()
ELSE
   drv = UPPER(sswap_drv)           && If valid drive convert letter to
   DO CASE                          && number for DISKSPACE() function
   CASE drv = "A"
      drv_chk = 1
   CASE drv = "B"
      drv_chk = 2
   CASE drv = "C"
      drv_chk = 3
   CASE drv = "D"
      drv_chk = 4
   CASE drv = "E"
      drv_chk = 5
   ENDCASE
ENDIF
IF DISKSPACE(drv_chk) < 700000    && Check available space.
   CLEAR SCREEN                    && Must be at least 700k to be safe.
   SET COLOR TO "R+*/B"            && If not enough display error message.
   @10,24 SAY "Not enough space on drive to swap!"
   SET COLOR TO "W+/B"
   @11,25 SAY "Need at least 700K free to swap!"
   @12,29 SAY "Please try another drive."
   SET COLOR TO "GR+/B"
   @13,28 SAY "Press any key to try again."
   INKEY(0)
   demo()
ENDIF
CLEAR SCREEN
SET COLOR TO                       && If all ok then swap!
clipswap()                         && Call swap procedure
CLEAR SCREEN
IF err > 0                         && Check return code-anything other than 0 an ERROR!
   ? CHR(7)
   SET COLOR TO "R+*/N"             && Display error msg.
   @10,25 SAY "Error in swapping program!!"
   SET COLOR TO "W+/N"
   @11,10 SAY "Check Drive specifier or Program Execution Path for errors!"
   SET COLOR TO "GR+/N"
   @12,25 SAY "Press any Key to continue."
   INKEY(0)
ELSE
   SET COLOR TO "W+*/N"             && Show successful completion msg.!
   @10,31 SAY "  Swap Successful!  "
   SET COLOR TO "GR+/N"
   @11,28 SAY "Press any key to continue"
   INKEY(0)
ENDIF
SET COLOR TO
SET Cursor ON
CLEAR SCREEN
QUIT                          && Exit demo
*: EOF: SWAPDEMO.PRG
