/*
   File: AlphN.prg

   Author: Mark Pfeifer

   Compiler:  Turbo-C (tm), v 1.5
              Clipper (tm), Summer '87

   Revision:
      2-Mar-88    initial coding

   Copyright: none, placed in the public domain by author

*/

   /* Clipper-C interface header info */
   /*    Note: This is a modified version of EXTEND.H and NANDEF.H */
   #include <CLIP_C.H>

/* func AlphaN

   syntax:   AlphaN(<exp-N>)
      where <exp-N> is number from 0 to 35 to be converted to an Alpha
   returns:  string of 1 char

   This function comes in handy when accessing multiple parameters,
   for example, see the UpEq function.

   AlphaN converts a number from 0 to 35 to an Alpha as follows:

              <exp-N>  return value
                 0        '0'
                 1        '1'
                     ...
                 9        '9'
                10        'A'
                11        'B'
                     ...
                34        'Y'
                35        'Z'

*/

CLIPPER AlphaN()
   {
   /* local variables */

   CL_ni pN ;      /* C var to receive parameter */
   CL_c mRet ;     /* C var to be used to pass result back */

   if ( PCOUNT==1 )   /* Check to make sure a parameter was passed */
      {
      /* get parameters */
         if ( !ISNUM( (CL_par)1 ) ) goto err_out ;

         pN=_parni( (CL_par)1 ) ;
         if ( pN>35  || pN<0 ) goto err_out ;

      /* main code */
         mRet= (CL_c)_exmgrab( (CL_msiz)2 ) ;  /* grab 2 bytes to use */
         if (!mRet ) goto err_out ;        /* check to be sure we got it */

         mRet[0]= pN<10 ? pN+48 : pN+55 ;  /* do conversion */
         mRet[1]= 0 ; /* append null terminator */

         _retc(mRet) ;  /* return string to clipper */

         _exmback( (CL_mptr)mRet, (CL_msiz)2 ) ; /* give the 2 bytes back */

      }

   else
      {
      /* invalid parms code */
      err_out:
         _retc( (CL_c)"" ) ;

      }
   /* end of function */
   }
