/*******************************************************************************
*     Program Name: MENU.PRG                                                   *
*           Author: Ronald J. Laska                                            *
*   Last Mod. Date: Fri  11-15-1991                                            *
*   Last Mod. Time: 14:13:02                                                   *
*         Language: Clipper 5.01                                               *
*            Lines: 390                                                        *
* Purpose/Comments: To Create A Menu Using TBrowse That Will Scroll And        *
*                   Display A Message.  Also Functions For Scroll Bar          *
*                   Manipulation.  Also Shadow Drawing.  Also CheckBox Menu.   *
*******************************************************************************/

// *** MENU WITH MESSAGE ***

// PASS TOP, LEFT, BOTTOM, RIGHT, (NUMERIC)
// TWO-DIM ARRAY OF CHOICES + MESSAGES  i.e. {{PROMPT1,MESG1},{PROMPT2,MESG2}}, (ARRAY)
// ESCAPE KEY TOGGLE(.T. WILL LET ESC EXIT), (LOGICAL)
// COLOR FOR BOX AND BORDER, (CHAR such as "N/W")
// COLOR FOR MENU ITEMS, (CHAR)
// COLOR FOR HIGHLITES. (CHAR)

// RETURNS ARRAY ELEMENT NUMBER SELECTED OR 0 IF ABORTED (NUMERIC)

FUNCTION messmenu(t,l,b,r,choices,esctoexit,color1,color2,color3)

LOCAL hole,BO,i:=1,newchoices:={},hole2,COL,k,key,found,oldcursor,maxlen,lmax,;
      rmax,oldcolor,bar

IF VALTYPE(t)<>"N" .OR. VALTYPE(l)<>"N" .OR. VALTYPE(b)<>"N" .OR. VALTYPE(r)<>"N" .OR. EMPTY(choices)
    RETURN 0
END  // IF
IF VALTYPE(color1)<>"C"
    color1:="W/N"
END  // IF
IF VALTYPE(color2)<>"C"
    color2:=color1
END  // IF
IF VALTYPE(color3)<>"C"
    color3:="N/W"
END  // IF
maxlen:=0

//  ACCOUNT FOR NUMBERS BEING PASSED
AEVAL(choices,{|x| AADD(newchoices,IF(VALTYPE(x[1]) = "N",{ALLTRIM(STR(x[1])),x[2]},{x[1],x[2]}))})

//  DETERMINE LENGTH OF LONGEST MESSAGE
AEVAL(choices,{|x| maxlen:=IF(LEN(x[2]) > maxlen,LEN(x[2]),maxlen)})

lmax:=ROUND((l+r)/2,0)-ROUND((maxlen/2),0)-1  // DETERMINE
IF lmax>=l
    lmax:=l-1                                 // BORDERS
END  // IF
rmax:=ROUND((l+r)/2,0)+ROUND((maxlen/2),0)+1  // FOR
IF rmax<=r
    rmax:=r+1                                 // MESSAGE
END  // IF
maxlen:=(rmax-1)-lmax
oldcursor:=SETCURSOR(0)

// DRAW BOXES FOR MENUS
hole:=SAVESCREEN(t,l,b+1,r+1)
hole2:=SAVESCREEN(b,lmax,b+3,rmax+1)
oldcolor:=SETCOLOR(color1)
@ t,l CLEAR TO b,r
@ t,l TO b,r DOUBLE
boxshadow(t,l,b,r)  // DRAW DROPSHADOW
@ b,lmax CLEAR TO b+2,rmax
@ b,lmax TO b+2,rmax DOUBLE
boxshadow(b,lmax,b+2,rmax)  // DRAW DROPSHADOW
@ b,l SAY CHR(202)
@ b,r SAY CHR(202)

// SET UP SCROLL BAR
bar:=NEWSCROLLBAR(t,r,b,color3,1)
bar:=DISPLAYSCROLL(bar)
updatescroll(bar,bar[6],LEN(newchoices),.T.)
SETCOLOR(color2+","+color3)

// SET UP BROWSE OBJECT
BO:=TBROWSENEW(t+1,l+1,b-1,r-1)
BO:SKIPBLOCK:={|n| k:=IF(ABS(n)>=IF(n>=0,LEN(newchoices)-i,i-1),IF(n>=0,LEN(newchoices)-i,1-i),n),i:=i+k,k}
BO:GOBOTTOMBLOCK:={|| i:=LEN(newchoices)}
BO:GOTOPBLOCK:={|| i:=1}

COL:=TBCOLUMNNEW(,{|| newchoices[i][1]})
COL:WIDTH:=(r-(l+1))

BO:ADDCOLUMN(COL)
found:=0

// EXECUTE MENU
WHILE .T.
    WHILE(!BO:STABILIZE())
    END  // WHILE
    IF (BO:HITBOTTOM .AND. key <> 3)   // PAGE DOWN
        BO:GOTOP()
        BO:REFRESHALL()
        LOOP
    ELSEIF (BO:HITTOP .AND. key <> 18) // PAGE UP
        BO:GOBOTTOM()
        BO:REFRESHALL()
        LOOP
    END  // IF
    @ b+1,lmax+1 SAY PADC(newchoices[i][2],maxlen)  // SHOW MESSAGE
    updatescroll(bar,i,LEN(newchoices),.T.)         // UPDATE SCROLL BAR
    key:=INKEY(0)
    DO CASE
    CASE key=5   // UP
        BO:UP()
    CASE key=24  // DOWN
        BO:DOWN()
    CASE key=18  // PG UP
        BO:PAGEUP()
    CASE key=3   // PG DOWN
        BO:PAGEDOWN()
    CASE key=1   // HOME
        BO:GOTOP()
    CASE key=6   // END
        BO:GOBOTTOM()
    CASE (key>=32 .AND. key<=127)  // ASCII CHARACTER
        found:=ASCAN(newchoices,{|x| UPPER(x[1]) = UPPER(CHR(key))},i+1)
        IF found = 0
            found:=ASCAN(newchoices,{|x| UPPER(x[1]) = UPPER(CHR(key))})
            IF found <> 0
                BO:GOTOP()
                i:=found
            END  // IF
        ELSE
            i:=found
        END  // IF
        BO:REFRESHALL()
    CASE key=13  // ENTER
        RESTSCREEN(t,l,b+1,r+1,hole)
        RESTSCREEN(b,lmax,b+3,rmax+1,hole2)
        SETCURSOR(oldcursor)
        SETCOLOR(oldcolor)
        RETURN i
    CASE key=27  // ESC
        IF esctoexit
            RESTSCREEN(t,l,b+1,r+1,hole)
            RESTSCREEN(b,lmax,b+3,rmax+1,hole2)
            SETCURSOR(oldcursor)
            SETCOLOR(oldcolor)
            RETURN 0
        END  // IF
    END  // CASE
END  // WHILE

RETURN 0  // MESSMENU


// *** CHECK BOX MENU ***

// PASS TOP, LEFT, BOTTOM, RIGHT, (NUMERIC)
// ARRAY OF CHOICES, (ARRAY)
// COLOR FOR BOX AND BORDER, (CHAR)
// COLOR FOR MENU ITEMS, (CHAR)
// COLOR FOR HIGHLITES. (CHAR)

// RETURNS ARRAY OF SELECTED ITEMS. (ARRAY)

FUNCTION checkmenu(t,l,b,r,choices,color1,color2,color3)

LOCAL hole,BO,i:=1,newchoices:={},COL,k,key,oldcursor,oldcolor,bar,;
      selected:={},selcol:={},SEL,j

IF VALTYPE(t)<>"N" .OR. VALTYPE(l)<>"N" .OR. VALTYPE(b)<>"N" .OR. VALTYPE(r)<>"N" .OR. EMPTY(choices)
    RETURN 0
END  // IF
IF VALTYPE(color1)<>"C"
    color1:="W/N"
END  // IF
IF VALTYPE(color2)<>"C"
    color2:=color1
END  // IF
IF VALTYPE(color3)<>"C"
    color3:="N/W"
END  // IF

// ACCOUNT FOR NUMBERS BEING PASSED
AEVAL(choices,{|x| AADD(newchoices,IF(VALTYPE(x) = "N",ALLTRIM(STR(x)),x))})

// DRAW BOX FOR MENU
oldcursor:=SETCURSOR(0)
hole:=SAVESCREEN(t,l,b+1,r+3)
oldcolor:=SETCOLOR(color1)
@ t,l CLEAR TO b,r+2
@ t,l TO b,r+2 DOUBLE
boxshadow(t,l,b,r+2)  // DRAW DROPSHADOW

// SET UP SCROLL BAR
bar:=NEWSCROLLBAR(t,r+2,b,color3,1)
bar:=DISPLAYSCROLL(bar)
updatescroll(bar,bar[6],LEN(newchoices),.T.)
SETCOLOR(color2+","+color3)

// SET UP BROWSE OBJECT
BO:=TBROWSENEW(t+1,l+1,b-1,r+1)
BO:SKIPBLOCK:={|n| k:=IF(ABS(n)>=IF(n>=0,LEN(newchoices)-i,i-1),IF(n>=0,LEN(newchoices)-i,1-i),n),i:=i+k,k}
BO:GOBOTTOMBLOCK:={|| i:=LEN(newchoices)}
BO:GOTOPBLOCK:={|| i:=1}

// SET UP SELECTION COLUMN
FOR j:=1 TO LEN(newchoices)
    AADD(selcol," ")
NEXT  // J

COL:=TBCOLUMNNEW(,{|| selcol[i]})
COL:WIDTH:=1
BO:ADDCOLUMN(COL)

COL:=TBCOLUMNNEW(,{|| newchoices[i]})
BO:ADDCOLUMN(COL)

BO:COLPOS:=2

// EXECUTE MENU
WHILE .T.
    WHILE(!BO:STABILIZE())
    END  // WHILE
    IF (BO:HITBOTTOM .AND. key <> 3)   // PAGE DOWN
        BO:GOTOP()
        BO:REFRESHALL()
        LOOP
    ELSEIF (BO:HITTOP .AND. key <> 18) // PAGE UP
        BO:GOBOTTOM()
        BO:REFRESHALL()
        LOOP
    END  // IF
    updatescroll(bar,i,LEN(newchoices),.T.)  // UPDATE SCROLL BAR
    key:=INKEY(0)
    DO CASE
    CASE key=5   // UP
        BO:UP()
    CASE key=24  // DOWN
        BO:DOWN()
    CASE key=18  // PG UP
        BO:PAGEUP()
    CASE key=3   // PG DOWN
        BO:PAGEDOWN()
    CASE key=1   // HOME
        BO:GOTOP()
    CASE key=6   // END
        BO:GOBOTTOM()
    CASE key=13  // ENTER
        IF selcol[i] = CHR(251)
            selcol[i]:=" "
        ELSE
            selcol[i]:=CHR(251)
        END  // IF
        BO:REFRESHCURRENT()
    CASE key=27  // ESC
        EXIT
    END  // CASE
END  // WHILE
RESTSCREEN(t,l,b+1,r+3,hole)
SETCURSOR(oldcursor)
SETCOLOR(oldcolor)
FOR j:=1 TO LEN(selcol)
    IF selcol[j] = CHR(251)
        AADD(selected,j)
    END  // IF
NEXT  // J

RETURN selected  // CHECKMENU


// *** INITIALIZE NEW SCROLL BAR ***

// PASS TOP,LEFT,BOTTOM,RIGHT, (NUMERIC)
// COLOR, (CHAR)
// STARTING POSITION (NUMERIC)

// RETURNS ARRAY OF SCROLLBAR INFORMATION (ARRAY)

FUNCTION newscrollbar(toprow,topcol,botrow,thecolor,startpos)

LOCAL bararray:=ARRAY(6)

bararray[1]:= toprow
bararray[2]:= topcol
bararray[3]:= botrow
bararray[4]:= topcol
IF thecolor == NIL
    thecolor:="W/N"
ENDIF
bararray[5]:=thecolor
IF startpos == NIL
    startpos:=1
ENDIF
bararray[6]:=startpos

RETURN bararray  // NEWSCROLLBAR


// DISPLAY SCROLL BAR

// PASS ARRAY OF SCROLL BAR INFORMATION (ARRAY)

// RETURNS ARRAY OF SCROLL BAR INFORMATION (ARRAY)

FUNCTION displayscroll(bararray)

LOCAL oldcolor,therow

DISPBEGIN()
oldcolor:=SETCOLOR(bararray[5])
@ bararray[1],bararray[2] SAY CHR(24)  // UP ARROW
@ bararray[3],bararray[4] SAY CHR(25)  // DOWN ARROW

// DRAW THE BACKGROUND
FOR therow:=(bararray[1]+1) TO (bararray[3]-1)
    @ therow,bararray[2] SAY CHR(176)  // VERY HAZY BOX
NEXT
DISPEND()
SETCOLOR(oldcolor)

RETURN bararray  // DISPLAYSCROLL


// UPDATE SCROLL BAR WITH NEW POSITION

// PASS ARRAY OF SCROLL BAR INFORMATION, (ARRAY)
// CURRENT POSITION, (NUMERIC)
// TOTAL ITEMS (NUMERIC)
// FORCE UPDATE (LOGICAL)  (Used To Display Marker Initially)

// RETURNS ARRAY OF SCROLL BAR INFORMATION (ARRAY)

FUNCTION updatescroll(bararray,current,total,forceupdate)

LOCAL oldcolor,newpos,scrollhigh:=(bararray[3]-1)-(bararray[1])

IF total < 1
    total:=1
ENDIF
IF current < 1
    current:=1
ENDIF
IF current > total
    current:=total
ENDIF
IF forceupdate == NIL
    forceupdate:=.F.
ENDIF
oldcolor:=SETCOLOR(bararray[5])

// DETERMINE THE NEW POSITION
newpos:=ROUND((current/total)*scrollhigh,0)
newpos:=IF(newpos < 1,1,newpos)
newpos:=IF(current == 1,1,newpos)
newpos:=IF(current >= total,scrollhigh,newpos)

// OVERWRITE OLD POSITION (IF DIFFERENT), THEN DRAW NEW ONE
IF newpos <> bararray[6] .OR. forceupdate
    DISPBEGIN()
    @ (bararray[6] + bararray[1]),bararray[2] SAY CHR(176)  // VERY HAZY BOX
    @ (newpos + bararray[1]),bararray[2] SAY CHR(178)       // HAZY BOX
    DISPEND()
    bararray[6] := newpos
ENDIF
SETCOLOR(oldcolor)

RETURN bararray  // UPDATESCROLL


// DRAW DROP SHADOW

// PASS TOP,LEFT BOTTOM AND RIGHT OF OBJECT TO BE SHADOWED (NUMERIC)

// RETURNS NOTHING (NIL)

FUNCTION boxshadow(top,left,bottom,right)

LOCAL stop,sleft,sbottom,sright
   
stop:=sbottom:=MIN(bottom+1, MAXROW())
sleft:=left+1
sright:=MIN(right+1, MAXCOL())
RESTSCREEN(stop,sleft,sbottom,sright,;
          TRANSFORM(SAVESCREEN(stop,sleft,sbottom,sright),;
          REPLICATE("X", sright-sleft+1)))
stop:=top+1
sleft:=sright:=MIN(right+1,MAXCOL())
sbottom:=bottom
RESTSCREEN(stop,sleft,sbottom,sright,;
          TRANSFORM(SAVESCREEN(stop,sleft,sbottom,sright),;
          REPLICATE("X",sbottom-stop+1)))

RETURN NIL  // BOXSHADOW
