/* gterm.h
**	
** Header file for CLIPPER 5.01 generic terminal APIs
*/


/* Make sure the extend system definitions are available */
#ifndef CLIPPERDEFS
#include <extend.h>
#endif

/* Rows and Columns, screen dimensions */
extern quant	_gtMaxRow(void);
extern quant	_gtMaxCol(void);
extern void		_gtScrDim(quant *, quant *);
extern void		_gtSetPos(quant , quant);
extern void		_gtGetPos(quant *, quant *);

/* Display context: DispBegin/DispEnd */
extern void		_gtPreExt(void);
extern void		_gtPostExt(void);

/* Actual display functions */
extern void		_gtWrite(char *, quant);
extern void		_gtWriteAt(quant, quant, char *, quant);

/* Display Adapter setting */
extern void		_gtSetSnowFlag(long);
extern void		_gtSetMode(quant, quant);

/* Screen saving/restoring */
extern void		_gtSave(quant, quant, quant, quant, byte *);
extern void		_gtRest(quant, quant, quant, quant, byte *);
extern void		_gtRectSize(quant, quant, quant, quant, quant *);

/* Boxes drawing */
extern void		_gtBox(quant, quant, quant, quant, char *);
extern void		_gtBoxS(quant, quant, quant, quant);
extern void		_gtBoxD(quant, quant, quant, quant);

/* Windowing */
extern void		_gtScroll(quant, quant, quant, quant, int);

/* Misceallanous */
extern void		_gtRepChar(quant, quant, char, quant);
