; CLIPINT.ASM
;
; by Michael Brill
; 
;
;
   PAGE  60,132
   PUBLIC  INTERRUPT
   include extenda.mac

;***************************************************
_code segment byte public

assume   cs:_code,ds:nothing,es:nothing
;---------------------------------------------------
;
;     Syntax: interrupt(interrupt number,AX,BX,CX,DX)
;
;     Return: value in AX, after the interrupt has occurred
;
;     Params: interrupt number - the interrupt (0-255) to execute
;             AX,BX,CX,DX      - values to be put into the ax-dx
;                                registers before interrupt
;
;-----------------
INTERRUPT   PROC  FAR
   
   push  bp       ;
   mov   bp,sp    ;
   push  ds       ; Save Clipper's registers
   push  es       ;
      
   get_pcount     ; How many parameters?
   cmp   ax,5     ; int_num + ax,bx,cx,dx = five parameters
   je    _ok      ; Yes there are five so continue
   jmp   _exit    ;  no , return to clipper


                  ; Get the values for registers
_ok:
   get_int  2     ; Get AX
   push ax
   get_int  3     ; Get BX
   push ax
   get_int  4     ; Get CX
   push ax
   get_int  5     ; Get DX
   push ax
   get_int  1     ; Get the interrupt number
   push ax

   pop ax                              ; Get the interrupt number and poke it into
   mov byte ptr CS:_intplace+1,al      ; where the int # goes to form the INT x instruction

   pop  dx        ; Grab the rest of the registers
   pop  cx
   pop  bx
   pop  ax


_intplace  dw 00cdH    ;  Execute the interrupt



_exit:
   pop   es       ;
   pop   ds       ; Restore Clipper's registers
   pop   bp       ;


 
  ret_int  ax     ; Return the value in AX

  ret             ; Go on back to Clipper

INTERRUPT  ENDP
;-----------------------------------------------------------
_code ends
;***********************************************************
        END  
