* proc makehelp
* note: on wait to or inkey the procedure only is passed perhaps we can
* find a way to do like the help.prg and if not found look for a default
* memo for the procedure and force the save as default.
*
*
* add instructions for ACHOICE to callhelp
*
PARAMETERS p,l,v
if P = 'MAKEHELP'
  RETURN
ENDIF

PUBLIC done,altered,savedit,newbox,coloropt,curcolor,defcolor
PUBLIC trow,tcol,temp_left,temp_right,temp_top,temp_bot


  update = .T.                && update the memo field
  deja_vu = .F.               && set first time through flag
  altered = .F.               && set altered or not flag
  savedit = .F.               && set saved or not flag
  newbox  = .F.               && new box... not yet!!!
  word_wrap = .T.             && set wordwrap on
  scrl_on = .F.               && set scroll on
  ins_on  = .T.               && set insert off

  curntrow = iif(row()>3 .and. row()<19,row(),4)
  curntcol = iif(col()>5 .and. col()<65,col(),6)

  goback = SELECT()                     && get current work area
  old_color = setcolor()                && get existing color
  store "n/w,w/n" to defcolor,curcolor  && set default and current color
  coloropt = "N  B  G  BG R  GR W  N+ B+ G+ BG+R+ GR+W+ "
  STORE SPACE(4000) TO full_scr
  SAVE SCREEN to full_scr        && save current screen

  SET SOFTSEEK ON
  SET SCOREBOARD OFF
  scrframe = "ͻȺ "
  solidbox = ""

* check to see if HELP.DBF exists, if so, use it
  IF !FILE("HELP.DBF")
    set color to defcolor
    @ 00,10,03,70 BOX scrframe
    @ 01,11 SAY "There is no HELP file available. Would you like a HELP"
    @ 02,27 SAY "file to be generated? "
    IF !verify()
      RESTORE SCREEN from full_scr
      SETCOLOR(old_color)
      release top,bottom,left,right,done,altered
      release trow,tcol,temp_left,temp_right,temp_top,temp_bot
      RETURN
    ENDIF

    DO DOhelp                          && create a new HELP.DBF

  ENDIF

* open the HELP file and find the key (procedure+variable)
  SELECT 9
  USE Help INDEX Help
  search = SUBSTR(p+"          ",1,10) +v
  temp = upper(alltrim(p))
  SEEK search
  IF FOUND()
    DO Editbox
    IF altered
      replace lupdate with date(),timeupdt with time()
    ENDIF
  ENDIF
  IF !FOUND()
     LOCATE FOR help->PROCEDURE = temp .AND. help->VARIABLE = ' '
   IF FOUND()
       DO Editbox
       IF altered
         replace lupdate with date(),timeupdt with time()
       ENDIF
   ELSE
    set color to defcolor
    @ 00,10,04,71 BOX scrframe
* THIS LINE IS TO DISPLAY PROCEDURE LINE AND VARIABLE WHERE HELP IS CALLED
* TO ASSIST IN BUILDING HELP FILES.
* IF COMPILE WITH -L OPTION THE LINE NUMBER WILL ALWAYS BE '0'
*
    @ 01,12 SAY  'Procedure: '+P+'  Line: '+transform(L,"9999")+'  Variable: '+V
*        Ŀ
*         Procedure: pppppppppp  Line: llll   Variable: vvvvvvvvvvvv 
*         There is no HELP for this section.  Would you like to make 
*                          a HELP screen for this?                   
*        
    @ 02,12 SAY "There is no HELP for this section.  Would you like to make"
    @ 03,29 SAY "a HELP screen for this? "
    IF  VERIFY()
       APPEND BLANK
       newbox = .T.
       * create new box in default location
       replace top with 0,left with 0,bottom with 0,right with 0,;
       forecolor with "N  ",backcolor with "W  "
       replace lupdate with date(),timeupdt with time()
       store space(4000) to memoscr
       IF curntrow < 17
         * box below current item
         replace top with curntrow + 1
         replace left with curntcol - 2
         replace bottom with curntrow + 5
         replace right with curntcol + 10
       ELSE
         * box above current item
         replace top with curntrow -7
         replace left with curntcol - 2
         replace bottom with curntrow - 2
         replace right with curntcol + 10
       ENDIF
       REPLACE helpkey WITH "&search",;
       procedure with p,variable with v,line with transform(l,"9999")
       DO Editbox
    ENDIF
   ENDIF
  ENDIF

* put it back like we found it
  RESTORE SCREEN from full_scr
  IF cursrset
     set cursor on
  ENDIF
  tempgo = STR(goback)
  SELECT &tempgo
  SETCOLOR(old_color)
  release top,bottom,left,right,done,altered
  release trow,tcol,temp_left,temp_right,temp_top,temp_bot
RETURN                                 && back to calling program

******************
PROCEDURE Editbox
******************
  set cursor on
  init_count = 1
  editing = .T.
  done = .F.
  curcolor = forecolor+"/"+backcolor+','+backcolor+"/"+forecolor

 DO WHILE !done
    set color to &curcolor
    @ 00,10,03,70 BOX scrframe
    @ 01,12 SAY  'Procedure: '+P+'  Line: '+transform(L,"9999")+'  Variable: '+V
    @ 02,12 say "       Esc to return, CTRL-F1 for help on MAKEHELP  "
    @ top+1,left+1,bottom+1,right+1 BOX solidbox    && Draw the help box
    @ top,left,bottom,right BOX scrframe
    line_length = right-left-4
    page_length = bottom-top-2
    no_lines = MLCOUNT(helpscr,line_length)
    no_pages = INT(no_lines/page_length+1)
    if no_pages > 1
       @ bottom,left+3 say TRAN(no_pages,"999")+" pages...."
    endif
    REPLACE helpscr WITH MEMOEDIT(helpscr,top+1,left+2,bottom-1,right-2,.T.,"mfunc")
 ENDDO
RETURN

*****************
FUNCTION Movecurs
*****************
DO CASE
  CASE cursor = 5
      IF trow - 1 > 0
         trow = trow - 1
      ENDIF
  CASE cursor = 4
      IF trow + 1 < 79
         tcol = tcol + 1
      ENDIF
  CASE cursor = 19
      IF tcol - 1 > 0
         tcol = tcol - 1
      ENDIF
  CASE cursor = 24
      IF trow + 1 < 23
         trow = trow + 1
      ENDIF
  CASE cursor = 13 .OR. cursor = 27
      RETURN(.F.)
ENDCASE
RETURN(.T.)

***************
FUNCTION Verify
***************
PARAMETERS comp,extra_key
CHOICE = ' '
SET CONSOLE OFF
WAIT TO CHOICE
SET CONSOLE ON
CHOICE = UPPER(CHOICE)
IF CHOICE = 'Y'
  RETURN(.T.)
ELSE
  RETURN(.F.)
ENDIF

**************
FUNCTION mfunc
**************
* keystroke function for MEMOEDIT

PARAMETERS mode, line, col
PRIVATE keypress
ret_val = 0
DO CASE
   CASE mode = 3
     * initialization..global variables "init_count" and "deja_vu"
     IF init_count = 1
       * set initial insert mode
       ins_mode = READINSERT()
       IF (ins_on .AND. .NOT. ins_mode) .OR.;
          (.NOT. ins_on .AND. ins_mode)
          * toggle insert mode
          ret_val = 22
       ELSE
          * insert mode correct
          init_count = 2
       ENDIF
     ENDIF
     IF init_count = 2
       * set initial scroll state (defaults ON if update OFF)
       IF ((.NOT. scrl_on .AND. .NOT. update) .OR.;
          (scrl_on .AND. update)) .AND. .NOT. deja_vu
          * need to toggle
          deja_vu = .T.
          ret_val = 35
       ELSE
          * scroll state correct
          init_count = 3
          deja_vu = .F.
       ENDIF
     ENDIF
     IF init_count = 3
        * set initial word wrap..always defaults ON
        IF .NOT. word_wrap .AND. .NOT. deja_vu
           * need to toggle
           deja_vu = .T.
           ret_val = 34
        ELSE
           * word wrap correct
           init_count = 4
           deja_vu = .F.
        ENDIF
     ENDIF
     IF init_count = 4
       * finished initialization..note that if all defaults are
       * correct we reach this point on the first call
       ret_val = 0
     ENDIF
   CASE mode = 0
      * idle.. do nothing
      ret_val = 0
   OTHERWISE
      * keystroke exception
      keypress = LASTKEY()
       IF mode = 2
         altered = .T.
       ENDIF
       DO CASE
          CASE keypress = 27
            * Esc - exit
            IF .NOT. altered
              * no change
              done = .T.
              ret_val = 27
            ELSE
              * changes have been made to memo
              @ 00,04,02,76 BOX scrframe
              @ 1,15 SAY " [S]ave [A]bandon [R]eturn to edit [D] save as default"
              SET CURSOR OFF
              SET CONSOLE OFF
              WAIT TO RESPONSE
              SET CONSOLE ON
              response = UPPER(RESPONSE)
              DO CASE
                 CASE response = "A"
                    * abort
                    if newbox
                      delete
                       pack
                    endif
                    done = .T.
                    ret_val = 27
                 CASE response = "S"
                    * save and exit
                    done = .T.
                    ret_val = 23
                 CASE response = "D"
                    STORE 'ZZZZZ' TO xV
                    search = SUBSTR(p+"          ",1,10) + xV
                    REPLACE helpkey WITH "&search",;
                    procedure with p,variable with ' '
                    * save and exit as default
                    done = .T.
                    ret_val = 23
                 OTHERWISE
                    * ignore
                    ret_val = 32
                    SET CURSOR ON
              ENDCASE
          ENDIF

        CASE keypress = -20
         * F1..Help for MAKEHELP
         set cursor off
          save screen to tempscr
          @ 00,20  say   "ͻ"
          @ 01,20  SAY   "        HELP screen for MAKEHELP              "
          @ 02,20  SAY   "                                              "
          @ 03,20  SAY   "         Esc - Quit options                   "
          @ 04,20  SAY   "    CTRL-F1  - Show this screen               "
          @ 05,20  SAY   "         F3  - Delete the current line        "
          @ 06,20  SAY   "         F4  - Insert a line at the cursor    "
          @ 07,20  SAY   "         F5  - Toggle word wrap on or off     "
          @ 08,20  SAY   "         F6  - Toggle scroll on or off        "
          @ 09,20  SAY   "         F7  - Shift foreground color         "
          @ 10,20  SAY   "         F8  - Shift background color         "
          @ 11,20  SAY   "         F9  - Read in an ASCII file          "
          @ 12,20  SAY   "         F10 - Redimension the BOX            "
          @ 13,20  SAY   "                                              "
          @ 14,20  say   "Any key to continue....ͼ"
          inkey(0)
         set cursor on
         restore screen from tempscr
         release tempscr
         ret_val = 32

        CASE keypress = -2
         * F3..delete line
         ret_val = 25

        CASE keypress = -3
         * F4..insert line
         ret_val = 14

        CASE keypress = -4 .AND. update
         * F5..toggle word wrap
         word_wrap = .NOT. word_wrap
         ret_val = 34

        CASE keypress = -5
         * F6..toggle scroll lock
         scrl_on = .NOT. scrl_on
         ret_val = 35

        CASE keypress = -6
         * F7..shift foreground color
         curcolor = LEFT(setcolor(),AT(",",setcolor())-1)
         curfore = substr(substr(curcolor,1,AT("/",curcolor)-1)+"   ",1,3)
         curfore = strtran(curfore,"*"," ")
         oldindex = AT("&curfore",coloropt)
         DO CASE
            CASE oldindex = 0
                 foreindex = 1
            CASE oldindex > 0 .AND. oldindex < 40
                 foreindex = oldindex + 3
            CASE oldindex >=40
                 foreindex = 1
         ENDCASE
         curfore = alltrim(substr(coloropt,foreindex,3))
         curback = substr(substr(curcolor,AT("/",curcolor)+1)+"   ",1,3)
         curback = alltrim(curback)
         curcolor = curfore+"/"+curback+","+curback+"/"+curfore
         replace forecolor with curfore
         set color to &curcolor
         altered = .T.
         ret_val = 27

        CASE keypress = -7
         * F8..Shift background color
         curcolor = LEFT(setcolor(),AT(",",setcolor())-1)
         curfore = substr(substr(curcolor,1,AT("/",curcolor)-1)+"   ",1,3)
         curback = substr(substr(curcolor,AT("/",curcolor)+1)+"   ",1,3)
         oldindex = AT("&curback",coloropt)
         DO CASE
            CASE oldindex = 0
                 backindex = 1
            CASE oldindex > 0 .AND. oldindex < 19
                 backindex = oldindex + 3
            CASE oldindex >=19
                 backindex = 1
         ENDCASE

         curfore = alltrim(curfore)
         curback = alltrim(substr(coloropt,backindex,3))
         curcolor = curfore+"/"+curback+","+curback+"/"+curfore
         replace backcolor with curback
         set color to &curcolor
         altered = .T.
         ret_val = 27

        CASE keypress = -8
         * F9..READITIN
         save screen to r_itin
         READITIN()
         restore screen from r_itin
         ret_val = 32

        CASE keypress = -9
         * F10..redimension box
        * get current box position from database
          store helpscr to memoscr
          temp_top = top
          temp_left = left
          temp_bot = bottom
          temp_right = right
       * main loop for redimension box
          DO WHILE .T.
           SET CURSOR OFF
         * repaint original screen and display instructions
           RESTOR SCREEN FROM full_scr
           @ 00,10,02,70 BOX scrframe
           @ 01,15 say "Position TOP,LEFT corner. Press Enter to select."
           save screen to mMOVE
           cursor = 0
           trow = temp_top
           tcol = temp_left
           DRAWBOX(trow,tcol,temp_bot,temp_right,memoscr)
         * loop to set TOP,LEFT corner
           @ 00,10,02,70 BOX scrframe
           @ 01,15 say "Position TOP,LEFT corner. Press Enter to select."
           DO WHILE .T.
             cursor = INKEY(0)
             loop_again = MOVECURS()
             IF !loop_again
               EXIT
             ENDIF
             * if less than minimum box size, move box
             IF tcol > temp_right - 20 .AND. tcol < 60
               temp_right = tcol + 20
               tcol = iif(tcol<60,tcol,59)
             ENDIF
             IF trow > temp_bot - 3 .AND. trow < 20
                temp_bot = trow + 3
                trow = iif(trow<20,trow,19)
             ENDIF
             * redisplay after cursor movement
             RESTORE SCREEN FROM mMOVE
             DRAWBOX(trow,tcol,temp_bot,temp_right,memoscr)
           ENDDO
           STORE trow to temp_top
           STORE tcol to temp_left
         * set up for BOTTOM,RIGHT move
           RESTORE screen from mmove
           @ 01,15 say "Position BOTTOM,RIGHT corner. Press Enter to select."
           save screen to mmove
           DRAWBOX(trow,tcol,temp_bot,temp_right,memoscr)
           cursor = 0
           trow = temp_bot
           tcol = temp_right
           * loop to set BOTTOM,RIGHT corner location
           DO WHILE .T.
            cursor = INKEY(0)
            loop_again = MOVECURS()
            IF !loop_again
             EXIT
            ENDIF
          * if less than minimum box size, move box
            IF tcol < temp_left + 20 .AND. tcol > 20
               temp_left = tcol - 20
               tcol = iif(tcol>20,tcol,21)
            ENDIF
            IF trow < temp_top + 3 .AND. trow > 3
               temp_top = trow - 3
               tcol = iif(trow>3,trow,4)
            ENDIF
            * redisplay after cursor movement
            RESTORE SCREEN FROM mMOVE
            DRAWBOX(temp_top,temp_left,trow,tcol,memoscr)
           ENDDO
           STORE trow to temp_bot
           STORE tcol to temp_right
           @ 00,10,02,70 BOX scrframe
           @ 01,25 SAY "Is this what you wanted?  "
           DRAWBOX(temp_top,temp_left,temp_bot,temp_right,memoscr)
           IF .NOT. VERIFY()
             LOOP
           ELSE
             EXIT
           ENDIF
          ENDDO
           SET CURSOR ON
         * store new box corner locations to HELP.DBF
           REPLACE top WITH temp_top,bottom WITH temp_bot,;
                   left WITH temp_left,right WITH temp_right
           restore screen from full_scr
          altered = .T.
        ret_val = 23

        CASE (keypress = 279 .OR. keypress = 22) .AND. update
         * ^V/Ins/Alt-I..toggle insert mode
         ins_on = .NOT. ins_on
         ret_val = 22

       ENDCASE
ENDCASE

RETURN ret_val

*********
FUNCTION drawbox
PARAMETER t,l,b,r,memoscr
  @ t+1,l+1,b+1,r+1 BOX solidbox
  @ t,l,b,r BOX scrframe
  MEMOEDIT(memoscr,t+1,l+2,b-1,r-2,.F.,.F.)
RETURN .T.

***********
PROCEDURE DOhelp
****************
* creates a help.dbf if none exists!
  SELECT 9
  CREATE zyxyquxy
  USE zyxyquxy
  APPSTRU("HELPKEY","C",22)
  APPSTRU("PROCEDURE","C",10)
  APPSTRU("VARIABLE","C",12)
  APPSTRU("LUPDATE","D",8)
  APPSTRU("TIMEUPDT","C",8)
  APPSTRU("LINE","C",4)
  APPSTRU("TOP","N",2)
  APPSTRU("LEFT","N",2)
  APPSTRU("BOTTOM","N",2)
  APPSTRU("RIGHT","N",2)
  APPSTRU("FORECOLOR","C",3)
  APPSTRU("BACKCOLOR","C",3)
  APPSTRU("HELPSCR","M",10)
  CREATE Help FROM zyxyquxy
  USE
  delete file zyxyquxy.dbf
  USE Help
  INDEX on helpkey TO Help
return

********
FUNCTION appstru
* THIS FUNCTION STICKS THE PROPER STUFF IN THE EXTENDED STRU FILE TO
* CREATE HELP.
param fn,ft,fl
append blank
REPLACE field_name WITH fn,field_type WITH ft,field_len with fl
return .T.

*READITIN.PRG
*****************
FUNCTION READITIN
*****************
STORE spac(20) TO SEARCH_FOR
FILEHANDLE = 0
@ 00,10,02,70 BOX scrframe
@ 01,15 SAY "ENTER FILE NAME ==> " GET SEARCH_FOR PICT ;
"!!!!!!!!!!!!!!!!!!!!!!!" VALID TRY2OPEN(SEARCH_FOR, @FILEHANDLE)
READ
mEXT = substr(alltrim(search_for),3)
@ 01,15 say space(45)
@ 01,15 SAY "Loading File Into Buffer ..."
IF EMPTY(SEARCH_FOR) .OR. LASTKEY() = 27
   @ 01,15 say space(45)
   RETURN(32)
ENDIF
IF FILESIZE(SEARCH_FOR) > 29000
   @ 01,15 say space(45)
   @ 01,15 SAY "File to Large to bring into system. Any key to Continue "
   inkey(0)
   @ 01,15 say space(45)
   RETURN(32)
ENDIF
REWIND(FILEHANDLE)
READ_AMT = 1
BYTS_READ = 80
BFFSTRING = " "
BYTS_READ = FREAD(FILEHANDLE, @BFFSTRING, READ_AMT)
*BFFSTRING = STRTRAN(STRTRAN(ALLTRIM(BFFSTRING), CHR(252),CHR(13)+CHR(10)),CHR(251), CHR(13)+CHR(10))
if asc(bffstring) < 32 .or. asc(bffstring) >127
  if asc(bffstring) # 10 .and. asc(bffstring) # 12 .and. asc(bffstring) # 13
    @ 01,15 say space(45)
    @ 01,15 SAY "Not an ASCII file. Any key to Continue "
    inkey(0)
    @ 01,15 say space(45)
    RETURN(32)
  endif
ENDIF
REWIND(FILEHANDLE)
READ_AMT = 80
BYTS_READ = 80
BFFSTRING = SPACE(160)
BACKOUT = ""
DO WHILE BYTS_READ == READ_AMT
  BYTS_READ = FREAD(FILEHANDLE, @BFFSTRING, READ_AMT)
  BFFSTRING = STRTRAN(STRTRAN(ALLTRIM(BFFSTRING), CHR(252),CHR(13)+CHR(10)),CHR(251), CHR(13)+CHR(10))
  BACKOUT = BACKOUT + STRTRAN(BFFSTRING, CHR(219), "")
  BFFSTRING = SPACE(160)
ENDDO
FCLOSE(FILEHANDLE)
KEYBOARD BACKOUT
RETURN(32)

*****************
FUNCTION FILESIZE
*****************
PARAM THEFILE
THEFILE = UPPER(ALLTRIM(THEFILE))
IF !FILE(THEFILE)
  RETURN(0)
ENDIF
DECLARE FNAME[1], FSIZE[1]
ADIR(THEFILE, FNAME, FSIZE)
RETURN(FSIZE[1])

*****************
FUNCTION TRY2OPEN
*****************
PARAM I_O_FILE, I_O_HANDLE
* I_O_HANDLE IS PASSED BY REFERENCE
IF EMPTY(I_O_FILE)
  RETURN(.F.)
ENDIF
I_O_HANDLE = FOPEN(I_O_FILE)
RETURN( ( FERROR() = 0 ) )

***************
FUNCTION REWIND
***************
PARAM R_HANDLE
FSEEK(R_HANDLE, 0)
RETURN(.T.)

