***
*** Program: CALLHELP.PRG : Code additions for HELP system
*** Copyright 1989, Royce A. Engler
*** Updated June 20, 1989
***
*  This program is released to the public domain, and is not shareware,
*  however, a $10 donation will be cheerfully accepted (I'm generous, but
*  not dumb).  This program works in the applications I have built.
*  I make no guarantees about how it will work in the programs YOU write.
*
*           Royce Engler
*           20723 Kendra Lane
*           Katy, TX 77450
*
*

*  This file is an annotated sample file which demonstrates how to use
*  the HELP and MAKEHELP programs.

* The module HELP.PRG is the runtime module for HELP and does not allow
* making changes to the help screen. It does save the calling line
* number to the HELP database.  This is only for reference, and is not
* used in the as a search key for the calling sequence.

* The module MAKEHELP.PRG is the setup module, and should be linked in
* during help screen generation and revision.  It can be called using
* any desired keystroke, but I suggest using ALT-F1 for consistency with
* the usual help function (called by F1).

* Note that with a few modifications, MAKEHELP could be used as a memo
* editor for memo fields in a conventional application.  Necessary
* additions would be fields for box characteristics, a memo field, and
* set up a procedure to call MAKEHELP.

                       **** How it works ****
* The HELP module uses the calling program and the variable being edited
* as calling keys to access the HELP database.  It is insensitive to
* line number, since I ASSUMED that a variable had to maintain its same
* value throughout a given procedure.  As for different procedures,
* Clipper will not let you compile an application with the same
* procedure name referenced more than once.

* The HELP and MAKEHELP modules both use work area 9 (Select 9) as the
* area to open for HELP.DBF.  You can speed up the HELP program at
* runtime by opening HELP as SELECT 9 in your main program.  This will
* eliminate disk access delays while HELP is being opened. The bad news
* is that if you are already using area 9, this will cause a problem.
* The good news is that the program automatically returns you from area
* 9 to whatever area you were using before you called HELP.  If you are
* really serious about using work area 9, there is a good article in the
* July issue of DBMS magazine that addresses restoring the Clipper
* environment on return from a call.

* Note that if you also have any routines for maintaining index (.NTX or
* .NDX) files, you need to include HELP.NTX in the maintenance program.
* A good example would be an OPEN_ERR type trapping procedure.


                            *** NOTE ***
* If you compile your procedures separately and then combine them at
* link time, using the DOS linker, you MAY NOT get error messages that
* there are duplicate procedures.  This may be the only good reason to
* use PLINK86 with the VERBOSE option set.

               ***** Credit where credit is due *****

* This program is based in part on an example from Steve Straley's book
* "PROGRAMMING IN CLIPPER, 2/e".  If you do not have a copy, buy one. It
* is worth its weight in gold.

* John Keenom suggested several options in the MAKEHELP option,
* including using Straley's READITIN module to allow ascii file import
* into the memo field.  He also suggested the option to have an
* undesignated help screen which is not tied to a variable.

* Other code (the keystroke function, in particular) was adapted from
* the ME.PRG which comes with Clipper.

* The next line sets the current procedure to the current file....

SET PROCEDURE to CALLHELP

* The following line is a public memory variable (cursrset) which should
* be used to maintain the status of the cursor, i.e. .T. if the cursor
* is on and .F. if the cursor is off.  The runtime HELP module checks
* this variable to determine if it should turn the cursor on or off when
* you return to the application.
*
* If you use ACHOICE() to run your menus, then you need to use a public
* variable (mnchoice) to pass the current menu name to the HELP
* procedure.  Calling HELP from an ACHOICE passes "ACHOICE" as the
* procedure name!!  I have * also included a variable called "list"
* which is used to pass the ACHOICE array name to the keystroke
* function.

PUBLIC cursrset,mnchoice,list

* The following line sets the ALT-F1 key to call the MAKEHELP module. By
* including it in the application, you can create the context sensitive
* help file directly from the application by pressing ALT-F1 instead of
* F1 for help.

SET KEY -30 to MAKEHELP

* Execute the ACHOICE() style menu
DO dochoice

CLEAR
* You can even set up HELP for a WAIT TO
WAIT TO CHOICE

* Execute the MENU TO style menu
DO domenu2

* Show a typical @SAY @GET type input example
DO readsamp

set cursor on
RETURN
* end of MAIN PROGRAM test.prg

*********
* PROCEDURE dochoice
* Procedure to demonstrate use of ACHOICE() as a menu tool

PROCEDURE dochoice

mnchoice = "TESTMENU"
list = "PAD"
clear
* this is your menu array
DECLARE pad[3]
pad[1] = "ACHOICE MENU Option one      "
pad[2] = "ACHOICE MENU Option two      "
pad[3] = "ACHOICE MENU Option three    "

* Be sure to turn off the HELP and MAKEHELP keys...they are handled
* through the keystroke function.  Don't forget to turn 'em back on!!!

set key 28 to
set key -30 to
SET COLOR TO W/B
CLEAR
* pretty stuff for the screen
SET COLOR TO N/N
@ 10,10 CLEAR TO 14,42
SET COLOR TO N/W,W/N
@ 09,09 CLEAR TO 13,41
@ 09,09 TO 13,41 DOUBLE
* this is the actual menu statement. Note the keystroke call to FHELP
menuchoice = ACHOICE(10,10,12,40,&list,"","FHELP")
* turn 'em back on!
set key 28 to help
set key -30 to makehelp

* say what happened
@ 23,0 clear
@ 23,1 say "You have selected item "+trans(menuchoice,"9")+" from an
ACHOICE style menu"
@ 24,1 say '           Press any key to continue.....'
inkey(0)
return

* end of PROCEDURE dochoice

**********
* FUNCTION fhelp -- keystroke capture for ACHOICE menu function
* Adapted from May 1989 issue of DBMS magazine
* Parameters: status - ACHOICE() Status Messages
*             element - current element in the array of items
*             winrow - relative position within the menu window

FUNCTION fhelp

PARAMETER status,element,winrow
PRIVATE keypress
keypress = LASTKEY()
   IF keypress = 27
      RETURN(0)
   ENDIF

* define search key field...Note that LIST is a public variable which
* does a macro substitution for the actual array name
STORE ALLTRIM(LIST)+ALLTRIM(STR(ELEMENT)) TO mTEMP

IF STATUS = 3

 DO CASE
   CASE keypress = 13
     * the return key
     RETURN(1) && make selection, returning index of current item

   CASE keypress = 28
     DO help with mnchoice,element,mTEMP
     RETURN(2) && continue with selection process

   CASE keypress = -30
     DO makehelp with mnchoice,element,mTEMP
     RETURN(2) && continue with selection process

   OTHERWISE
     * any other key....
     RETURN(2)

 ENDCASE
ENDIF
RETURN(2)

**** end of FUNCTION fhelp

*********
* PROCEDURE domenu2
* Procedure to demonstrate the MENU TO style of menus

PROCEDURE domenu2
  SET WRAP ON

   scrframe = "ͻȺ "
   store 0 to option,help_opt


    * main loop: iterates once for each time an option action is
      performed
    DO WHILE .T.

            * display the menu screen
            SET COLOR TO W/B
            CLEAR
            SET COLOR TO N/N
            @ 03,13 CLEAR TO 22,67
            SET COLOR TO N/W
            @ 02,11 CLEAR TO 21,65
            @ 02,11 TO 21,65 DOUBLE
            @ 05,11 SAY ""
            @ 05,65 SAY ""
            @ 03,34 SAY "Sample Menu"
            @ 04,20 SAY "This is a sample menu system using MENU TO"
            @ 05,12 SAY "*  MAIN MENU
            @ 06,21 TO 16,56
            @ 17,21 CLEAR TO 19,57
            @ 17,21 SAY "USE THE "+chr(24)+" AND "+chr(25)+;
            " KEYS TO HIGHLIGHT THE"
            @ 18,21 SAY "DESIRED OPTION AND PRESS ENTER OR"
            @ 19,21 SAY "PRESS THE FIRST LETTER OF THE OPTION"

            set cursor off
            set wrap on
            set color to N/W,+W/B

            @ 07,22 PROMPT "1.  OPTION 1               "
            @ 09,22 PROMPT "2.  OPTION 2               "
            @ 11,22 PROMPT "3.  OPTION 3               "
            @ 13,22 PROMPT "4.  OPTION 4               "
            @ 15,22 PROMPT "5.  QUIT AND RETURN TO DOS "

            menu to mnchoice

         set cursor on
         * perform selected option
         do case
           case mnchoice =1
             * You would run another procedure here
             @ 23,0 clear
             @ 23,1 say "You have selected item "+trans(mnchoice,"9")+;
             " from a MENU TO style menu"
             @ 24,1 say '           Press any key to continue.....'
             inkey(0)
           case mnchoice =2
             * You would run another procedure here
             @ 23,0 clear
             @ 23,1 say "You have selected item "+trans(mnchoice,"9")+;
             " from a MENU TO style menu"
             @ 24,1 say '           Press any key to continue.....'
             inkey(0)
           case mnchoice =3
             * You would run another procedure here
             @ 23,0 clear
             @ 23,1 say "You have selected item "+trans(mnchoice,"9")+;
             " from a MENU TO style menu"
             @ 24,1 say '           Press any key to continue.....'
             inkey(0)
           case mnchoice =4
             * You would run another procedure here
             @ 23,0 clear
             @ 23,1 say "You have selected item "+trans(mnchoice,"9")+;
             " from a MENU TO style menu"
             @ 24,1 say '           Press any key to continue.....'
             inkey(0)
           case mnchoice =5
             close all
             set color to w/b,n/w
             clear
             EXIT

        endcase

    enddo
@ 23,0 clear
@ 24,1 say '           Press any key to continue.....'
inkey(0)
return

* end of PROCEDURE domenu2

*********
* PROCEDURE readsamp
* Procedure to demonstrate use of help from @SAY @GET constructs

PROCEDURE readsamp

TESTFIELD = space(10)

SET COLOR TO +W/B
CLEAR
SET COLOR TO N/N
@ 08,07 CLEAR TO 18,75
SET COLOR TO N/W
@ 07,05 CLEAR TO 17,73
@ 07,05 TO 17,73 DOUBLE
@ 10,11 SAY "This is a sample of a screen with field or memory variable"
@ 11,11 SAY "input using a READ command with @SAY and @GET commands."
@ 14,20 SAY "INPUT Variable:"


SET COLOR TO N/W, +W/B

@ 14,37 GET TESTFIELD

READ

@ 23,1 say 'You have entered "'+testfield+'" in the test input field'
@ 24,1 say '           Press any key to continue.....'
inkey(0)
return

* end of PROCEDURE readsamp
* end of FILE callhelp.prg
