*:*********************************************************************
*:
*:        Program: CLIPDIAL.PRG
*:
*:         System: ClipDial Intelligent Phone Dialer V2.0
*:         Author: Glendon Todd / Vega Group
*:      Copyright (c) 1988, Public domain by the author
*:  Last modified: 08/18/88     18:22
*:
*:  Procs & Fncts: DIALER()
*:               : DISP_MSG()
*:
*:     Documented: 08/18/88 at 18:26                SNAP! version 3.10
*:*********************************************************************
*
*  This is the "brains" of the ClipDial intelligent dialer.     ClipDial
*  expects to be passed a valid phone number.     Format is at the user's
*  discretion, as ClipDial itself will parse the number properly.
*
*  ClipDial will accept the following types of phone numbers: 
*     
*     1. - 3 or 4 digit interoffice (PBX) numbers
*     2. - 7 digit local phone numbers.
*     3. - 10 digit long distance numbers.
*
*  Phone numbers may be passed as numeric or character string data types,
*  and may contain parentheses, hyphens, spaces, or other formatting
*  characters at the user's discretion.     These are ignored by ClipDial.
*
*  ClipDial extracts the area code and exchange information, if present,
*  from the phone number and uses this to determine whether the number is 
*  local or long distance.     For a local call, ClipDial strips off the
*  area code information and dials the 7-digit local number.     For a long
*  distance number, ClipDial prefixes the number with "1-", and then dials
*  the complete long distance number.
*
*  If a "9" outside line code is prefixed to a 7- or 10-digit phone number,
*  or if the "PBX" parameter is asserted (TRUE), ClipDial will prefix all
*  long distance or 7-digit local phone numbers with a "9" digit followed by
*  a "~" character (the Hayes modem 1/2 second pause command).
*
*  ClipDial also checks the DSR line coming from the modem.     If DSR is
*  not asserted, ClipDial assumes that the modem is not on and aborts with
*  an error message.
*
*  ClipDial uses the database file ClipDial.dbf to keep track of what
*  telephone exchanges are in the local calling area.     This database 
*  must be in the current default directory or on Clipper's PATH.     (Not
*  the DOS path.)     If ClipDial does not find this database file, it will
*  dial the phone number exactly as passed to it.     ClipDial uses Clipper's
*  work area 10 for it's database file.     Anything else in work area 10 
*  will be lost.

*  This copy of ClipDial is currently configured for the metro Washington
*  D.C. area.     However, it is easy to reconfigure for any other area of 
*  the country.     The area code select string "703/202/301" tells ClipDial
*  what area codes the local calling area is contained in.     Simply replace
*  this string with a string containing your local area code(s).     Then the
*  ClipDial.dbf file must be edited (using dBase or some such) so that it
*  contains the exchange codes which are within your local calling area.
*  (There is a list of these exchanges in the front of your phone book.)
*
*  For support, comments, questions or whatever, contact :
*
*                             Glendon Todd
*                             312 Van Buren St.
*                             Falls Church, VA    22046
*                             Compuserve 71121,352
*                             Voice (703) 532-8191
*
*   Revision history
*
*      11/26/87 - Version 1.0 - First public domain release.
*
*      12/17/87 - Version 1.1 - Repaired a bug in 1.0 which was causing
*                                 it to create it's index improperly.
*
*      01/11/88 - Version 1.2 - Added support for numeric phone number
*                                 argument in addition to formatted string.
*
*      05/19/88 - Version 2.0 - Added new phone number parser to handle
*                                 free-form number strings, also "dial 9"
*                                 handling capability, and multiple comm.
*                                 port support.
*
*      08/18/88 - Version 2.1 - Repaired a bug in the ASM routines that 
*                                 caused the processor to hang on program
*                                 termination and added handling for modem
*                                 return codes.
*     
*****************************************************************************
*
*  DIALER
*
*  Syntax:
*     dialer(phone_no, comm_port, pbx_flag)
*  Parameters:
*     phone_no {C/N} - the phone number to be dialed.
*     comm_port {N} - the comm. port to which the modem is connected.
*     pbx_flag {L} - whether or not a PBX "9" code is needed for 7-
*                    and 10-digit numbers.
*  Returns:
*     a logical flag indicating whether or not ClipDial executed sucessfully.
*

*!*********************************************************************
*!
*!       Function: DIALER()
*!
*!           Uses: CLIPDIAL.DBF   
*!
*!        Indexes: CLIPDIAL.NDX
*!               : &CLIPINDEX
*!
*!*********************************************************************
func dialer
parameters phone_no, comm_port, pbx

private acode, database, dial9, dgt, dgt_ctr, exchg, ldist, mdial_no, numbr
private param_err, pbx_flag, phone_err, phone_num, port, ptr, segmnt, exec_flag
private timer


param_err = .f.
do case
case type("m->phone_no") = "C"
   mdial_no = m->phone_no
case type("m->phone_no") = "N"
   mdial_no = ltrim(str(m->phone_no))
otherwise
   disp_msg([PHONE NUMBER DATA TYPE ERROR],20,.f.)
   param_err = .t.
endcase
do case
case (type([m->comm_port]) = [U])
   port = 1
   pbx_flag = .f.
case (type([m->comm_port]) = [L]) .and. (type([m->pbx]) = [U])
   port = 1
   pbx_flag = m->comm_port
case (type([m->comm_port]) = [N]) .and. (type([m->pbx]) = [U])
   port = m->comm_port
   pbx_flag = .f.
case (type([m->comm_port]) = [N]) .and. (type([m->pbx]) = [L])
   port = m->comm_port
   pbx_flag = m->pbx
otherwise
   disp_msg([CLIPDIAL PARAMETER DATA TYPE ERROR],21,.f.)
   param_err = .t.
endcase

if m->port = 0
   if type([m->v_port])=[U]
      public v_port
      do case
      case dsr(1)
         v_port = 1
      case dsr(2)
         v_port = 2
      otherwise
         v_port = 0
      endcase
   endif
   port = m->v_port
endif

acode = [lcl]
exchg = [none]
numbr = [none]

mdial_no = trim(ltrim(m->mdial_no))
ptr = len(m->mdial_no)
dgt_ctr = 0
segmnt = ''
ldist = .f.
dial9 = .f.
do while m->ptr > 0
   dgt = substr(m->mdial_no,m->ptr,1)
   if m->dgt $ [0123456789]
      segmnt = m->dgt+m->segmnt
      dgt_ctr = m->dgt_ctr+1
      do case
      case m->dgt_ctr = 3
         numbr = m->segmnt
         segmnt = ''
         phone_err = .f.
         
      case m->dgt_ctr = 4
         numbr = m->segmnt+m->numbr
         segmnt = ''
         phone_err = .f.
         
      case m->dgt_ctr = 7
         exchg = m->segmnt
         segmnt = ''
         phone_err = .f.
         
      case m->dgt_ctr = 8
         if m->dgt = [9]
            dial9 = .t.
         endif
         phone_err = .f.
         
      case m->dgt_ctr = 10
         acode = m->segmnt
         segmnt = ''
         phone_err = .f.
         
      case m->dgt_ctr > 10
         if m->dgt = [9]
            dial9 = .t.
         endif
         phone_err = .f.
         
      otherwise
         phone_err = .t.
         
      endcase
   endif
   ptr = m->ptr - 1
enddo

if file("clipdial.dbf") .and. m->acode # [lcl]
   if m->acode $ "703/202/301" 
      database = alias()
      select 10
      if file("clipdial.ntx")
         use clipdial index clipdial
      else
         disp_msg([Indexing ... Please wait!])
         use clipdial
         if type('datapath') = [U]
            clipindex = [clipdial]
         else
            clipindex = datapath + [\clipdial]
         endif
         index on exchange to &clipindex
      endif
      seek m->exchg
      if eof()
         ldist = .t.
      endif
      use
      if len(trim(database)) > 0
         select &database
      endif
   else
      ldist = .t.
   endif
endif

if exchg = [none]
   mdial_no = m->numbr
   phone_num = m->numbr
else
   mdial_no = m->exchg+m->numbr
   phone_num = m->exchg+[-]+m->numbr
endif
if ldist
   mdial_no = [1]+m->acode+m->mdial_no
   phone_num = [1 (]+m->acode+[) ]+m->phone_num
endif
if dial9 .or. m->pbx_flag
   mdial_no = [9]+m->mdial_no
   phone_num = [9]+[ ~ ]+m->phone_num
endif
exec_flag = .f.
do case
case m->phone_err
   disp_msg([PHONE NUMBER FORMAT ERROR > ]+m->phone_no,22,.t.)
   
case m->param_err
   disp_msg([CALLING PARAMETER ERROR],22,.t.)
   
case m->port = 0
   disp_msg([NO VALID DIALER PORT FOUND],22,.t.)
   
otherwise
   if dsr(m->port)
      disp_msg("Dialing > "+m->phone_num,21,.f.)
      disp_msg("Wait for ring, then pick up phone and press spacebar, please!",22,.f.)
      
      mdial_no=ltri(trim(m->mdial_no))
      modemcmd("ATDT"+m->mdial_no+chr(13),m->port)
      timer = seconds()
      phone_err = .t.
      do while .t.
         teststr = modemrcv(m->port)
         do case
         case inkey() = 32
            phone_err = .f.
            exit
            
         case len(teststr) = 0
            loop
            
         case [BUSY] $ teststr
            segmnt = [Number ]+m->phone_num+[ busy]
            exit
            
         case [NO CARRIER] $ teststr
            segmnt = [No Answer - Modem Timed Out]
            exit
            
         case seconds() >= timer + 30
            segmnt = [No Answer - Dialer Timed Out]
            exit
            
         endcase
      enddo
      if phone_err
         disp_msg(segmnt,21,.f.)
         disp_msg(space(62),22,.f.)
         disp_msg("Press any key to continue!",22,.t.)
      endif
      modemcmd("ATH0"+chr(13),port)
      
      exec_flag = .t.
   else
      disp_msg("Modem is not on",21,.t.)
      exec_flag = .f.
   endif
endcase
return exec_flag

****************************************************************************

*!*********************************************************************
*!
*!       Function: DISP_MSG()
*!
*!*********************************************************************
func disp_msg
parameters disp_str, disp_line, wait_flag
private col_loc, disp_wide, wt_flg, disp_key, pcount
pcount = pcount()
disp_wide = 80
do case
case pcount = 1
   disp_line = 23
   wt_flg = .f.
   
case pcount = 2
   if type("disp_line") = "L"
      wt_flg = disp_line
      disp_line = 23
   else
      wt_flg = .f.
   endif
   
case pcount = 3
   if type("wait_flag") = "N"
      disp_wide = wait_flag
      wt_flg = .f.
   endif
endcase
if type([wait_flag]) # [U]
   wt_flg = m->wait_flag
endif
col_loc = (80-len(m->disp_str))/2-1
@disp_line,col_loc say m->disp_str
if wt_flg
   if m->disp_line < 22
      disp_msg([Press any key to continue],m->disp_line + 2,.f.)
   endif
   disp_key = inkey(0)
else
   disp_key = 0
endif
return disp_key


*: EOF: CLIPDIAL.PRG
