;*:*********************************************************************
;*:
;*:      Program: V_MODEM.ASM
;*:
;*:       System: Vega Group Standard Library
;*:       Author: Glendon Todd / Vega Group
;*:    Copyright (c) 1987, Public Domain by Vega Group
;*:
;*:    Called by: V_LIB.PRG
;*:
;*: Documented: 12/3/87       22:51                   SNAP! version 2.01
;*:*********************************************************************

;  This source file contains the assembly language routines that Clipdial
;  uses to control and to communicate with the PC serial ports.    Included
;  are serial port initialization code, a routine that returns the status of
;  the serial port's DSR status line, and a routine which transmits modem
;  command strings (AT-prefixed) to a Hayes-compatible modem.
;
;
;  For support, comments, questions or whatever, contact :
;           
;                             Glendon Todd
;                             312 Van Buren St.
;                             Falls Church, VA    22046
;                             Compuserve 71121,352
;                             Voice (703) 532-8191   
	INCLUDE	EXTENDA.INC
          CODESEG     V_MODEM
          DATASEG
CLSTATIC <BYTE ASCIIZ <<64 DUP(0)>>, CPTR STRING ASCIIZ>
ARG_STR   EQU   BYTE PTR DS:[BX]
;
          WORKFUNCS
AUXOUT	PROC	FAR
          PUSH	AX
AXT1:
          MOV   AH,3        ; Test port status
          INT   14H
          AND   AX,0FE30H   ; Mask status word
          CMP   AL,30H      ;
          JNE   AXT3
          CMP   AH,60H      ;
          JZ    AXT2
          CMP   AH,80H
          JLE   AXT3
          JMP   AXT1
AXT2:
          POP	AX
          PUSH  AX
          MOV   AH,1        ; Send Character
          INT   14H
          AND   AX,8000H    ; was send successful?
          JZ    AXT3        ; Yes, exit
          MOV   AH,3        ; Else
          INT   14H         ; Test port status
          CMP   AH,61H      ;
          JNZ   AXT3
          JMP   AXT2
AXT3:
          ADD   SP,2
          RET
AUXOUT	ENDP
          ENDWORK
;
CLPUBLIC <CD, CTS, DSR, MODEMCMD, MODEMRCV, RI, VCOMM>
;**************************************************************************
;        CD - Procedure returns value of carrier detect line from modem.
;        Input arguments - comm. channel number.
;        Returns status as logical True/False.
;
CLFUNC    LOG   CD <INT PORT>
CLCODE
          MOV   DX,PORT
          DEC   DX
          MOV	AX,0300H
          INT   14H
          AND   AX,0080H
          CLRET AX
;
;
;**************************************************************************
;        CTS - Procedure returns value of CTS line from modem.
;        Input arguments - comm. channel number.
;        Returns status as logical True/False.

CLFUNC    LOG   CTS <INT PORT>
CLCODE
          MOV   DX,PORT
          DEC   DX
          MOV	AX,0300H
          INT   14H
          AND   AX,0010H
          CLRET AX
;
;**************************************************************************
;        DSR - Procedure returns value of DSR line from modem.
;        Input arguments - comm. channel number.
;        Returns status as logical True/False.
;
CLFUNC    LOG   DSR <INT PORT>
CLCODE
          MOV   DX,PORT
          DEC   DX
          MOV	AX,0300H
          INT   14H
          AND   AX,0020H
          CLRET AX
;
;**************************************************************************
;        MODEMCMD - Transmits a command string to a Hayes-compatible modem.
;        Input arguments - Pointer to string - command to be transmitted.
;        Modemcmd will initialize the comm. port, control DTR as necessary,
;        prefix the command with "AT", and terminate it with a CR (0Dh).
;
CLFUNC    LOG   MODEMCMD <CHAR CMDSTR, INT PORT>
CLCODE
          MOV   DX,PORT
          DEC   DX
          LDS   BX, CMDSTR
          PUSH  BX
          PUSH  CX
          PUSH  DX
;***********************************************************************
          XOR   CL,CL             ;     This section of code checks for
          MOV   AX,9800H          ;     a resident INT14H handler which
          INT   14H               ;     is not yet ready for release but
          CMP   AL,42H            ;     will, when ready, provide expanded
          JNE   MC3               ;     comm. port service.     It may be
          MOV   CL,0FFH           ;     ignored for the nonce.
          MOV   AX,0503H          ;     
          INT   14H               ;     
;**************************************************************************
MC3:
          MOV   AH,0                    ;service 0 - initialize comm. port
          MOV   AL,83H                  ;sets port to 1200,N,8,1
                                        ;change 83h to 43h for 300 baud,
                                        ;0A3h for 2400 baud
          MOV   DH,0                    
          INT   14H
          POP   DX
          POP   CX
          POP   BX
MC_LP:    
          MOV	AL,ARG_STR
          INC	BX
          CMP	AL,0
          JZ	MC4
          CALL	AUXOUT
          OR    AH,AL
          JNZ   MC4
          JMP	MC_LP
MC4:   
;**************************************************************************
          OR    CL,CL       ;     This section of code is active only if
          JZ    MC5         ;     the VCOMM TSR module is present.
          MOV   CL,0FFH     ;     
          MOV   AX,0500H    ;     
          INT   14H         ;
;**************************************************************************
MC5:
          CLRET AX
;
;
;**************************************************************************
;        MODEMRCV
ASSUME DS:DGROUP
CLFUNC    CHAR  MODEMRCV <INT PORT>
CLCODE
          MOV   DX,PORT
          DEC   DX
          LDS   SI, STRING
        MOV     BX,0080H
MS_LP:   
          MOV   AX,0200H                ; Received character service
          INT   14H                     ; Comm. port interrupt
          MOV   DS:[SI],AL              ; Move character into buffer
          INC   SI                      ; Increment string pointer
          TEST  AH,80H                  ; Test time out error
          JNZ   MRCVRET
          DEC   BX
          JNZ   MS_LP
MRCVRET:
;          MOV   DS:[SI],0               ; Move hex zero into buffer
          CLRET STRING
;
;**************************************************************************
;        RI - Procedure returns value of ring indicator line from modem.
;        Input arguments - comm. channel number.
;        Returns status as logical True/False.
;
CLFUNC    LOG   RI <INT PORT>
CLCODE
          MOV   DX,PORT
          DEC   DX
          MOV   DX,PORT
          MOV	AX,0300H
          INT   14H
          AND   AX,0040H
          CLRET AX          ; Return logical value to clipper
;
;****************************************************************************
;       VCOMM   
;       This function checks to see if the vcomm TSR is installed and
;       returns a logical value.     This function currently works with
;       Clipper only.
;       
;       Parameters :
;         None
;
;       Returns :
;         logical value TRUE if VComm TSR is installed.
;
CLFUNC LOG VCOMM   
CLCODE
          MOV   AX, 9900H  
          INT   14H             ;Dummy INT14 used by vcomm (sneaky, wot?)
          CMP   AL,42H
          MOV   AX,0FFH
          JZ    VCM__RET
          MOV   AX,0
VCM__RET:
          CLRET AX
;
          END	
