/***************************************************************************
Dao Dang Trieu Duong (CIS [72357,3365])
Les Consultants Progimind
Montreal Quebec
20 April 1990

This file contains definitions which allow you to access Clipper's internal
structures of databases. Most of them are discovered by Dave Seiberg.
Steve Larson, John T. Opincar Jr. contribute a few (could be more that I am
not aware of).
I can only claim the discover of the internal structures of indexes and
relations and some definitions beetween "FIELD *fields" and the filter
condition.

Notes from John T. Opincar, Jr.

	_dbf is an array of pointers to database structures. _dbf[0] always points
	to the currently SELECTed database. _dbf[1..255] are pointers to the
	databases currently in USE in the corresponding areas.

Notes from T.D. Dao Dang.

	* The position of the pointer to the filter condition in the Dave Seiberg
	  structure isn't correct.

	* dbf_handle,dbt_handle and ntx_handle.
	Don't forget that DOS always assign 5 handles (0 to 4) to standard I/O
	devices (Stdin, Stdout, Stderr, Stdaux, Stdprn).

	* order1 and order2.
	I don't know exactly what are the purposes of these variables. But I
	discover that they are related to SET RELATION, SET FILTER AND LOCATE
	commands. For example, if you have written the following section of code

			SET RELATION TO ... INTO A
			SET RELATION TO ... INTO B
			.....................
			SET FILTER TO ...
			.....................
			LOCATE FOR ....

	you will get

		for the first relation set, set_order = x = <some base number> + 1
		for the 2nd relation set,	 set_order = y = x + 1
		for the SET FILTER,			 order1 = z = y + 1
		for the LOCATE,				 order2 = w = z + 1

	* ntx_openord.
	For example, within your program, you open sucessively 3 ntx files which
	remain actives. For the first one, ntx_openord is equal to 1. For the
	second ntx file, ntx_openord is 2 etc.

	* Relation beetween item_size,key_size and key_dec.
	Within the NTX file, a key value is represented by a character string,
	regardless of its type.

	key_size is the size of this representation of the key value.
	key_dec is the number of decimals if the key is numeric.
	For example, (depending on the version of the indexing system I think)
		a number with 8 significant digits and 2 decimals is represented
		internally by a char string of 11 bytes long (8+2+1 (for the point)).

	item_size = key_size + 2 x (4 bytes).
	An item structure within a NTX file is defined as follow :
		typedef struc
		{
			long page;
			long recno;
			char key;		(start of the key)
		} ITEM;

	* Asking for help.
		- Work area
	There's something unexplicable with Clipper SELECT command. If you
	attempt to use work areas greater than 250, you will get the runtime error
	"Type mismatch". Anybody has an idea on that matter?.

		- LOCATE condition.
	When you do a LOCATE instruction, Clipper saves the search condition
	somewhere in the _dbf structure. But I can't find it. Anybody has an idea
	on that matter?.

****************************************************************************/
#include "\clip87\nandef.h"
#include "\clip87\extend.h"

#define NUM_TYP	0x0010
#define DATE_TYP	0x0040
#define LOGIC_TYP	0x0080
#define CHAR_TYP	0x0100
#define MEMO_TYP	0x0300

#define DBF_PTR	(_dbf[1])

typedef struct
{
	byte dbf_id;
	byte last_update[3];		/* used by LUPDATE() */
	long last_rec;				/* used by LASTREC() or RECCOUNT() */
	unsigned data_offset;
	unsigned rec_size;		/* same as RECSIZE() + 1 (1 for deleted byte) */
	byte filler[20];
} DBF_HEAD;

typedef struct _symbol
{
	byte unknown[10];
	byte *name;					/* Field name */
} SYMBOL;

typedef struct _field
{
	unsigned type;
	unsigned len;
	unsigned dec;
	byte dummy1[2];
	unsigned offset;
	byte dummy2[4];
	SYMBOL *symbol;
} FIELD;

typedef struct
{
	quant set_order;			/* Order of the SET RELATION within ...*/
	quant reldbf_area;		/* Work area where the related dbf is open */
	byte *relat_key;			/* Key expression of the relation (char string)*/
	quant relkey_len;			/* Length of key expression including null byte */
} RELATIONSHIP;

typedef struct
{
	quant ntx_handle;		/* Handle returned by DOS on the opening of NTX file */
	byte unknownx1[4];
	quant unique;			/* On creation of ntx file, SET UNIQUE is ON (1) or OFF (0) */
	byte unknowx2[2];
	quant ntx_openord;
	byte unknowx3[4];
	quant key_size1;
	quant ntx_version;	/* Identification of the version of the indexing system */
	long first_pg;			/* Offset of the first index page */
	long first_unused_pg;/* Offset of the starting page of a list of unused pages */
	byte unknownx4[6];
	quant item_size;		/* Key size + 8 bytes */
	byte unknownx5[2];
	quant key_size;		/* Size of the internal representation of the key field */
	quant key_dec;			/* Number of decimals if the key field is numeric */
	quant max_item;		/* Maximum keys and pointers that one page can hold */
	quant half_pg;			/* Maximum numbers of keys that can fit in a page divided by two */
} NTX_STRUC;

typedef NTX_STRUC *NTX_PTR;

typedef struct
{
/* dbf header */
	DBF_HEAD datbas_head;	/* 0x00-1f - database header */
/* dbf section */
	long reclen;			/* 0x20-23 - same as rec_size in DBF_HEAD structure */
	long header;			/* 0x24-27 - same as data_offset in DBF_HEAD structure */
	long recno;				/* 0x28-2b - current record number (RECNO())*/
	long numbrec;			/* 0x2c-2f - total number of records in dbf (max : 2 ** 32)*/
	byte unknown1[4];		/* 0x30-33 */
	quant dbf_handle;		/* 0x34-35 - dbf file handle (DOS open function)*/
	quant has_dbt;			/* 0x36-37 - Flag indicating there's a dbt (1) or not (0)*/
	quant dbt_handle;		/* 0x38-39 - dbt file handle */
	quant exclu_on;		/* 0x3a-3b - Flag indicating that dbf is open exclusively or not */
	quant wrk_area;		/* 0x3c-3d - Work area number where the dbf is open */
	SYMBOL *alias;			/* 0x3e-41 - dbf alias */
	quant not_eof_flg;	/* 0x42-43 */
	byte unknown2[2];		/* 0x44-45 */
	Boolean deleted_flg;	/* 0x46-47 */
	Boolean eof_flg;		/* 0x48-49 - EOF flag (used by EOF()) */
	Boolean bof_flg;		/* 0x4a-4b - BOF flag (used by BOF()) */
	Boolean found_flg;	/* 0x4c-4d - FOUND flag for SEEK, FIND, LOCATE and CONTINUE */
	quant file_lock;		/* 0x4e-4f - Flag indicating file locking (1 = locked; 0 = unlocked) */
	quant record_lock;	/* 0x50-51 - Flag indicating record locking (1 = locked ; 0 = unlocked) */
	byte unknown3[2];		/* 0x52-53 */
	quant len_changed;	/* 0x54-55 */
	quant updated;			/* 0x56-57 */
	quant appended;		/* 0x58-59 */
	byte *recptr;			/* 0x5a-5d - Pointer to the record buffer */
	byte unknown4[4];		/* 0x5e-61 */
/* Index section */
	quant indexord;		/* 0x62-63 - Current index order in specified list of indexes open for the dbf (used by INDEXORD())*/
	quant indexcnt;		/* 0x64-65 - number of indexes open for the dbf */
	byte unknown5[4];		/* 0x66-69 */
	NTX_PTR a_ntx[15];	/* 0x6a-a5 - 15 pointers (max open indexes for a dbf) to index structures */
/* Fields section */
	quant fld_count;		/* 0xa6-a7 - Number of fields defined in the dbf (FCOUNT())*/
	FIELD *fields;			/* 0xa8-ab - Pointer to an array of fields characteristics */
/* LOCATE, SET FILTER, SET RELATION section */
	quant fld_cnt2;		/* 0xac-ad - Also a number of fields in the dbf. Why? */
	quant order2;			/* 0xae-af - order1 + 1 (for the LOCATE condition) */
	quant order1;			/* 0xb0-b1 - 1 (for filter cdtion) + 1 for each index open in the program */
	byte *db_filter;		/* 0xb2-b5 - the filter expression (used by DBFILTER()) */
	quant fltexp_len;		/* 0xb6-b7 - Filter expression length with null byte */
	byte unknown6[2];		/* 0xb8-b9 */
	quant nrelat_set;		/* 0xba-bb - Number of relations set on the dbf (max 8 per dbf) */
	RELATIONSHIP a_relat[8];	/* 0xbc-... - array of relations definitions*/
} CLIPPER_DBF;

extern CLIPPER_DBF ** _dbf;

/* So long and Good clipping ... */
