//////////////////////////
// ClipBtn Demo Program //
//////////////////////////

///Compile and Link Directions//////////////////
//                                            //
// Compile:  CLIPPER DEMO -n                  //
// Link:     RTLINK FILE DEMO LIBRARY CLIPBTN //
//                                            //
////////////////////////////////////////////////

#include "inkey.ch"
#include "setcurs.ch"
#include "set.ch"

#include "ClipBtn.ch"

#define SINGLE_BORDER 1
#define DOUBLE_BORDER 2

#define CLEAR_BOX_AREA .T.
#define CR ( CHR(13) + CHR(10) )

#define DEFAULT(x, y) IIF(x == NIL .OR. ( EMPTY( x ) .AND. VALTYPE(x) != "L" ), x:= y, )

#define ATTR_CONV(FORE, BACK) (BACK) * 16 + (FORE)

#define BLACK                                    0
#define BLUE                                             1
#define WHITE                                            7
#define GRAY                                             8

#define COL_DEFAULT_SHADOW              ATTR_CONV(GRAY, BLACK)
#define MON_DEFAULT_SHADOW              ATTR_CONV(WHITE, BLACK)

PROCEDURE Demo()
LOCAL cDosScreen := SAVESCREEN(0, 0, 24, 79), ;
			nDosRow := ROW(), nDosCol := COL()

// Temp Vars for Input Sample (*Note:  Memo Var must be declared as Private)
LOCAL cProgrammer := SPACE(40), lPurchase := .T., nPurWhen := 1, ;
			nState := 1, lOk := .F., lCancel := .F., lExit := .F.

PRIVATE cComment := ""

	SET SCOREBOARD OFF

	CLEAR SCREEN

	// Fill the background with a dark blue
	CB_FillScreen(0, 0, 24, 79, CHR(177), ATTR_CONV(BLUE, BLACK))

	DO WHILE .T.

		// Set Basic Colors
		SET COLOR TO "W+/B"

		// Draw Box Around Data Entry Fields
		CB_Box(5, 5, 19, 73, DOUBLE_BORDER, .T., " ClipButton Sample Input ", ;
					 CLEAR_BOX_AREA, "BG+/B")

		// Now Get the Data
		@ 7,  7 SAY "Programmer: " GET cProgrammer

		@ 9,  7 CHECKBOX "Purchase ClipButton Library? " GET lPurchase ;

		@ 9, 56 SAY "Purchase When: "

		@10, 56 RADIOBUTTON "ASAP", "TOMORROW", "THE NEXT DAY" GET nPurWhen WHEN lPurchase

		@10,  7, 14, 53 MEMO " Comment: " GET cComment BORDER SINGLE_BORDER

		@15,  7 3STATEBOX "Checked, Not Checked or Neutral: " GET nState

		@16,  6 TO 16, 72

		@17, 24 PUSHBUTTON                      "   OK   " GET lOk ;
							NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"

		@17, COL()+4 PUSHBUTTON " CANCEL " GET lCancel ;
							NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"

		@17, COL()+4 PUSHBUTTON "  EXIT  " GET lExit ;
							NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"

		READ

		IF ( LASTKEY() == K_ESC .OR. lExit )
			IF ( YesNoBox(18, "Exit ClipButton Example Program?" + CR, 40, " Exit Program ",;
								"C", .F.) )
				EXIT
			ENDIF
		ENDIF

		SET COLOR TO "B/W"
		MSGBOX(, "PROGRAMMER:                      " + TRIM(cProgrammer) + CR +;
						 "PURCHASE CLIPBUTTON LIBRARY:     " + IIF(lPurchase, "Yes", "No") + CR +;
						 IIF(lPurchase, "PURCHASE:                        " + ;
							 IIF(nPurWhen == 1, "ASAP",;
							 IIF(nPurWhen == 2, "Tomorrow", ;
																	"The Next Day")),"") + CR +;
						 "COMMENT:                         " + TRIM(cComment) + CR +;
						 "CHECKED, NOT CHECKED OR NEUTRAL: " + IIF(nState == 1, "Checked", IIF(nState == 2, "Neutral", "Not Checked")) + CR +;
						 "BUTTON PUSHED:                   " + IIF(lOk, "Ok was Pushed", IIF(lCancel, "Cancel was Pushed", "No Button Pushed")) + CR + REPLICATE("", 50) + CR, 50, ;
						 " Result of Data Entry", "L")

	ENDDO

	CLOSE ALL
	RESTSCREEN(0, 0, 24, 79, cDosScreen)
	SETPOS(nDosRow, nDosCol)

RETURN


FUNCTION MsgBox(nTopRow, cMessage, nLineLen, cTitle, cJustify)
LOCAL   cOldScreen, nKeyStroke:= 0, nNumLines := 0, nCurLine := 0, i,;
			nTopCol := 0, nOldCursor, lOkButton := .T., ;
			nOldRow, nOldCol, GetList := {}

	nOldCursor      := SETCURSOR(SC_NONE)
	nOldRow                 := ROW()
	nOldCol                 := COL()

	DEFAULT( nLineLen, 30 )
	DEFAULT( cJustify, "L")
	DEFAULT( cTitle,   "" )

	nNumLines := MLCOUNT(cMessage, nLineLen)

	DEFAULT( nTopRow, ( 12 - ( ( nNumLines + 2 ) / 2 ) ) )

	nTopCol         := (40 - (nLineLen / 2 + 3))

	cOldScreen := SAVESCREEN(nTopRow, nTopCol, (nTopRow + 6 + nNumLines),;
												(40 + (nLineLen / 2 + 5)))

	CB_Box(nTopRow, nTopCol, (nTopRow + 4 + nNumLines), ;
			(40 + (nLineLen / 2 + 3)), 2, .T., cTitle)

	nCurLine := nTopRow + 1

	FOR i = 1 TO nNumLines
		IF ( UPPER(cJustify) == "C" )
			@nCurLine, nTopCol + 3 SAY PADC(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSEIF ( UPPER(cJustify) == "R" )
			@nCurLine, nTopCol + 3 SAY PADL(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSE
			@nCurLine, nTopCol + 3 SAY PADR(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ENDIF
		nCurLine++
	NEXT

	@nCurLine + 1, 37 PUSHBUTTON "  OK  "           GET lOkButton ;
					NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
	READ

	nKeyStroke := LASTKEY()

	RESTSCREEN(nTopRow, nTopCol, (nTopRow + 6 + nNumLines),;
						(40 + (nLineLen / 2 + 5)), cOldScreen)

	SETCURSOR(nOldCursor)
	SETPOS(nOldRow, nOldCol)

RETURN nKeyStroke


FUNCTION YesNoBox(nTopRow, cMessage, nLineLen, cTitle, cJustify, lDefault, cColor)
LOCAL cOldScreen, nNumLines := 0, nCurLine := 0, i,;
			nTopCol := 0, cOldColor, nOldCursor, lLetter, bOldY, bOld_y, bOldN, ;
			bOld_n, lYesBtn, lNoBtn, nOldRow, nOldCol, GetList := {}

	DEFAULT(lDefault, .F.   )
	DEFAULT(nLineLen,       30      )
	DEFAULT(cJustify, "L"   )
	DEFAULT(cTitle,         ""      )
	DEFAULT(cColor,         ""      )

	cOldColor               := SETCOLOR(IIF(!EMPTY(cColor), cColor, "BG+/B"))
	nOldCursor  := SETCURSOR(SC_NONE)
	nOldRow                 := ROW()
	nOldCol                 := COL()

	lYesBtn                 := .F.
	lNoBtn                  := .F.

	cMessage        += CR

	nNumLines := MLCOUNT(cMessage, nLineLen)

	IF ( nTopRow == NIL ) // Center if No nTopRow Given
		nTopRow := ( 12 - ( ( nNumLines + 2 ) / 2 ) )
	ENDIF

	nTopCol := (40 - (nLineLen / 2 + 3))

	cOldScreen := SAVESCREEN(nTopRow, nTopCol, ;
												(nTopRow + 6 + nNumLines),;
												(40 + (nLineLen / 2 + 5)))

	CB_Box(nTopRow, nTopCol, (nTopRow + 3 + nNumLines), ;
			(40 + (nLineLen / 2 + 3)), 2, .T., cTitle, .T., cColor)

	nCurLine := nTopRow + 1

	FOR i = 1 TO nNumLines
		IF ( UPPER(cJustify) == "C" )
			@nCurLine, nTopCol + 3 SAY PADC(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSEIF ( UPPER(cJustify) == "R" )
			@nCurLine, nTopCol + 3 SAY PADL(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSE
			@nCurLine, nTopCol + 3 SAY PADR(TRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ENDIF
		nCurLine++
	NEXT

	@nCurLine, 34 PUSHBUTTON " YES "                GET lYesBtn ;
								NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
	@nCurLine, 42 PUSHBUTTON " NO "                 GET lNoBtn  ;
								NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"

	lLetter := ""

	bOldY   := SETKEY(ASC("Y"))
	bOld_y  := SETKEY(ASC("y"))
	bOldN           := SETKEY(ASC("N"))
	bOld_n  := SETKEY(ASC("n"))

	SETKEY( ASC("Y"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "Y" ) } )
	SETKEY( ASC("y"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "Y" ) } )

	SETKEY( ASC("N"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "N" ) } )
	SETKEY( ASC("n"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "N" ) } )

	IF ( !lDefault )
		KEYBOARD CHR(K_TAB)
	ENDIF

	READ

	SETKEY(ASC("Y"), bOldY  )
	SETKEY(ASC("y"), bOld_y )
	SETKEY(ASC("N"), bOldN  )
	SETKEY(ASC("n"), bOld_n )

	RESTSCREEN(nTopRow, nTopCol, (nTopRow + 6 + nNumLines),;
						(40 + (nLineLen / 2 + 5)), cOldScreen)

	SETCURSOR(nOldCursor)
	SETCOLOR(cOldColor)
	SETPOS(nOldRow, nOldCol)

	IF ( lLetter == "Y" )
		lYesBtn := .T.
	ELSEIF ( lLetter == "N" )
		lYesBtn := .F.
	ENDIF

RETURN ( IIF(lYesBtn, .T., .F.) )
