/*Ŀ
 ݳ Program Name: MANAGED.PRG       Copyright: Gallagher Computing Corp. 
 ݳ     Language: Clipper 5.2          Author: Kevin S Gallagher         
 
            */

#include "include1.h"
#include "setcurs.ch"

#define USE_ESC

static cAutoBuff, cConfBuff, lExit
static nARow, nACol, nCRow, nCCol
static cWhichOne

function editor( cBuffer, nMode )
    local SaveFullScreen(), oldcolor := setcolor(DOSCOLOR), getlist :={}
    local oldins := readinsert(.t.), cShort, cLong

    cWhichOne := "AUTO"
    nMode     := if(valtype(nMode)=="N",nMode,0)

    setcursor(1)

    nARow     :=  1
    nACol     :=  0
    nCRow     :=  1
    nCCol     :=  0
    lexit     := .f.
    cAutoBuff := cBuffer[1]
    cConfBuff := cBuffer[2]
    cShort    := padr( subs(cBuffer[3],2), SHORTY )
    cLong     := padr(      cBuffer[4],   76 )

    setkey( K_F10, { |p,n,v| GetCurrent(p,n,v) } )

    cls
    dispbox(4,0,18,maxcol(),B_DOUBLE+" ",SAYCOLOR)

    CENTER( 6,"Edit/Create New PseudoName", SAYCOLOR)
    CENTER( 9,"-PseudoName-", SAYCOLOR)
    CENTER(14,"Long Description - Appears on Bottom Line", SAYCOLOR)

    @maxrow(), 0 say ;
    padc("F10-key will automatically pull the existing Autoexec "+;
    "and Config into editor",80) color MENUCOLOR

    // edit title and description of current configuration
    @ 11,29 get cShort  picture "@!"  valid Valid_1()  color EDCOLORS
    @ 15, 2 get cLong   picture "@!"  valid Valid_1()  color EDCOLORS
    read

    setkey( K_F10, nil )

    if lastkey() <> K_ESC
        if .not. ( cShort == subs( cBuffer[3], 2 ) )
            cBuffer[3] := "1" + alltrim( cShort )
        endif
        if .not. ( cLong == cBuffer[4] )
            cBuffer[4] := alltrim( cLong )
        endif
    endif
    setcolor("gr+/bg")
    cls
    @MR,60 say "Line:       Col:"
    @MR,1  say "F2=Save/Exit"                           color "n  /bg"
    @MR,16 say "ESC=Abort/Exit"                         color "n  /bg"
    @MR,34 say "F10=Toggle file"                        color "n  /bg"
    setcolor(DOSCOLOR)
    while .t.
        do case
            case lExit
                exit
            case cWhichOne == "AUTO"
                EditAuto()
            case cWhichOne == "CONF"
                EditConfig()
        endcase
    enddo

    do case
        case lastkey() == K_F2
            // save buffer(s)
            cBuffer[1] := rtrim( strtran( cAutoBuff, chr(26), "" ) )
            cBuffer[2] := rtrim( strtran( cConfBuff, chr(26), "" ) )
        case lastkey() == K_ESC
            // abort changes
            cBuffer[1] := ""
            cBuffer[2] := ""
    endcase

    RestFullScreen()
    readinsert(oldins)
    setcolor(oldcolor)
    setcursor(0)
return cBuffer

function EditAuto()
    @0 ,0  say "Editing autoexec  "                           color "w+ /bg"
    @ 0,70 say if(readinsert(),"<INS>","     ") color "w+/bg"
    cAutoBuff:= memoedit(cAutoBuff, 1, 0, MR-1, 79, .T., "AMemo", 250, 4,  ;
                nARow,nACol,nARow,nACol )
return nil


function EditConfig()
    @0 ,0  say "Editing Config.sys"                           color "w+ /bg"
    @ 0,70 say if(readinsert(),"<INS>","     ") color "w+/bg"
    cConfBuff:= memoedit(cConfBuff, 1, 0, MR-1, 79, .T., "CMemo", 250, 4,  ;
                nCRow, nCCol, nCRow, nCCol )
return nil


************************ MEMO EDIT User Define Functions ********************

function AMemo( nMode, nLin, nCol )
   local nKey, nRetVal:= ME_DEFAULT

   nKey  := lastkey()
   nARow := nLin
   nACol := nCol

   #ifdef USE_ESC
   if nKey == K_ESC
       lExit   := .t.
       return 23
   endif
   #endif

   if nMode == ME_IDLE
       @MR,65 say nLin picture "999"  color "w+/bg"
       @MR,76 say nCol picture "999"  color "w+/bg"
   elseif nMode == ME_UNKEY .or. nMode == ME_UNKEYX
       do case
           case nKey == K_F10
               cWhichOne := "CONF"
               nRetVal := 23
           case nKey == K_F2
               lExit   := .t.
               nRetVal := 23
           case nKey == K_INS
               nRetVal := ShowInsKey()
       endcase
   endif
return (nRetVal)

function CMemo( nMode, nLin, nCol )
   local nKey, nRetVal:= ME_DEFAULT

   nKey  := lastkey()
   nCRow := nLin
   nCCol := nCol

   #ifdef USE_ESC
   if nKey == K_ESC
       lExit   := .t.
       return 23
   endif
   #endif

   if nMode == ME_IDLE
       @MR,65 say nLin picture "999"  color "w+/bg"
       @MR,76 say nCol picture "999"  color "w+/bg"
   elseif nMode == ME_UNKEY .or. nMode == ME_UNKEYX
       do case
           case nKey == K_F10
               cWhichOne := "AUTO"
               nRetVal := 23
           case nKey == K_F2
               lExit   := .t.
               nRetVal := 23
           case nKey == K_INS
               nRetVal := ShowInsKey()
       endcase
   endif
return (nRetVal)

function EMemo( nMode, nLin, nCol )
   local nKey, nRetVal:= ME_DEFAULT
   nKey := lastkey()
   if nMode == ME_IDLE
       //
   elseif nMode == ME_UNKEY .or. nMode == ME_UNKEYX
       nRetVal := if(nKey == K_F10, 23, nRetVal )
   endif
return (nRetVal)


function ShowInsKey()
    @ 0,70 say if(readinsert(),"     ","<INS>") color "w+/bg"
return K_INS

/*
* this function is called to validate the title and descriptions
* We allow no exit if the string begins with a "1" or if the get
* is empty. The "1" would cause problems when retreiving any of
* the configurations, since it is part of the search key.
*/
#define TheGet getactive():varget()
function Valid_1()
    local RetVal := .t.
    if empty( TheGet )
        RetVal :=.f.
    elseif isdigit( TheGet )
        if left( TheGet,1 ) == "1" .or. left( TheGet,1 ) == "2"
            RetVal := .f.
        endif
    endif
return RetVal


function GetCurrent( cName, nLine, cVar )
    if file("c:\autoexec.bat")
        cAutoBuff := memoread( "c:\autoexec.bat" )
    else
        //
        // recovery here
        //
    endif
    if file("c:\config.sys")
        cConfBuff := memoread( "c:\config.sys" )
    else
        //
        // recovery here
        //
    endif
return nil

