function Okay3270
*---------------*

* Author:  Todd C. MacDonald
* Syntax:  if Okay3270( <CLIP3270 function> )
* Purpose: Provides central error trapping/reporting for CLIP3270 functions.
*
parameter l3270code
private lRtnCode, lFunction, lLastArea

* derive the function number
lFunction = l3270code % 100

* check the return code
lRtnCode = int(l3270code / 100)
if lFunction <> 90 .and. lFunction <> 91
  if lRtnCode = 0
    * get out fast...
    return .t.
  endif
else
  if lRtnCode = 3
    * ugh...why can't they be consistent?!?
    return .t.
  endif
endif

* save the current work area
lLastArea = select()

* open the error message database
select 0
use Err3270 index Err3270

* locate and report the error message
lErrorMsg = 'HLLAPI function: '+str(lFunction,2)+'     Return Code: '+;
            str(lRtnCode,3)+chr(13)+chr(10)+chr(13)+chr(10)
seek str(lFunction,2)+str(lRtnCode,3)
if !eof()
  lErrorMsg = lErrorMsg+fErrorMsg
else
  lErrorMsg = lErrorMsg+'Could not locate error message in ERR3270 file!'
endif
Error(lErrorMsg)

* close the error message database
use

* restore the previous work area
select (lLastArea)

* go home with the bad news
if pBreak3270
  break
endif
return .f.


procedure Error
*-------------*

* Author:  Todd C. MacDonald
* Syntax:  Error( <expC> )
* Where:   <expC> is an error message
* Purpose: Opens an error window in the center of the screen and displays <expC>
*          wordwrapped within the window.  It then waits for the user to press
*          [Esc].
*
parameters lErrMsg
private lTop, lLeft, lBottom, lRight, lNumLines, lLine, lTextLine, lKey
private lFramColor, lHeadColor, lBodyColor, lLastColor, lTitle, lScrnBuff

* set window coordinates
lTop=4
lLeft=18
lBottom=16
lRight=61

* set screen colors
if iscolor()
  lFramColor = 'R+/R'
  lHeadColor = 'GR+*/R'
  lBodyColor = 'W+/R'
else
  lFramColor = 'W+/N'
  lHeadColor = 'W+*/N'
  lBodyColor = 'W/N'
endif

* save underlying screen area
lScrnBuff = savescreen(lTop, lLeft, lBottom, lRight)

* open the error window
lLastColor = setcolor(lFramColor)
@ lTop, lLeft, lBottom, lRight box 'Ŀ '
lTitle = 'Press [Esc] to continue'
@ lBottom, lLeft+int((lRight-lLeft+1-len(lTitle))/2) say lTitle
setcolor(lHeadColor)
lTitle = 'E R R O R'
@ lTop, lLeft+int((lRight-lLeft+1-len(lTitle))/2) say lTitle
setcolor(lBodyColor)

* display the error message
lNumLines=mlcount(lErrMsg, lRight-lLeft-3)
for lLine = 1 to lNumLines
  lTextLine=memoline(lErrMsg, lRight-lLeft-3, lLine)
  @ lTop+1+lLine-1, lLeft+2 say lTextLine
next

* make some noise
tone(300,1)
tone(300,1)

* wait for [Esc]
lKey=0
do while lKey <> 27
  lKey=inkey()
enddo

* restore underlying screen
restscreen(lTop, lLeft, lBottom, lRIght, lScrnBuff)
setcolor(lLastColor)

return