
/*
                                     WAT.CH
  FIND & REPLACE CLAUSES.
  Wed  08-07-1991  16:19:22

  The #xcommand & #xtranslate work like #command & #translate except that the
  4 letter abbreviations do not apply.
*/

//= = = = From Rick Spence Book = = = =
#xcommand DEFAULT <var> TO <constant> [,<nvar> TO <ncon>] ;
       => <var> := IIF( <var> = NIL, <constant>, <var> )  ;
       [;<nvar> := IIF(<nvar> = NIL, <ncon>    , <nvar>)]

#xtranslate COMPILE(<cExpr>)           => &("{|| " + <cExpr> + "}")

#xtranslate ASHRINK(<ar>, <nLoc>)          => (ADEL( <ar>, <nLoc>), ;
                                              ASIZE(<ar>, LEN(<ar>) - 1))
#xtranslate ASHRINK(<ar>)                  => ASIZE(<ar>, LEN(<ar>) - 1)

#xtranslate AINSERT(<ar>,<nLoc> ,<item>) => (ASIZE(<ar>, LEN(<ar>) + 1),;
                                              AINS(<ar>, <nLoc>),;
                                               <ar>\[<nLoc>] := <item>)
#xtranslate AINSERT(<ar>,<nLoc>) => (ASIZE(<ar>, LEN(<ar>) + 1),;
                                    AINS(<ar>, <nLoc>))

/*= = = = From Jim Tamburrino = = = =*/
#xcommand CURSOR_OFF               => SETCURSOR(0)
#xcommand CURSOR_NORMAL            => SETCURSOR(1)
#xcommand CURSOR_LOWER             => SETCURSOR(2)
#xcommand CURSOR_FULL              => SETCURSOR(3)
#xcommand CURSOR_UPPER             => SETCURSOR(4)

#translate {<m>/<d>/<y>}           => CTOD( #<m> + "/" + #<d> + "/" + #<y> )

#xtranslate Num2str(<n>)           => LTRIM(TRIM(STR( <n> )))


//= = = = = = = = = From little ole me = = = = = = = =

#xtranslate Margin(<n>)            => SET(_SET_MARGIN, <n> )
#xtranslate MsgRow(<n>)            => SET(_SET_MESSAGE,<n> )

#xtranslate BETWEEN(<a>,<b>,<c>)   => ( (<c>  >= <a>) .AND. (<c> <= <b>) )
#xtranslate aTrim(<a>)             =>   Alltrim(<a>)
#xtranslate ischar(<a>)            => ( Valtype(<a>) == 'C' )

#xcommand ENDWHILE [<*x*>]         => enddo

#xcommand @ <row> CENTERIT <sayxpr> [COLOR <acolor>]                        ;
          =>                                                                ;
             DEVPOS(<row>, INT((MAXCOL()+2-LEN(<sayxpr>))/2))               ;
             ; DEVOUT(<sayxpr> [, <acolor>] )


/*= = = = =  From Greg Lief Book  = = = =*/

#xtranslate  PROPER(<s>) => Upper(Left(<s>,1))+ Lower(substr(<s>, 2))

#xtranslate AddExtension( <file>, <ext> ) => ;
            <file> := UPPER( <file> ) + IF(! "."+UPPER( <ext> ) $ ;
                      UPPER( <file> ), "."+UPPER( <ext> ), '')


/*= = = = =  From Dias Browse  = = = */

#xtranslate SET INSERT ON   => ;
                SetKey(22,{|| SetCursor(IIF(ReadInsert(!ReadInsert()), 1,2))})

#xtranslate SET INSERT OFF  => SetKey(22, NIL)


