;	Title:	CLEARBOX.ASM
;	Author:	F. Ho
;	Date:	sometime 1986
;	Syntax:	DO CLEARIT WITH 1,2,3,4
;	Note:	- clears that part of the screen specified by the coordinates
;			- declare CLEARIT as EXTERNAL in Clipper prog
;
public	CLEARIT					; declare as public
;
extrn	_PARNI:far				; declare as external of type far
extrn	_RET:far					;
;
;
datasg	segment	para	'DATA'		; start of data segment
;
TOP		db	0h					; top -
LEFT	db	0h					; left corner
BOTTOM	db	0h					; bottom -
RIGHT	db	0h					; right corner
;
datasg	ends						; end of data segment
;
;
_prog	segment	byte				; start of code segment
assume	cs:_prog,ds:datasg,es:_prog
;
CLEARIT	proc	far					; start of ROLLUP process
		push	bp					; preserve return address
		mov	bp,sp

		push	ds					; save registers
		push	es					;

		mov	ax,1					; take 1st para
		push	ax
		call	_PARNI
		add	sp,2					; restore stack
		mov	TOP,al				; assign 1st para to TOP

		mov	ax,2					; take 2nd para
		push	ax
		call	_PARNI
		add	sp,2
		mov	LEFT,al				; assign to LEFT
	
		mov	ax,3					; take 3rd para
		push	ax
		call	_PARNI
		add	sp,2
		mov	BOTTOM,al				; assign to BOTTOM

		mov	ax,4					; take 4th para
		push	ax
		call	_PARNI
		add	sp,2
		mov	RIGHT,al				; assign to right

		push	cx					; preserve coordinate
		push	dx					; registers

		mov	ch,TOP				; assign TOP to high CX
		mov	cl,LEFT				; assign LEFT to low CX
		mov	dh,BOTTOM				; assign BOTTOM to high DX
		mov	dl,RIGHT				; assign RIGHT to low DX

		xor	ax,ax				; zero out AX
		push	ax
		mov	ax,0600h				; request roll up service
		mov	bh,07				; normal attribute
		int	10h					; issue video int

		pop	ax					; restore registers
		pop	dx					; before calling RETs
		pop	cx					;	|

		pop	es					;	|
		pop	ds					;	|
		pop	bp					;	|

		call	_RET					; Clipper return (actual cleaning)

		ret						; actual physical return
CLEARIT	endp						; end of process
;
;
_prog	ends
		end

