PROGRAM CLEAN;

{Clean.com:  removes blank lines, comment lines and leading blanks from
dBASE III command files to help improve execution speed.

Author: Craig S. Steinberg, O.D.
Compuserve ID:  70166,337 (Ashton Tate Sig or IBM Software Sig)
dBASE RBBS, Glendale California
Version 1.0: May 30, 1986
Version 2.1  June 3, 1986

Type CLEAN ? for help

version 1.1:  windows added, 5/31/86
version 2.0:  prompt for file names and allow switches to control which
of the three functions will operate,  6/1/86.
version 2.1:  gets current video mode itself,  6/3/86.

Hopeful updates (in future):
   1.  Switch to remove indented comment lines also;
   2.  Switch to allow shortening of dBASE Command words to 4 characters;}


{$C-}

{variable declarations}
var
   Infile,Outfile : text;
   line           : string[255];
   c,f            : string[1];
   NextLine       : boolean;
   l              : integer;
   InFileName     : string[12];
   OutFileName    : string[12];
   OutFileNameT   : string[12];  {temp outfilename}
   ps             : string[12];
   IOerr          : boolean;
   Value          : byte;
   PTOOLWIN_Screen_Type : char;

const
   PTOOLWIN_Number_of_Windows = 2;
   Comment  : boolean = True;
   Indent   : boolean = True;
   Blank    : boolean = True;

{***Get windowing include file***}
{ by Ostrander Data Services }
{$I PTOOLWI2.INC}

{***Initialize two windows***}
Procedure WindowSetup;
begin
   PTWSet (1, 6, 1, 66, 13, 2, 7, 0);
   PTWSet (2, 15, 7, 74, 18, 1, 7, 0);
end;

{wait for any key to be struck to continue}
PROCEDURE Wait;
Var
  AnyKey : Char;
Begin
  Read(Kbd,AnyKey);
End;

{help info appears when no parameters are entered with clean}
PROCEDURE Help;
begin
   PTWSet (1, 1, 1, 79, 24,  2, 0, 7);
   PTWOpen (1);
   ClrScr;
   GotoXY (1,1);
   writeln('CLEAN.COM 2.1 by Craig S. Steinberg, June 2, 1986.');
   writeln;
   writeln('Clean removes indentation, blank lines and comments from dBASE programs.');
   writeln;
   writeln('Format:  CLEAN [?] [/bci]');
   writeln;
   writeln('   ?  Displays this help screen.');
   writeln('   /  Allows you to EXCLUDE the removal of specified lines.');
   writeln('        b - do not remove blank lines');
   writeln('        c - do not remove comment lines');
   writeln('        i - do not remove indentation');
   writeln;
   writeln('b, c and i may be combined in any fashion.  There is one caveat to using the');
   writeln('"i" option.  If you select i (do not remove indentation) then indented');
   writeln('comments will not be removed.  To remove indented comments i must be active.');
   writeln('To return to DOS press <RETURN> when asked for the file to read.');
   writeln;
   writeln('Defaults:   Input file extension - .PRG');
   writeln('                Output Filename  -  same as input filename');
   writeln('           Output file extension - .CLN');
   writeln;
   write('                    [ Press any key to return to DOS . . . ]');
   wait;
   ptwclose;
   halt;
end;

{check for disk/file errors, based upon IOError.pas in turbo tutor}
PROCEDURE IOCheck(var IOerr : boolean);
const
  IOVal   : Integer = 0;
  IOerror : boolean = False;
var
  Ch    : Char;
begin
  IOerr   := False;
  IOVal   := IOresult;
  IOError := (IOVal <> 0);
  if IOError then begin
    IOerr := True;
    GotoXY (3,5);
    case IOVal of
      $01  :  Write('Error: Input file ',InFileName,' does not exist.');
      $05  :  Write('Error: Can''t read from the input file.');
      $06  :  Write('Error: Can''t write to output file.');
      $F0  :  Write('Error: Disk write error.');
      $F1  :  Write('Error: Directory is full.');
    else      Write('Unknown I/O error:  ',IOVal:3)
    end;
    GotoXY (3,7); Write('Press any key to continue . . . ');
    write(chr(7));
    wait;
  end
end; { of proc IOCheck }

{***Open window for getting filenames***}
Procedure OpenWindowOne;
begin
   PTWOpen (1);
   ClrScr;
   GotoXY (3,1); Write('CLEAN, Version 2.1 by Craig Steinberg. ');
   Write(' [CLEAN ? = help]');
end;

{**************}
{ MAIN PROGRAM }
{**************}

Begin

   {***get/set current video mode***}
   value := Mem[0000:$0449];
   if value = 7 then PTOOLWIN_Screen_Type := 'M'
   else PTOOLWIN_Screen_Type := 'C';

   {***Help screen requested?***}
   if ParamStr(1) = '?' then help;

   {***Prepare the windows***}
   WindowSetup;

   {***Check the Flags and set up variables accordingly***}
   If (ParamCount = 1) then begin
      ps := ParamStr(1);
      f := copy(PS,1,1);
      if f = '/' then begin
         repeat {until length(PS) = 0}
            delete(PS,1,1);
            f := copy(PS,1,1);
            if (f = 'C') or (f = 'c') then Comment := False;
            if (f = 'I') or (f = 'i') then Indent  := False;
            if (f = 'B') or (f = 'b') then Blank   := False;
         until length(PS) = 0;
         end
      else help;
   end;

   {***Open the filename window***}
   OpenWindowOne;

   {****Loop to repeat until no filename is entered****}
   Repeat  {until length(InFileName) = 0}

      {***clear bottom part of window***}
      GotoXY(1,3); ClrEol;
      GotoXY(1,4); ClrEol;
      GotoXY(1,5); ClrEol;
      GotoXY(1,7); ClrEol;
      GotoXY(1,9); ClrEol;

      {***Get Input Filename***}
      GotoXY ( 3,3);  Write('Enter file to read [.prg]: ');
      GotoXY ( 3,4);  Write('Press RETURN to quit program.');
      GotoXY (31,3);  Read(InFileName);
      GotoXY ( 1,4);  ClrEol;

      {***If no ext is given and more than eight char are entered...***}
      If (pos('.',InFileName) = 0) and (length(InFileName) > 8) then
         InFileName := copy(InFileName,1,8);

      {***Add default ext if needed and Open input file***}
      IF length(InFileName) > 0 then
      Begin
         if pos('.',InFileName) = 0 then InFileName := InFileName + '.prg';
         {$I-}
         Assign(InFile,InFileName);  IOCheck(IOerr);
         Reset(InFile);  IOCheck(IOerr);
         {$I+}

         {***Did an I/O error occur?***}
         if not IOerr then
         begin

         {***Get Output Filename***}
         OutFileName := InFileName;                   {save filename}
         delete(OutFileName,Pos('.',OutfileName),4);  {remove ext}
         OutFileName := OutFileName + '.cln';         {save default ext}

         GotoXY ( 3,4); write('Enter file to write (',OutfileName,'):');
         GotoXY (28+length(OutFileName),4);  read(OutFileNameT);

         {***Save output name to real var from temporary one***}
         if length(OutFileNameT) > 0 then OutFileName := OutFileNameT;

         {***If no ext is given and more than eight char are entered...***}
         If (pos('.',OutFileName) = 0) and (length(OutFileName) > 8) then
            OutFileName := copy(OutFileName,1,8);

         {***Add default ext if one is needed***}
         if Pos('.',OutFileName) = 0 then OutFileName := OutFileName + '.cln';

         {***Open output file and erase if exists***}
         {$I-}
         Assign(OutFile,OutFileName);  IOCheck(IOerr);
         Rewrite(OutFile);  IOCheck(IOerr);
         {$I+}

         {****Open Processing Window****}
         PTWOpen (2);
         ClrScr;
         GotoXY (17,2);  Write('Processing Control Window');
         GotoXY (17,3);  write('-------------------------');
         GotoXY (17,4);  write(' Input file: ',InFileName);
         GotoXY (17,5);  write('Output file: ',OutFileName);
         GotoXY (17,7);  write('Processing line number: ');

         {****READY TO PROCESS NOW****}
         l := 1;  {start with line number one}
         Repeat {until eof}
            Readln(InFile,line);
            NextLine := False;
            GotoXY (42,7);  write(l);  l := l + 1;
            Repeat {until nextline = T}
               begin
                  c := copy(line,1,1);

                  {**if its a blank line go to the next line**}
                  if ((length(line) = 0) and blank) then NextLine := True
                  else

                     {**if its a comment line go to the next line**}
                     If ((c = '*') and comment) then NextLine := True
                     else

                        {**if its an indented line remove the first space**}
                        {**then repeat the loop and check the next line  **}
                        if ((c = chr(32)) and indent) then delete(line,1,1)

                        else begin
                           {**if its none of the above, save the line**}
                           {**and exit to go get the next line of data*}
                           Writeln(OutFile,line);
                           NextLine := True;
                        end;
               end;
            until NextLine = True;
         until EOF(InFile);

         {***close files***}
         Close(InFile);
         Close(OutFile);

         {***Now this file is finished so get next file to process***}
         GotoXY (17,9); write('Done.  Press any key . . .');
         write(chr(7));
         wait;
         PTWClose;
         end;
      end;
   Until length(InFileName) = 0;

   {***All is done, clean up things***}
   PTWClose ;
End.
