/*
    PDMenu.prg

    Copyright (c) 1991 Chris Muller
*/

#include "class(y).ch"
#include "win.ch"
#include "gen.ch"
#include "inkey.ch"


create class PDMenu from Menu

    export:

        // method left      // these have to coded as procedures until 
        // method right     //   self() can be handled in a codeblock.
        method  setKeys, clearKeys
        method  drawMnuWin

endclass

constructor (Items), (Items)
return

procedure method drawMnuWin()
    local top    := winTop()  + 1
    local left   := winLeft() + ::parent:newMenuPos()
    local bottom := top  + len(::items) + 1
    local right  := left + ::width      + 1

    ::window := window():new(top, left, bottom, right, SNGLBORD)
return

procedure goLeft
    keyboard chr(K_ESC) + chr(K_LEFT) + chr(K_ENTER)
return

procedure goRight
    keyboard chr(K_ESC) + chr(K_RIGHT) + chr(K_ENTER)
return

procedure method setKeys

    *  Note: self() cannot be accessed by a code-block.
    // set key K_LEFT  to ::left
    // set key K_RIGHT to ::right

    setKey(K_LEFT,  {|| goLeft()})
    setKey(K_RIGHT, {|| goRight()})
return

procedure method clearKeys
    setKey(K_LEFT,  NIL)
    setKey(K_RIGHT, NIL)
return
