/*
   winMsg.prg

   Copyright (c) 1991 Anton van Straaten

   Displays a message in an automatically-sized window and returns the
   window handle.  Message can contain \n for newlines.

   Converted from Summer '87
*/

#include "win.ch"


function winMsg(msg, Border, BordAtt, IntAtt)
    local Pos, Pos1, TotLines, LineLen, Line, BotHght, TopHght, Width
    local i, row, col, lines := {}
    local win

    if at('\n', msg) != 0                       // split lines?
        Pos := 1
        TotLines := LineLen := 0

        while Pos > 0                           // extract chr()
           Pos1 := at('\n', substr(msg, Pos))   // extract '\n' a la 'C'
           if Pos1 == 0
              Line := substr(msg, Pos)          // last line in string
              Pos := 0
           else
              Line := substr(msg, Pos, Pos1 - 1)
              Pos += Pos1 + 1                   // '+ 1' is for double \n
           end

           if len(Line) > LineLen               // get longest line length
              LineLen := len(Line) + 3
           end

           aAdd(lines, Line)                    // add lines to array
           ++TotLines
        end
    else                                        // no split lines
        aadd(Lines, msg)
        LineLen  = len(msg) + 3
        TotLines = 1
    end

    Width   = int(LineLen/2) + 1                // work out height/width
    BotHght = int(TotLines/2)
    TopHght = TotLines - BotHght
*   Alternative box style:                            "ķӺ "
    win := Window():new(12 - TopHght, 40 - Width, 13 + BotHght, 40 + Width,;
                    if(Border == NIL, "͸Գ ", Border), BordAtt, IntAtt)
    row := col := 0
    for i = 1 to TotLines
        @ i - 1, 1 say Lines[i]
        if !empty(Lines[i])
            row = row()
            col = col()
        end
    next

    // tbd: need window method for below
    SetPos(win:top + row, win:left + col)

return win

* eof winmsg.prg
