/*
    win.ch

    Copyright (c) 1991 Anton van Straaten
*/

/*
    following allows WIN.CH to be specified on the Clipper command
    line with the /u option (CLIPPER filename /UWIN.CH)
*/

#ifndef ONOFF
    #include "std.ch"
#endif


/*
    the following can be passed to the 'new' message for the window
    class to specify the type of border desired.
*/

#define     NOBORDER    ""
#define     SNGLBORD    "Ŀ "
#define     DUBLBORD    "ͻȺ "

/*
    the following are constants used as parameters to the 'title' message,
    to position window titles as desired.
*/

#translate  wTL =>  -1      // top left
#translate  wTC =>  -2      // top centre
#translate  wTR =>  -3      // top right
#translate  wBL =>  -4      // bottom left
#translate  wBC =>  -5      // bottom centre
#translate  wBR =>  -6      // bottom right

#translate  row()       =>  winrow()
#translate  col()       =>  wincol()
#translate  maxrow()    =>  winmaxrow()
#translate  maxcol()    =>  winmaxcol()

/*
    The following #command definitions have been adapted from the
    Clipper 5.0 STD.CH header file (copyright Nantucket Corp.)
*/

#command  @ <row>, <col> ;
          => ;
          __AtClear( <row> + wintop(), <col> + winleft(), <row> + wintop(), winMaxCol() )

#command  @ <top>, <left>  CLEAR ;
          => ;
          __AtClear( <top> + wintop(), <left> + winleft(), winMaxRow(), winMaxCol() )

#command  @ <top>, <left>  CLEAR TO <bottom>, <right> ;
          => ;
          __AtClear( <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft())

// Box

#command  @ <top>, <left>, <bottom>, <right>  BOX  <boxstring> ;
          => ;
          __Box( <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft(), <boxstring> )

#command  @ <top>, <left>  TO  <bottom>, <right> ;
          => ;
          __BoxS( <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft())

#command  @ <top>, <left>  TO  <bottom>, <right>  DOUBLE ;
          => ;
          __BoxD( <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft())

// @..SAY

#command  @ <row>, <col> SAY <xpr> PICTURE <pic>  ;
          => ;
          DevPos( <row> + wintop(), <col> + winleft()) ;;
          DevOut(left(transform( <xpr>, <pic> ), _wtrunclen(<col>)))

#command  @ <row>, <col> SAY <xpr> ;
          => ;
          DevPos( <row> + wintop(), <col> + winleft()) ;;
          DevOut(left(transform( <xpr>, ''), _wtrunclen(<col>)))


#command @ <row>, <col> GET <var> [PICTURE <pic>]                      ;
                                  [RANGE <lo>, <hi>]                   ;
=>                                                                     ;
         SetPos(<row> + wintop(), <col> + winleft()) ;                      ;
         AAdd( GetList, _GET_(<var>, <(var)>, <pic>,                   ;
                              {|_1, _2| RangeCheck(_1, _2, <lo>, <hi>)}) )


#command @ <row>, <col> GET <var> [PICTURE <pic>]                      ;
                                  [VALID <valid>] [WHEN <when>]        ;
=>                                                                     ;
         SetPos(<row> + wintop(), <col> + winleft()) ;                      ;
         AAdd( GetList, _GET_(<var>, <(var)>, <pic>, <{valid}>, <{when}>) )


#command  @ <row>, <col> PROMPT <prompt> [MESSAGE <msg>] ;
          => ;
          __AtPrompt( <row> + wintop(), <col> + winleft(), <prompt> , <msg> )


// eof win.ch
