/*
    cylist.prg

    Copyright (c) 1991 Anton van Straaten

    06/02/1991 02:42 avs - creation

    A linked list class.  Used by the windows class.
*/

#include "class(y).ch"


create class List
    instvar items
    instvar currPos

export:
    instvar nSize   noassign

    method  head
    method  tail

    method  next
    method  prev
    method  current

    method  add
    method  insert
    method  delete  = listdelete        // delete() is a reserved function name in Clipper
    method  replace
endclass


constructor (aItems)
    if valtype(aItems) == 'A'
        ::items := aItems
    elseif aItems != NIL
        ::items := { aItems }
    else
        ::items := {}
    end
    ::nSize := len(::items)
    ::currPos := if(::nSize > 0, 1, 0)
return

function method head
return if(::nSize > 0, ::items[::currPos := 1], nil)

function method tail
return if(::nSize > 0, ::items[::currPos := ::nSize], nil)

function method next
return if(::currPos < ::nSize, ::items[++::currPos], nil)

function method prev
return if(::currPos > 1, ::items[--::currPos], nil)

function method current
return if(::currPos > 0, ::items[::currPos], nil)

function method add(item)
    aadd(::items, item)
    ::currPos := ++::nSize
return item

procedure method listdelete
    if ::nSize > 0
        adel(::items, ::currPos)
        asize(::items, --::nSize)
        if ::nSize == 0
            ::currPos := 0
        end
    end
return

function method insert(item)
    asize(::items, ++::nSize)
    if ::currPos == 0
        ++::currPos
    end
    ains(::items, ::currPos)
return ::items[::currPos] := item

function method replace(item)
return if(::currPos > 0, ::items[::currPos] := item, nil)


// eof cylist.c
