/*
    cursor.prg

    Copyright (c) 1991 Anton van Straaten

    Definition of class cursor
*/

#command    if <cond> then <expr>   =>  if <cond> ; <expr> ; end

#include "class(y).ch"


create class cursor
        instvar row
        instvar col
        instvar shape
        instvar color

export:
        method  show
        method  hide
        method  update
        method  up
        method  down
        method  left  = cursleft        // left() and right() are reserved
        method  right = cursright       // function names in Clipper.
endclass



constructor (row, col, shape, color)
    self:update()
    if row <> NIL   then self:row := row
    if col <> NIL   then self:col := col
    if shape <> NIL then self:shape := shape
    if color <> NIL then self:color := color
return



procedure method update
    self:row   := row()
    self:col   := col()
    self:shape := setcursor()
    self:color := setcolor()
return



procedure method show
    setpos(self:row, self:col)
    setcursor(self:shape)
    setcolor(self:color)
return



procedure method hide(lNoUpdate)
    if lNoUpdate == NIL .or. !lNoUpdate
        self:update()
    end
    setcursor(0)
return



procedure method up(n)
    self:row -= if(n == NIL, 1, n)
    if self:row < 0
        self:row := 0
    end
    setpos(self:row, self:col)
return



procedure method down(n)
    self:row += if(n == NIL, 1, n)
    if self:col > maxrow()
        self:col := maxrow()
    end
    setpos(self:row, self:col)
return



procedure method cursleft(n)
    self:col -= if(n == NIL, 1, n)
    if self:col < 0
        self:col := 0
    end
    setpos(self:row, self:col)
return



procedure method cursright(n)
    self:col += if(n == NIL, 1, n)
    if self:col > maxcol()
        self:col := maxcol()
    end
    setpos(self:row, self:col)
return


// eof cursor.prg
