/*
        class(y).ch

        Copyright (c) 1991 Anton van Straaten
*/

/*
        following allows CLASS(Y).CH to be specified on the Clipper command
        line with the /u option (CLIPPER filename /UCLASS(Y).CH)
*/

#ifndef ONOFF
        #include "std.ch"
#endif


#command        CREATE CLASS <className> [FROM <superClass>] ;
        => ;
                function <className>			;;
                static thisClass			;;
                if thisClass == NIL			;;
                thisClass := ClassMaker():new(<"className">, [<superClass>()]) ;;
                export: 				;;
                method new constructor			;;
                private:


#command	ENDCLASS	=>	#include "endclass.ch"

/*
        The EXPORT: command fits in with the terminology used by Nantucket.

        Can abbreviate to EXPO: etc.
*/

#command	EXPORT: 		=>	_cyMbrScope(1)
#command	PRIVATE:		=>	_cyMbrScope(2)
#command	PROTECTED:		=>	_cyMbrScope(4)



#command	INSTVAR <(name1)> [, <(nameN)>] [<na: NOASSIGN, READONLY>] ;
        => ;
                thisClass:variable({ <(name1)> [, <(nameN)>] }, .f., !<.na.>)

#command	CLASSVAR <(name1)> [, <(nameN)>] [<na: NOASSIGN, READONLY>] ;
        => ;
                thisClass:variable({ <(name1)> [, <(nameN)>] }, .t., !<.na.>)

/*
        The first METHOD command allows the declaration of methods which
        reside in the same module as the class declaration, in which case
        the method has the same name as its message, and is automatically
        declared static.  Multiple such methods can be declared with a
        single command.

        The second allows for the declaration of methods that have 'mangled'
        names.  This may be necessary either because the method is defined
        in a different module from the class definition, and therefore has
        global visibility, or because the message name is a reserved word
        or function name in Clipper (examples: delete, right, left).  This
        command only accepts a single method/function pair at a time.

        The third allows declaration of null methods, ie. methods which
        do nothing.  This is useful when a class is expected to accept
        a particular message but does not perform any action in response
        to it.
*/

#command	METHOD <method1> [, <methodN>] [<ct: CONSTRUCTOR>] ;
        => ;
                thisClass:method({ { <"method1">, { || <method1>() } } ;
                                [, { <"methodN">, { || <methodN>() } }] }, <.ct.>, <.ct.>)

#command	METHOD <method> = <func> [<ct: CONSTRUCTOR>]	;
        => ;
                thisClass:method({{ <"method">, { || <func>() } }}, <.ct.>, <.ct.>)

#command	METHOD <method1> [, <methodN>] NULL ;
        => ;
                thisClass:method({ { <"method1">, nil } ;
                                [, { <"methodN">, nil }] }, .f., .f.)

/*
        The CLASS METHOD command has an identical form to the METHOD
        command, but declares class methods rather than instance methods.
*/

#command	CLASS METHOD <method1> [, <methodN>] ;
        => ;
                thisClass:method({ { <"method1">, { || <method1>() } } ;
                                [, { <"methodN">, { || <methodN>() } }] }, .t., .f.)

#command	CLASS METHOD <method> = <func> ;
        => ;
                thisClass:method({{ <"method">, { || <func>() } }}, .t., .f.)

#command	CLASS METHOD <method1> [, <methodN>] NULL ;
        => ;
                thisClass:method({ { <"method1">, nil } ;
                                [, { <"methodN">, nil }] }, .t., .f.)

/*
        the following are all support commands to allow the flexible
        syntax used by the CONSTRUCTOR command, ie. optional omission
        of the default constructor name 'new', optional omission of the
        argument list, etc.
*/

#command	_CYCTOR <name>([<params,...>])[()]	;
        => ;
                procedure method <name>(<params>)

#command	_CYCTOR ([<params,...>])[()]		;
        => ;
                procedure method new (<params>)

#command	_CYSUPCTOR ([<params,...>])[()] 	;
        => ;
                local _cyCtDummy := qself():super:new(<params>)

#command	_CYSUPCTOR <name>([<params,...>])[()]	;
        => ;
                local _cyCtDummy := qself():super:<name>(<params>)

/*
        the constructor must be defined in the same module as the
        class declaration.
*/

#command	CONSTRUCTOR <ctor> [, <superCtor> ] ;
        => ;
                _CYCTOR <ctor>()	;;
                _CYSUPCTOR <superCtor>()


#command	PROCEDURE METHOD <name> 	;
        => ;
                __cyMethodType procedure <name>

#command	FUNCTION METHOD <name>		;
        => ;
                __cyMethodType function <name>


#define __cyMethodType

/*
        self is a reserved word in Class(y) modules.  It is only valid
        within methods.  :: is shorthand for message sends to self.
*/

#translate	self		=>	qself()
#translate	::<msgName>	=>	qself():<msgName>

/*
        An Eval() is used below since the preprocessor will not
        repeat <target> in a repeating result clause.  Thanks to
        Mike Schinkel for this solution.
*/

#command        SEND <target> \<- <msg1> [, <msgN>]	;
        => ;
                eval( { |o| o:<msg1> [, o:<msgN>] } )


// eof class(y).ch
