/*
************************************************************************

                                DGECLC.C

         dGE Interface for combined Clipper and C applications

                   (c) 1991 Pinnacle Publishing, Inc.

************************************************************************
*/

typedef int (*PFI)();

int     DGEMAINVGA();           /* dGE drivers */
int     DGEMAINCGM();
int     DGEMAINCGC();
int     DGEMAINHRC();
int     dgenul();               /* NUL driver */

int rval, stlen=0;
char *st=0;

PFI dgemgen[] =
{
  DGEMAINHRC,
  DGEMAINCGM,
  dgenul,
  DGEMAINVGA,
  DGEMAINVGA,
};

double  dgeatof();

int     dgedid = 0;
int     dgeut = -1;

int dgenul()
{ return 6; }

/*----------------------------------------
**      SETVIDEO  f 68
** 3 = HRC, 4 = CGM, 5 = CGC, 6 = EGA, 7 = VGA
**----------------------------------------
*/
int setvideo(int a)
{
  dgedid = a - 3; if(dgedid < 0 || dgedid > 4) goto out;
  rval = (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 68);
  if(rval != 6) dgeut = 0;
  out: return rval;
}

/*----------------------
**      SETHIRES  f 0
**----------------------
*/
int sethires(int a)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 0);
}

/*----------------------
**      SETTEXT f 1
**----------------------
*/
int settext()
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 1);
}

/*----------------------
**      DISKFILE f 2
**----------------------
*/
int diskfile(int a,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 2);
}

/*----------------------
**      PRINTSCRN f 3
**----------------------
*/
int printscrn()
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 3);
}

/*----------------------
**      LOADCSET  f 4
**----------------------
*/
int loadcset(int a,char *st)
{
  stlen = dgestlen(st);
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 4);
}

/*----------------------
**      GETSIN    f 7
**----------------------
*/
double getsin(int a,int b)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i]=0;
  if (dgeut) dgeinst();
  rval = (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 5);
  return dgeatof(st);
}

/*----------------------
**      DRAWLINE f 6
**----------------------
*/
int drawline(int a,int b,int c,int d,int e,int f,int g)
{
  return (*dgemgen[dgedid])(st,stlen,0,g,f,e,d,c,b,a, 6);
}

/*----------------------
**      DRAWCIRCLE f 7
**----------------------
*/
int drawcircle(int a,int b,int c,int d,int e,int f,int g,int h)
{
  return (*dgemgen[dgedid])(st,stlen,h,g,f,e,d,c,b,a, 7);
}

/*----------------------
**      SHADE f 8
**----------------------
*/
int shade(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 8);
}

/*----------------------
**      BOXFILL  f 9
**----------------------
*/
int boxfill(int a,int b,int c,int d,int e,int f)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,f,e,d,c,b,a, 9);
}

/*----------------------
**      CLRSCREEN f 10
**----------------------
*/
int clrscreen()
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 10);
}

/*----------------------
**      CLRLINE f 11
**----------------------
*/
int clrline(int a,int b,int c)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 11);
}

/*----------------------
**      CLRWINDOW f 12
**----------------------
*/
int clrwindow(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 12);
}

/*----------------------
**      XYAXES f 13
**----------------------
*/
int xyaxes(int a,int b,int c,int d,int e,int f,int g,int h)
{
  return (*dgemgen[dgedid])(st,stlen,h,g,f,e,d,c,b,a, 13);
}

/*----------------------
**      POLARAXES  f 14
**----------------------
*/
int polaraxes(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 14);
}

/*----------------------
**      GETCHR  f 15  (GETCHAR)
**----------------------
*/
int getchr(int a)
{
  int stlen=1; char st[2];
  st[0]=' ';st[1]=0;
  if (dgeut) dgeinst();
  rval = (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 15);
  return (int) st[0];
}

/*----------------------
**      GETSTRING f 16
**----------------------
*/
char *getstring(int a,int b,int c,int d,int e)
{
  static char st[81];
  (*dgemgen[dgedid])(st,80,0,0,0,e,d,c,b,a, 16);
  return st;
}

/*----------------------
**      SAYSTRING f 17
**----------------------
*/
int saystring(int a,int b,int c,int d,int e,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 17);
}

/*----------------------
**      SAYICON
**      This function is omitted from 'C' library
**      Use Drawicon()
**----------------------
*/

/*----------------------
**      DATARESET f 19
**----------------------
*/
int datareset()
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 19);
}

/*----------------------
**      DATASTORE f 20
**----------------------
*/
int datastore(int a,int b,int c,int d)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 20);
}

/*----------------------
**      PIECHART
**----------------------
*/
int piechart(int a,int b,int c)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 21);
}

/*----------------------
**      BARGRAPH f 22
**----------------------
*/
int bargraph(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 22);
}

/*----------------------
**      XYGRAPH f 23
**----------------------
*/
int xygraph(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 23);
}

/*----------------------
**      POLARGRAPH f 24
**----------------------
*/
int polargraph(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 24);
}

/*----------------------
**      STATS f 25
**----------------------
*/
int stats(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 25);
}

/*----------------------
**      BESTFIT f 26
**----------------------
*/
int bestfit(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 26);
}

/*----------------------
**      POLYLINE f 27
**----------------------
*/
int polyline(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 27);
}

/*----------------------
**      STXCHAR f 28
**  (Internal function)
**----------------------
*/
int stxchar(int a,int b,int c,int d,int e,int f,int g)
{
  return (*dgemgen[dgedid])(st,stlen,0,g,f,e,d,c,b,a, 28);
}

/*----------------------
**      SETPAL f 29
**----------------------
*/
int setpal(int a,int b,int c)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 29);
}

/*----------------------
**      SETVER f 30
**----------------------
*/
int setver(int a)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 30);
}

/*----------------------
**      HLCGRAPH f 31
**----------------------
*/
int hlcgraph(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 31);
}

/*----------------------
**      SETWIN f 32
**----------------------
*/
int setwin(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 32);
}

/*----------------------
**      SETDELIM f 33
**----------------------
*/
int setdelim(int a)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 33);
}

/*----------------------
**      FIXPOS f 34
**----------------------
*/
int fixpos(int a,int b)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 34);
}

/*----------------------
**      MOVEVEC f 35
**----------------------
*/
int movevec(int a,int b)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 35);
}

/*----------------------
**      DRAWVEC f 36
**----------------------
*/
int drawvec(int a,int b,int c,int d,int e,int f)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,f,e,d,c,b,a, 36);
}

/*----------------------
**      POLYVEC f 37
**----------------------
*/
int polyvec(int a,int b,int c,int d,int e,int f,int g)
{
  return (*dgemgen[dgedid])(st,stlen,0,g,f,e,d,c,b,a, 37);
}

/*----------------------
**      VECSTRING f 38
**----------------------
*/
int vecstring(int a,int b,int c,int d,int e,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 38);
}

/*----------------------
**      VECICON
**      This function is omitted from 'C' library
**      Use Drawicon()
**----------------------
*/

/*----------------------
**      DATAPC f 40
**----------------------
*/
int datapc(int a)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 40);
}

/*----------------------
**      DATARANGE f 41
**----------------------
*/
int datarange(int a,int b)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 41);
}

/*----------------------
**      EDSTRING f 42
**----------------------
*/
int edstring(int a,int b,int c,int d,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 42);
}
/*----------------------
**      CLRSTRING f 43
**----------------------
*/
int clrst()
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 43);
}

/*----------------------
**      PLOTON f 44
**----------------------
*/
int ploton(int a,int b,int c,int d,int e)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 44);
}

/*----------------------
**      PLOTCSET f 45
**----------------------
*/
int plotcset(int a,int b,int c,int d)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 45);
}

/*----------------------
**      PLOTOFF f 46
**----------------------
*/
int plotoff()
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 46);
}

/*----------------------
**      PRINTFILE 47
**----------------------
*/
int printfile(int a,char *st)
{
  stlen = dgestlen(st);
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 47);
}

/*----------------------
**      PRINTPCL  f 48
**----------------------
*/
int printpcl(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 48);
}

/*----------------------
**      TIMEGRAPH f 49
**----------------------
*/
int timegraph(int a,int b,int c,int d,int e,int f,int g,int h)
{
  return (*dgemgen[dgedid])(st,stlen,h,g,f,e,d,c,b,a, 49);
}

/*----------------------
**      TIMEDATA f 50
**----------------------
*/
int timedata(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 50);
}

/*----------------------
**      GETASIN f 51
**----------------------
*/
double getasin(int a,int b)
{
  int i,stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  if (dgeut) dgeinst();
  rval = (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 51);
  return dgeatof(st);
}

/*----------------------
**      MOVEXY f 52
**----------------------
*/
int movexy(int a,int b)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 50);
}

/*----------------------
**      DRAWXY f 53
**----------------------
*/
int drawxy(int a,int b,int c,int d,int e,int f)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,f,e,d,c,b,a, 53);
}

/*----------------------
**      PLOTPEN f 54
**----------------------
*/
int plotpen(int a,int b,int c)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 54);
}

/*----------------------
**      LABELX f 55
**----------------------
*/
int labelx(int a,int b,int c,int d,int e,int f,int g,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,g,f,e,d,c,b,a, 55);
}

/*----------------------
**      LABELY  f 56
**----------------------
*/
int labely(int a,int b,int c,int d,int e,int f,int g,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,g,f,e,d,c,b,a, 56);
}

/*----------------------
**      LABELPIE  f 57
**----------------------
*/
int labelpie(int a,int b,int c,int d,int e,int f,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,f,e,d,c,b,a, 57);
}

/*----------------------
**      GETCURX   f 58
**----------------------
*/
int getcurx()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 58);
  return dgeatoi(st);
}

/*----------------------
**      GETCURY   f 59
**----------------------
*/
int getcury()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 59);
  return dgeatoi(st);
}

/*----------------------
**      GETCC   f 60
**----------------------
*/
double getcc()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 60);
  return dgeatof(st);
}

/*----------------------
**      GETMAX   f 61
**----------------------
*/
double getmax()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 61);
  return dgeatof(st);
}

/*----------------------
**      GETMEAN   f 62
**----------------------
*/
double getmean()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 62);
  return dgeatof(st);
}

/*----------------------
**      GETMIN   f 63
**----------------------
*/
double getmin()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 63);
  return dgeatof(st);
}

/*----------------------
**      GETSD   f 64
**----------------------
*/
double getsd()
{ int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 64);
  return dgeatof(st);
}

/*----------------------
**      MINMAX  f 65
**----------------------
*/
int minmax(int a,int b,int c)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 65);
}

/*----------------------
**      CLRWIN f 66
**----------------------
*/
int clrwin(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 66);
}


/*----------------------
**      MPCONFIG f 67
**
**----------------------
*/
int mpconfig(int a,int b,int *a1,int *a2,int *a3,int *a4)
{
  int seqflag=256;
  if (dgeut) dgeinst();
  rval = (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a | seqflag, 67);
    seqflag = seqflag << 1;
  rval |= (*dgemgen[dgedid])(st,stlen,a1[7],a1[6],a1[5],a1[4],a1[3],a1[2],a1[1],a1[0] | seqflag,67 );
    seqflag = seqflag << 1;
  rval |= (*dgemgen[dgedid])(st,stlen,a2[7],a2[6],a2[5],a2[4],a2[3],a2[2],a2[1],a2[0] | seqflag,67 );
    seqflag = seqflag << 1;
  rval |= (*dgemgen[dgedid])(st,stlen,a3[7],a3[6],a3[5],a3[4],a3[3],a3[2],a3[1],a3[0] | seqflag,67 );
    seqflag = seqflag << 1;
  rval |= (*dgemgen[dgedid])(st,stlen,a4[7],a4[6],a4[5],a4[4],a4[3],a4[2],a4[1],a4[0] | seqflag,67 );
  return rval;
}

/*----------------------
**      GETVIDEO f 69
**----------------------
*/
int getvideo(int a)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  if (dgeut) dgeinst();
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 69);
  return dgeatoi(st); }

/*----------------------
**      USERICON f 70
**----------------------
*/
int usericon(int a,char *st)
{
  return (*dgemgen[dgedid])(st,32,0,0,0,0,0,0,0,a, 70);
}

/*----------------------
**      DRAWICON  f 71
**----------------------
*/
int drawicon(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 71);
}

/*----------------------
**      MRESET f 72
**----------------------
*/
int mreset()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  if (dgeut) dgeinst();
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 72);
  return dgeatoi(st);
}

/*----------------------
**      MCURON f 73
**----------------------
*/
int mcuron()
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 73);
}

/*----------------------
**      MCUROFF f 74
**----------------------
*/
int mcuroff()
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 74);
}

/*----------------------
**      MFIXPOS f 75
**----------------------
*/
int mfixpos(int a,int b)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 75);
}

/*----------------------
**      MSTATUS f 76
**----------------------
*/
int mstatus()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 76);
  return dgeatoi(st);
}

/*----------------------
**      MGETX    f 77
**----------------------
*/
int mgetx()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0,77);
  return dgeatoi(st);
}

/*----------------------
**      MGETY  f 78
**----------------------
*/
int mgety()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 78);
  return dgeatoi(st);
}

/*----------------------
**      MSETWIN  f 79
**----------------------
*/
int msetwin(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 79);
}

/*----------------------
**      MMOTION f 80
**----------------------
*/
int mmotion()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 80);
  return dgeatoi(st);
}

/*----------------------
**      MCURTYPE f 81
**----------------------
*/
int mcurtype(int a)
{
  if(dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 81);
}

/*----------------------
**      PICWRITE f 82
**----------------------
*/
int picwrite(int a,int b,int c,int d,int e,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 82);
}

/*----------------------
**      PICREAD    f 83
**----------------------
*/
int picread(int a,int b,int c,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 83);
}

/*----------------------
**      GANTT  f 84
**----------------------
*/
int gantt(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 84);
}

/*----------------------
**      LOADVTEXT f 85
**----------------------
*/
int loadvtext(char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 85);
}

/*----------------------
**      DRAWVTEXT  f 86
**----------------------
*/
int drawvtext(int a,int b,int c,int d,int e,int f,int g,int h,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,h,g,f,e,d,c,b,a, 86);
}

/*----------------------
**      LOADICON f 87
**----------------------
*/
int loadicon(char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 87);
}

/*----------------------
**      SETPRN  f 88
**----------------------
*/
int setprn(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 88);
}

/*----------------------
**      XORBLOCK  f 89
**----------------------
*/
int xorblock(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 89);
}

/*----------------------
**      GETFONTINF   f 90
**----------------------
*/
double getfontinf(int a)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i]=0;
  if (dgeut) dgeinst();
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 90);
  return dgeatof(st);
}

/*----------------------
**      LOADMPRN   f 91
**----------------------
*/
int loadmprn(int a,char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 91);
}

/*----------------------
**      MSETHOT    f 92
**----------------------
*/
int msethot(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 92);
}

/*----------------------
**      MGETHOT   f 93
**----------------------
*/
int mgethot()
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 93);
  return dgeatoi(st);
}

/*----------------------
**      ENUMMPRN f 94
**----------------------
*/
char *enummprn(int a,char *st)
{
  char *temp;
  static char inst[80];

  if (dgeut) dgeinst();
  temp = inst;
  stlen = dgestlen(st);
  stlen = (stlen < 80) ? stlen : 80;
  while( (*temp++ = *st++) != 0) ;
  (*dgemgen[dgedid])(inst,stlen,0,0,0,0,0,0,0,a, 94);
  return inst;
}

/*----------------------
**      PRINTPS  f 95
**----------------------
*/
int printps(int a,int b,int c,int d,int e,int f)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,f,e,d,c,b,a, 95);
}

/*----------------------
**      VPON f 96
**----------------------
*/
int vpon(int a,int b,int c,int d,int e,int f,int g)
{
  return (*dgemgen[dgedid])(st,stlen,0,g,f,e,d,c,b,a, 96);
}

/*----------------------
**      VPOFF f 97
**----------------------
*/
int vpoff(int a)
{
  if (dgeut) dgeinst();
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 97);
}

/*----------------------
**      PSFONT f 98
**----------------------
*/
int psfont(char *st)
{
  stlen = dgestlen(st);
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,0, 98);
}

/*----------------------
**      SETRGBPAL  f 99
**----------------------
*/
int setrgbpal(int a,int b)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 99);
}

/*----------------------
**      SETRGBDAC  f 100
**----------------------
*/
int setrgbdac(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 100);
}

/*----------------------
**      CLIPWIN f 101
**----------------------
*/
int clipwin(int a,int b,int c,int d)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,d,c,b,a, 101);
}

/*----------------------
**      GETPIX    f 102
**----------------------
*/
int getpix(int a,int b)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i]=0;
  if (dgeut) dgeinst();
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 102);
  return dgeatoi(st);
}

/*----------------------
**      GETBF    f 103
**----------------------
*/
double getbf(int a)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i]=0;
  if (dgeut) dgeinst();
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 103);
  return dgeatof(st);
}

/*----------------------
**      SNAPCOPY f 104
**----------------------
*/
int snapcopy(int a,int b,int c,int d,int e)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 104);
  return dgeatoi(st);
}

/*----------------------
**      SNAPPASTE f 105
**----------------------
*/
int snappaste(int a,int b,int c)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,c,b,a, 105);
}

/*----------------------
**      SNAPKILL f 106
**----------------------
*/
int snapkill(int a)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a, 106);
}

/*----------------------
**      GETSNAPINF  f 107
**----------------------
*/
int getsnapinf(int a)
{
  int i, stlen=14; char st[15];
  for(i = 0 ; i < 14 ; i++) st[i] = ' '; st[i] = 0;
  (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,0,a,107);
  return dgeatoi(st);
}

/*----------------------
**      PRNDEV f 108
**----------------------
*/
int prndev(int a,int b)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,0,0,0,b,a, 108);
}

/*----------------------
**      PCLFONT f 109
**----------------------
*/
int pclfont(int a,int b,int c,int d,int e)
{
  return (*dgemgen[dgedid])(st,stlen,0,0,0,e,d,c,b,a, 109);
}

/*------------------------
**      dgeatof
**------------------------
*/
double dgeatof(char *st)
{
  char c;
  int i, minus = 1, man = -1;
  double val=0,mult=0.1;

  for(i = 0 ; i < dgestlen(st) ; i++)
  {
    c = st[i];
    if(c == ' ') continue;
    if(c == '-') {minus = -1; continue; }
    if(c == '.') {man = 0; continue; }
    if(c > '9' || c < '0') continue;
    if(man) { val *= 10; val += (c-'0'); continue; }
    else {val += ((float)(c-'0'))*mult; mult *= 0.1; continue; }
  }

  return (val * minus);
}

/*------------------------
**      dgeatoi
**------------------------
*/
int dgeatoi(char *st)
{ int val=0,sig=0; char c;
  for(;;)
  { if((c=*st++) == ' ') continue;        /* ignore leading spaces */
    if(c == '-') {sig = 1; continue; }
    if(c>'9' || c<'0' || c=='.') break;
    val = val*10 + c-'0';
  }
  if( sig == 1 ) val = -val;
return val; }

/*------------------------
**      dgestlen
**------------------------
*/
int dgestlen(char *st)
{ int i=0; while(*st++ != 0) i++; return i; }

/*------------------------
**      dgeinst
**------------------------
*/
int dgeinst()
{
  int i;
  for(i = 4 ; i >=0 ; i--)  /* dummy call to datareset */
  { rval = (*dgemgen[i])(st,stlen,0,0,0,0,0,0,0,0, 19);
    if(rval != 6) {dgedid = i; dgeut = 0; break; } }
  return (rval);
}
