*****
* CIRCDEMO.PRG
* Demonstration of Scan Filled Circle routine with C function
*
* Date:         05/07/91
* Written by:   Peter M. Freese
*               Pinnacle Publishing, Inc.
*
* This program demonstrates a circle routine that allows you to draw filled
* circles on top of other screen objects in dGE.  Circles drawn with dGE's
* DRAWCIRCLE() function cannot be filled unless the circle is drawn on a
* blank screen region, since they are filled with the SHADE() function.
* The CIRCLE() routine presented here allows circles to be drawn over other
* image data, and fill somewhat faster than the DRAWCIRCLE() function.
*
*

local i:=49

sethires(0)
inkey(0)

/* draw one that uses the flood fill (SHADE) routine */
drawcircle(675,500,500,0,360,8,0,15)	

inkey(0)

/* now draw a bunch of scanned ones in CLIPPER */
while i>0
  circle(675,500,i*10,MOD(i-1,15)+1)
  --i
end

inkey(0)
settext()
