#define IS_MULT
#define USEWAIT 10
#define ADDWAIT 10
#define RECWAIT 10
#define FILEWAIT 10
#define rptpoint &user.rptpt
#command USE <dbf> INDEX <ntx,...> => ;
    if netuse(<"dbf">, .f., USEWAIT) ; set index to <ntx>; else; return; endif
#command USE <dbf> => if .not. netuse(<"dbf">, .f., USEWAIT); return; endif
#command APPEND BLANK => if .not. addrec(ADDWAIT); return; endif
#command RE_NTX <dbf> => if .not. netuse(<"dbf">, .t., USEWAIT); return; endif
#command IF MULT LOCK REC => if .not. reclock(RECWAIT); return; endif
#command IF MULT LOCK FILE => if .not. fillock(FILEWAIT); return; endif
#command IF MULT UNLOCK => unlock
#command EXCL OFF => set exclusive off

* NOTES: This file, multiuse.ch, goes in the multiuse subdirectory under the prg
*        file directory.  This is the subdirectory where multiuser obj files are
*        stored.
*        ANOTHER file called multiuse.ch goes in the singluse subdirectory.
*        This version has only one line with nothing but an asterisk in col.1.
*        It is the only necessary occupant of the singluse subdirectory.

*        rptpoint happens to be a "pointer" dbf that I use to single out certain
*          data records for reporting.  In the multiuser case, I want each user
*          to have his/her own set of pointers.  This is merely illustrative,
*          because I'm not sure where the "&user." part comes from!

*        IF MULT: Besides putting #include "director.ch"
*          at the beginning, these are the only changes needed in your prg
*          files.  You salt them in around REPLACEs.
*        EXCL OFF: Oh, yes. Put that in at the beginning of your main prg.
*        RE_NTX: Oh, yes. Put  re_ntx /filename/  before reindexing or rebuiling
*                the index, to (attempt to) get exclusive access.
*                Perhaps you need to put  EXCL OFF  after reindexing, too.

*        netuse, addrec, reclock, and fillock are calls to functions in
*        LOCKS.PRG, that comes with Clipper 5 (normally it's in 
*        c:\clipper5\source\sample) _as modified by_ Rick Spence in his Clipper 
*        books. (He puts in the stuff where the user is asked if he wants to
*        wait for the record or file to be freed up, as I recall).
