FUNCTION configok
*
* Author.: Joseph D. Booth
* Company: Precision Engineered Parts, Inc
*          610 Lakeside Drive
*          Southhampton, PA 18966
* W Phone: 215-953-1202
*
* Purpose: This function may be used to check the configuration of the computer
*          which the application is being run on.  If the problem is something
*          which can be corrected, (e.g. CONFIG.SYS set improperly), the system
*          will correct it for the user.
*
* Syntax.: CONFIGOK( <expN1> , <expN2> )
* Where..:
*          <expN1>     the number of files needed in CONFIG.SYS
*          <expN2>     the number of buffers need in CONFIG.SYS
*
* Returns: .T.      System is configured O.K. for this application
*          .F.      The system is not configured O.K.
*
* Notes..: This program uses the functions FILES(),BUFFERS(),COUNTRY() from
*          Tom Rettig's Library.  If you do not have Tom Rettig's Library, you
*          will need to write your own FILES(),BUFFERS(), and COUNTRY() function.
*
*          If you create your own functions, they should work as follows:
*
*          FILES()    - PARAMETERS:  none
*                     - RETURNS   :  < 0   - CONFIG.SYS file does not exist
*                                      0   - No FILES statement is found
*                                    > 0   - Number of files currently set
*
*          BUFFERS()  - PARAMETERS:  none
*                     - RETURNS   :  < 0   - CONFIG.SYS file does not exist
*                                      0   - No BUFFERS statement is found
*                                    > 0   - Number of buffers currently set
*
*          COUNTRY()  - PARAMETERS:  none
*                     - RETURNS   :  < 0   - CONFIG.SYS file does not exist
*                                      0   - No FILES statement is found
*                                    > 0   - Country Code set in COUNTRY=
*
*          If you currently do not own Tom Rettig's Library, you should take
*          a serious look at it.  It is a very useful library of functions,
*          and is available at a reasonable cost.
*
PARAMETERS filesneed,buffsneed
******************************************************************************
* Check CONFIG.SYS for buffers and files.  If the CONFIG.SYS file is not found,
* or does not set files to at least FILESNEED and buffers to at least BUFFSNEED,
* the program will correct the CONFIG.SYS file and suggest that the user
* reboots before running the application again.
******************************************************************************
PRIVATE isok,cfgfiles,cfgbuffs
*
isok       = .F.
cfgfiles   = files()
cfgbuffs   = buffers()
cfgcountry = country()
*
DO CASE
   CASE cfgcountry = 1
      SET DATE AMERICAN
   CASE cfgcountry = 33
      SET DATE FRENCH
   CASE cfgcountry = 39
      SET DATE ITALIAN
   CASE cfgcountry = 44
      SET DATE BRITISH
   CASE cfgcountry = 49
      SET DATE GERMAN
ENDCASE
*
IF cfgfiles < filesneed .OR. cfgbuffs < buffsneed
*
*
   DO CASE
      CASE cfgfiles < 0                         && CONFIG.SYS could not be found
******************************************************************************
* We will create a new CONFIG.SYS file here since none exists
******************************************************************************
         SET CONSOLE OFF
         SET ALTERNATE TO C:\CONFIG.SYS
         SET ALTERNATE ON
         ? "FILES="+STR(filesneed)
         ? "BUFFERS="+STR(buffsneed)
         SET ALTERNATE OFF
         SET CONSOLE ON
      OTHERWISE
******************************************************************************
* Backup up old CONFIG.SYS, and try to correct the current one
******************************************************************************
         SET CONSOLE OFF
         COPY FILE C:\CONFIG.SYS TO C:\CONFIG.OLD         && Backup CONFIG.SYS
         CREATE tempfile
         USE tempfile
         APPEND BLANK
         REPLACE field_name WITH workstring, field_type WITH "C", ;
                 field_len  WITH 254
         CREATE holding FROM tempfile
         ERASE tempfile
         USE holding
         APPEND FROM C:\CONFIG.SYS SDF
******************************************************************************
* No FILES= statement was found is CONFIG.SYS - we will add one
******************************************************************************
         IF cfgfiles = 0
            APPEND BLANK
            REPLACE workstring WITH "FILES="+STR(filesneed)
         ENDIF
******************************************************************************
* No BUFFERS= statement was found is CONFIG.SYS - we will add one
******************************************************************************
         IF cfgbuffs = 0
            APPEND BLANK
            REPLACE workstring WITH "BUFFERS="+STR(buffsneed)
         ENDIF
******************************************************************************
* A FILES= statement was found, but the value is wrong.  We will correct it
******************************************************************************
         IF cfgfiles > 0 .AND. cfgfiles < filesneed
            LOCATE ALL FOR AT( "FILES=" , UPPER(workstring) ) > 0
            IF found()
               REPLACE workstring WITH "FILES="+STR(filesneed)
            ENDIF
         ENDIF
******************************************************************************
* A BUFFERS= statement was found, but the value is wrong.  We will correct it
******************************************************************************
         IF cfgbuffs > 0 .AND. cfgbuffs < buffsneed
            LOCATE ALL FOR AT( "BUFFERS=" , UPPER(workstring) ) > 0
            IF found()
               REPLACE workstring WITH "BUFFERS="+STR(buffsneed)
            ENDIF
         ENDIF
******************************************************************************
* The CONFIG.SYS file has been corrected.  We now place it into the root
* directory and suggest re-booting.
******************************************************************************
         GO TOP
         SET ALTERNATE TO C:\CONFIG.SYS
         SET ALTERNATE ON
         DO WHILE .NOT. eof()
            IF LEN(TRIM(workstring)) > 0
               ? TRIM(workstring)
            ENDIF
            SKIP +1
         ENDDO
         SET ALTERNATE OFF
         SET CONSOLE ON
         ERASE holding
   ENDCASE
   CLEAR
   @ 10,10 SAY "Your configuration file (CONFIG.SYS) was not properly set up"
   @ 12,10 SAY "The file has been corrected.  Reboot the system and try again"
   @ 14,10 SAY "The system may be rebooted by holding down the Ctrl and Alt "
   @ 15,10 SAY "keys, and simultaneously pressing the Del key."
   @ 18,10
   isok=.F.
ELSE
   isok=.T.
ENDIF
CLOSE ALTERNATE
RETURN isok && ---------------------------------------------------------------