*..ChcSamp2.Prg ::= Sample program for MakeChoice()
*  Avelino Associates, San Francisco, CA  5/88
*  Michael Palladino, (415) 751-2719
*                     CompuServe 73437,270
*
*  Revised 5/27/88 to simulate Rettig's ChrCount() with CHRCNT().
*
*  Here's a take on making ACHOICE() even easier to use.
*  By passing in a few minimum Parameters (explained below), MAKECHOICE()
*     will pop a box, and show the choices.  You pass in your choices as a
*     string, with each choice (including the last) terminated by a tilde
*     (~) sign.  The UDF calculates the bottom right corner of the box,
*     clears it, and shows the choices.
*
*  MAKECHOICE() takes the number of the element returned by ACHOICE()
*     and in turn returns a chr string created by combining a
*     unique character you pass in (any letter will do) and the actual
*     menu choice (with spaces stripped).  If the menu choice is long,
*     the choice is truncated to the first 10 characters.
*     Example: if the menu choice is ADD and the unique character is "p",
*     MAKECHOICE would return "PADD".  If the menu choice was
*     "Pick me next" and the unique character was "t", the return would
*     be "TPICKMENEX".
*
*     The unique character allows for nested MAKECHOICE()s without
*     conflict among PUBLICS.
*
*     Which brings us to PUBLICS.
*
*  PUBLICS ::= MAKECHOICE() creates some relevant PUBLICS.  It uses
*     SAVESCREEN() to save the whole where the box will pop.  The publics
*     it creates are always preceded by the unique character passed in.
*     For example, if the unique character is "p", the PUBLICS pHole, pT,
*     pL, pB, pR are automatically created.  You can use them later in the
*     program to make the menu box return from whence it came.
*     Example ::= when I use this for Next, Previous, Edit kinds of things,
*     I like the menu to disappear while in the EDIT mode, but remain while
*     NEXTing and PREVIOUSing.  The first line in the "PEDIT" CASE statement
*     would be RESTSCREEN(pT,pL,pB,pR,pHole).  The BOX and Choices will repaint
*     the next go around.
*
*     Another public keeps track of the last element chosen by ACHOICE().
*     It is a combination of the unique character and the name "LastChc"
*     (such as "pLastChc").  That way, as you are looping about,
*     subsequent calls to MAKECHOICE() will pop up with the last selection
*     highlighted (again, good for NEXTing and PREVIOUSing).
*
*     The last public is named with the unique character and the word "Array"
*     (example "pArray").  This is the array initially created by MAKECHOICE()
*     from the menu string passed in.  If this array is not undefined,
*     MAKECHOICE() uses a big IF to go right to popping the BOX.
*
*  RlsChoice() ::= just pass in the unique charactre and this RELEASES
*     all of the PUBLICS created by MAKECHOICE().  Just a bit of housekeeping
*     when you are through.
*
*  SO
*     I'd appeciate any comments.  I use this all the time.  I hope it's of
*     interest.
*
*     Michael Palladino
*==========================================================================

*=== Memvars
SingleBox = "Ŀ"
DoubleBox = "ͻȺ"
SDBox     = "ķӺ"
DSBox     = "͸Գ"

PUBLIC sc_dim, sc_bt, sc_rev
sc_dim = "W/N,N/W,,,W/N"
sc_bt  = "W+/N,N/W,,,W/N"
sc_rev = "N/W,W+/N,,,W/N"

*=== Menu choices
ChoiceOne  = "Add~Find~Next~Previous~Delete~Quit~"
ChoiceTwo  = "Pick me~No, pick me~How 'bout me?~Quit~"
ChoiceTres = "Yes~No~"

*===
CLEAR SCREEN
WAIT
CornerMess = " The choice you selected RETURNs: "
                           
DO WHIL .T.

   @ 1,0,24,79 BOX DSBox+""
   @ 3,3 SAY CornerMess + SPACE(10)

   DO WHIL .T.
      SETCOLOR(sc_bt)
      Select1 = MakeChoice(5,25,DSbox+"",sc_rev,ChoiceOne,"p")

      *=== This would be whatever you wanted the choice to actually do
      *    One case per CHOICE

      DO CASE
         CASE Select1 = "PADD"
            *
         CASE Select1 = "PFIND"
            *
         CASE Select1 = "PQUIT"
         
            RESTSCREEN(pT,pL,pB,pR,pHole)
            RlsChoice("p")

            *===
            EXIT
            *===
      ENDC
   
      @ 3,3+LEN(CornerMess) SAY LEFT(Select1+SPACE(10),10)
   ENDD

   DO WHIL .T.

      Select2 = MakeChoice(15,45,DSbox+"",sc_rev,ChoiceTwo,"t")
      *=== This would be whatever you wanted the choice to actually do
      *    One case per CHOICE

      DO CASE
         CASE Select2 = "TPICKME"
            *
         CASE Select2 = "TNO,PICKME"
            *
         CASE Select2 = "THOW'BOUTM"
            *
         CASE Select2 = "TQUIT"
         
            RESTSCREEN(tT,tL,tB,tR,tHole)
            RlsChoice("t")

            *===
            EXIT
            *===
      ENDC
   
      @ 3,3+LEN(CornerMess) SAY LEFT(Select2+SPACE(10),10)

   ENDD
      t =  8
      l = 35
      SETCOLOR(sc_bt)
      @ t - 2, l SAY " Do you really want to quit? "
      SETCOLOR(sc_dim)

      Select3 = MakeChoice(8,35,DSbox+"",sc_bt,ChoiceTres,"z")

      RlsChoice("z")

      IF Select3 = "ZYES"
         
         *===
         EXIT
         *===

      ENDI                

ENDD

CLEA SCREEN
RETURN

*===
* Functions
*---

*===
* MAKECHOICE()
* PARAMETERS:
* t,l    ::= top, left corner of BOX that will contain choices
*            The bottom and right will be derived from the number of
*            menu choices in the str memvar and the longest choice.
* frame  ::= Standard Clipper memvar containing the characters used for
*            the BOX command (i.e., DSBox  = "͸Գ")
* attr   ::= Screen attributes for the menu (SETCOLOR() will be used to
*            reset the screen colors to their initial settings after the
*            function is done.
*
*  str   ::= String containing the menu choices.  Each choice must be
*            terminated by a tilde (~).
*
* char   ::= A character to differentiate between various active
*            MAKECHOICE() calls.  Any character (or even more that one
*            character) may be used (i.e., "P", "NO1")
*
* Creates several PUBLICS (see sample program ChcSamp.Prg).
*

FUNCTION MakeChoice
   PARAMETERS t,l,frame,attr,str,char
   PRIVATE ChcArray, StartColor
   StartColor = SETCOLOR()
   ChcArray   = char + "Array"
   LastChc    = char + "LastChc"
   ThisT      = char + "T"          && These will be coordinates for the BOX
   ThisL      = char + "L"
   ThisB      = char + "B"
   ThisR      = char + "R"
   ThisHole   = char + "Hole"

   IF TYPE("&ChcArray.") = "U"

      *=== If this is the first call, create the PUBLICS and array
      PUBLIC &LastChc.
      &LastChc. = 1
      EleCnt    = CHRCNT("~",str)
      Longest   = 0
      PUBLIC &ChcArray.[EleCnt]

      *===
      * The FOR...NEXT loop loads subsequent menu choices into elements
      * (based on all characters from the first to the ~ sign.
      * The Longest memvar is used to determine the width of the box
      * based on the longest menu choice.
      * The str memvar then creates
      *---
      FOR i = 1 TO EleCnt
         &ChcArray.[i] = LEFT(str,(AT("~",str)-1))
         Longest       = MAX(Longest,LEN(&ChcArray[i]))
         str           = SUBS(str,(AT("~",str)+1))
      NEXT
      b = t + LEN(&ChcArray.) + 1
      r = l + Longest + 2
   
      PUBLIC &ThisHole., &ThisT.,&ThisL., &ThisB.,&ThisR.
      &ThisT.    = t
      &ThisL.    = l
      &ThisB.    = b
      &ThisR.    = r
      &ThisHole. = SAVESCREEN(t,l,b,r)
   ENDI

   *=== Set screen attribute and pop box
   SETCOLOR(attr)
   @ &ThisT., &ThisL., &ThisB., &ThisR. BOX frame
   SETCOLOR(StartColor)

   DO WHIL .T.
      &LastChc. = ACHOICE(&ThisT.+1,&ThisL.+1,;
                  &ThisB.-1,&ThisR.-1,&ChcArray.,.T.,0,&LastChc.)

      *=== This IF won't allow user to ESC without making VALID choice
      IF !EMPTY(&LastChc.)
         *===
         EXIT
         *===
      ENDI

   ENDD

   
   *=== 
   *    The RETURN is a string which combines the unique character passed
   *    in with the actual contents of the element chosen.  This string
   *    is converted to Upper case, spaces are stripped, and it is
   *    truncated to 10 characters (if necessary).
   *---
RETURN(UPPER(LEFT(char + ALLTRIM(STRTRAN(&ChcArray[&LastChc.]," ")),10)))
*=== EOF MakeChoice

*===
* RlsChoice()
* For purposes of hygiene, this will release the PUBLICS created by
*    MAKECHOICE().
*
* PARAMETERS
*    Just pass in the unique character you used with MAKECHOICE()
*===
FUNCTION RlsChoice
   PARAMETERS char
   ChcArray = char + "Array"
   LastChc  = char + "LastChc"
   ThisT    = char + "T"
   ThisL    = char + "L"
   ThisB    = char + "B"
   ThisR    = char + "R"
   ThisHole = char + "Hole"

   RELEASE &LastChc., &ThisT., &ThisL., &ThisB., &ThisR., ;
   &ThisHole, &ChcArray.

RETURN(.T.)
*=== EOFunction RlsChoice
*
*===
* ChrCnt ::= simulate Tom Rettig's CHRCOUNT.  Pass in a 
*            single character and a string.  It will return a number
*            for the number of occurences of the character.  It is case
*            sensitive: "A" != "a".
*
*            EXAMPLE: num = CHRCNT("~","Add~Find~Quit~")
*            ? num              && 3
*---
FUNCTION ChrCnt
   PARAMETER chr, str
   PRIVATE cnt
   cnt = 0
   FOR i = 1 TO LEN(str)
      cnt = cnt + IIF(SUBS(str,i,1) = chr,1,0)
   NEXT
RETURN(cnt)
*=== EOFunction ChrCnt




