*
*  CHATTER.PRG  
*  Novell Network Multi-User Chat Utility.
*  **************************************************************
*  Version 1.0 - December 13, 1990
*  David L. West *	Of Course Systems, Inc.
*  P.O. Box 1588, Tijeras, NM 87059
*
*  Requires NetLib and FUNCky to compile. Example compile and link:
*  CLIPPPER chatter
*  BLINKER FI chatter,funcky LIB funcky,clipper,extend SEARCH nlext87,nl187
*  
*  Automatically adapts to 43 or 50 line modes, or ALT 2/4/5
*  switches between 25/43/50 on EGA/VGA monitors.
*  
*  Message length limited to 125 bytes each, but once you type in
*  125 chars, a message is sent automatically and you can continue
*  typing.
*
*  CTRL-G is displayed as !, but rings bell as you'd expect.
*  
*  There is no way to scroll back messages that have gone off the
*  screen. Likewise, changing the screen mode clears the screen, so
*  be careful of when you do that.
*  
*  Last but certainly not least: THIS IS NOVELL SPECIFIC CODE!!
*  
*  Feel free to incorporate this code into your own programs. If
*  your users really enjoy it (mine did), feel free to send a few
*  bucks to the above address. I'll keep your name on a list and
*  provide you with any improvements I make.
*
*  Dave West
*
PARAMETERS mflags
mflags = iif(PCOUNT()#0,UPPER(mflags),'')

* Initialize variables
* **************************************************************
n_ready() && Initialize NetLib
PRIVATE inbox[2],mstr,MaxRow,MaxCol,mstrwid,msgrow,me,;
mcnt,mKey,mline,msg,mxx,muser,mx,my,mz,initflag,mcount,;
mhandle
mstr=''

IF IsColor() .AND. !('MONO'$mflags)
	* For color screens
	mback=27	 && Bright white on blue
	mdim= 23	 && White on blue
	mhigh=79   && Bright white on red
ELSE  
	* For monochrome screens
	mback=15   && Bright white on black
	mdim=7     && White on black
	mhigh=112  && Black on white
ENDIF  

initflag = .T.
mhandle=0

* Main loop starts here. EXIT this loop to exit program.
* **************************************************************
DO WHILE .T.

	* If the initialization flag is set, perform the video screen
	* init routines. This lets us toggle video modes more easily.
	* **************************************************************
	IF initflag
		STORE .F. TO initflag    
		MaxRow=MaxRow()
		MaxCol=MaxCol()
		msgrow=2
		mstrwid=MaxCol-15-1
		me = n_stanum()
		SET COLOR TO n/w

		* Draw the screen. Use FUNCky functions for speed.
		* **************************************************************
		CsrOff()
		cls(mback)
		Print(0,0,untrim('CHATTER 1.0 - Of Course Systems, PO Box 1588, Tijeras NM 87059',MaxCol+1),mhigh)
		STORE MaxRow-4 TO mb
		Box(1,0,mb,MaxCol-15,'',mback) 
		Box(mb+1,0,MaxRow-1,MaxCol-15,'',mback) 
		Box(1,MaxCol-15+1,MaxRow-1,MaxCol,'',mback)                                               
		Print(1,2,' Incoming ',mback)
		Print(mb+1,2,' Outgoing ',mback)
		Print(1,MaxCol-15+3,' Users ',mback)
		Print(MaxRow,0,untrim('Type a message and press ENTER. Press ESC to quit.',MaxCol+1),mhigh)
		mcount = 2000
	ENDIF

	* Main loop actually starts processing here
	* **************************************************************
	
	* Display a list of logged-in users, highlighted the ones that
	* we can Connect with. During this loop, watch for a keypress
	* and drop out of it if one occurs.
	* **************************************************************
	IF mcount = 2000 
		mcount = 0
		mrow=2
		mcnt=0
		mxx=n_stamax()      && How many stations are there?
		FOR my=1 TO 99    
			mKey=INKEY()      && Check for a pending key
			muser=n_whoami(my)&& Who's hooked up to this station?
			IF !EMPTY(muser)  && If somebody's hooked up,
				*               && print their name in bold if they
				*               && are in CHATTER.
				Print(mrow,MaxCol-15+2,untrim(muser,13),iif(n_connect(my)=3,mback,mdim))
				mrow=mrow+1
				mcnt=mcnt+1
				* If we have got all the users OR a keystroke is pending,
				* exit this loop.
				IF mcnt=mxx .OR. mKey#0
					EXIT
				ENDIF
			ELSE
				* Check for a pending keystroke
				IF mKey#0
					EXIT
				ENDIF
			ENDIF
		NEXT    
		* Clear the remainder of the box using the scroll function
		SCROLL(mrow,(MaxCol-15+1)+1,MaxRow-2,MaxCol-1,0,mback)                                               
	ENDIF
	mcount = mcount + 1
	
	* If a key isn't pending, check for incoming messages
	* **************************************************************
	IF mKey = 0
		n_recv(inbox)  && Receive any pending messages
		IF inbox[1]# 0 && If there was one, 
			* Add the sender's name to the message
			msg = "<"+n_whoami(inbox[1])+"> "+TRIM(inbox[2])
			* Print the message
			FOR mx=1 TO MLCOUNT(msg,mstrwid,2)
				mline=MEMOLINE(msg,mstrwid,mx,2)
				* Scroll the screen if necesary
				IF msgrow=mb
					msgrow=mb-1          
					SCROLL(2,1,mb-1,(MaxCol-15)-1,1,mback)
				ENDIF     
				
				* Ring the bell if the string contains a bell character
				* and display exclamation points instead of bells.
				?? REPLICATE(CHR(7),chrcount(CHR(7),mline))
				mline=ChrSwap(mline,CHR(7),'!')
				
				* Print the line
				Print(msgrow,1,mline,iif(inbox[1]=me,mdim,mback))
				msgrow=msgrow+1
			NEXT
			
			* If the log file is turned on, write the message to the log file.
			* **************************************************************
			IF mhandle > 0
				fwriteline(mhandle,msg)
			ENDIF      

		ENDIF
	ENDIF
	
	* If a key isn't pending, check the buffer to try and get one
	* **************************************************************
	mKey = iif(mKey=0,INKEY(),mKey)
	
	* Process the keystroke
	* **************************************************************
	DO CASE      
	CASE mKey=13 .OR. LEN(mstr)=125
		
		* Enter triggers the sending of the message. This also happens
		* if the messages gets to be 125 bytes
		* **************************************************************    
		PRIVATE sendto[n_stamax()+1]
		sendto[1]=LEN(sendto)-1
		FOR mx=1 TO sendto[1]
			sendto[mx+1]=mx
		NEXT
		n_send(sendto,mstr)
		mstr=''
		
	CASE mKey=8
		
		* Backspace hacks off a character.
		* **************************************************************    
		mstr=SUBSTR(mstr,1,LEN(mstr)-1)
		
	CASE mKey=27
		
		* Escape gets out of the program.
		* **************************************************************    
		EXIT
		
	CASE mKey = 294
		
		* ALT-L toggles the log file. It get's created in the current
		* directory. Error handling is minimal. Note that there is nothing
		* keeping one user from obliterating the log file, so it's best
		* not to tell end users about the log function.
		* **************************************************************    
		IF mhandle = 0
			mfile = UNTRIM(CURDIR()+'\'+TRIM(SUBSTR(n_whoami(),1,8))+'.LOG',50)
			mfile = TRIM(WinGet('Enter log file name: ',mfile))
			mhandle=FCREATE(mfile,0)
			tone(500,1)
		ELSE
			FCLOSE(mhandle)
			mhandle=0      
			mtemp='CLOSED LOG FILE '+mfile+'.'      
			tone(500,1)
		ENDIF                                     
		
	CASE mKey=377 .OR. mKey=379 .OR. mKey=380    
		
		* ALT 2,4,or 5 sets to 25, 43, or 50 line mode and sets the flag
		* that will cause the screen to be re-drawn.
		* **************************************************************
		DO CASE
		CASE mKey=377 && ALT-2
			setmode(3)
		CASE mKey=379 && ALT-4
			setmode(43)
		CASE mKey=380 && ALT-5
			setmode(50)
		ENDCASE
		STORE .T. TO initflag
		LOOP
		
	CASE mKey#0 .AND. (IsPrint(CHR(mKey)) .OR. mKey=7)
		
		* Any other printable key just gets added to the message. 
		* **************************************************************      
		STORE mstr+CHR(mKey) TO mstr   
		
	ENDCASE  
	
	* Show the current message string and set the pending input key
	* flag back to zero. Emulate horizontal scrolling by display a
	* substring if necesary.
	* **************************************************************      
	mtemp=ChrSwap(mstr,CHR(7),'!')
	IF LEN(mtemp) >= mstrwid
		STORE SUBSTR(mtemp,(LEN(mtemp)-mstrwid)+1,mstrwid) TO mtemp
	ENDIF
	Print(MaxRow-2,1,untrim(mtemp,mstrwid),mdim)
	mKey = 0
	
ENDDO

IF mhandle # 0
	FCLOSE(mhandle)
ENDIF

* Disconnect from all other stations 
* **************************************************************      
FOR mx=1 TO 99
	n_discon(mx)
NEXT
SET COLOR TO 

* Display the Of Course logo and quit to DOS
* **************************************************************      
CLEAR
Print(0,0,"                         Developed by David L. West ")
Print(1,0,"               Of Course Systems, P.O. Box 1588 Tijeras, NM 87059")
offset=0
mt=3
ml=offset
mr=43
mb=20
mx=IsColor()
SetColor(iif(mx,'W+/G','W+/N'))
Print(3,offset, "Nantucket                        Clipper")
SetColor(iif( mx, "B/G", "W/N" ))
Print(4,offset, "")
Print(5,offset, "         Professional Software")
Print(6,offset, "")
Print(7,offset, "        Utilizing Clipper")
Print(8,offset, "")
Print(9,offset, "          Technology")
Print(10,offset,"")
Print(11,offset,"               ")
Print(12,offset,"")
Print(13,offset,"          ")
Print(14,offset,"")
Print(15,offset,"     ")
Print(16,offset,"")
Print(17,offset,"")
Print(18,offset,"")
Print(19,offset,"")
SetColor(iif(mx,'W+/G','W+/N'))
Print(20,offset,"                      (R) Nantucket Corp")
FOR mx=1 TO 40
	Shift(mt,ml,mb,mr,1,0)
	ml=ml+1
	mr=mr+1
NEXT
SET COLOR TO
@ 21,0
CsrOn()
QUIT

FUNCTION WinGet
PARAMETERS mstring,mvar
PRIVATE mtemp
mtemp=SaveScreen(0,0,MaxRow,MaxCol)
setattr(1,0,MaxRow-1,MaxCol,mdim)
Box(MaxRow-4,2,MaxRow-2,MaxCol-2,'',mback)
Print(MaxRow-3,3,mstring,mdim)
@ MaxRow-3,3+LEN(mstring)+1 GET mvar PICTURE "@K!"
CsrOn()
READ
CsrOff()
RestScreen(mtemp)
RETURN mvar

