; CHAR.ASM ͸
; CLIPPER 87 keyboard status program                              
; Returns TRUE if character in keyboard buffer else returns FALSE 
; Author:Ric Seymour   08/22/88                                   
; OFFICE: (713) 270-6565 Ext. 1833                                
; CLIPPER register/segment saves are not used since no critical   
;         registers are destroyed in this function                
; Registers destroyed ax, bx                                      
;;

PUBLIC KeyReady                  ;Declared as public so CLIPPER
                                 ;will recognize it

EXTRN   __RETL:FAR               ;CLIPPER 87 return logical

_PROG SEGMENT 'CODE'
      ASSUME cs:_prog

KeyReady   PROC    FAR
           MOV     ah,0bh        ;keyboard buffer status subfunction
           INT     21h           ;DOS Function Dispatcher interrupt
           XOR     bx,bx         ;set bx to 00h
           CMP     al,0ffh       ;compare returned code in al to 0ffh
           JNE     Ret_Key       ;if below 0ffh goto ret_key
           MOV     bx,01h        ;put 01h in bx
Ret_Key:   PUSH    bx            ;put bx on the stack
           CALL    __RETL        ;call CLIPPER return function
           POP     bx            ;restore bx
           RET                   ;return
KeyReady ENDP                    ;end of proc
_prog    ENDS                    ;segment end
         END                     ;end of file
