// Program...: Center.prg
// Author....: Gerald Barber
// Date......: June 5, 1993 04:14 pm; Last Updated June 13, 1993 01:13 pm
// Notice....: Copyright 1993, Gerald Barber
// Notes.....: Part of CalcFxn.Lib
//             Centers a Child Window within its Parent
//             May be used to center a dialog box within the parent window
//             by calling Center(hWnd) in response to the WM_INITDIALOG
//             windows message.
//             Part of CalcFxn.Lib
//             Requires Clip4Win v 1.2 or greater
// Parameters: hWnd -> handle to the Child Window


#define WIN_WANT_ALL

#include "windows.ch"

function Center(hWnd)
Local hWndParent              // handle to the Parent Window
Local aChild_[4]              // Screen Coordinates of Child Window
Local iCWidth                 // Width of Child Window in Pixels
Local iCHeight                // Height of Child Window in Pixels
Local aParent_[4]             // Logical Coordinates of Parent Window
Local aPoint_[2]              // Multiple Uses

// Obtain upper left and lower right coordinates of the child window
// in screen coordinates and determine its height and width.
aChild_  := GetWindowRect(hWnd)
iCWidth  := aChild_[3] - aChild_[1]
iCHeight := aChild_[4] - aChild_[2]

// Obtain handle for parent window
hWndParent := GetWindow(hWnd,GW_OWNER)

// Obtain client rectangle of the parent window in logical coordinates
aParent_   := GetClientRect(hWndParent)

// Set aPoint_ equal to the center of the Client Rectangle
// of the parent window in logical coordinates
aPoint_    := {(aParent_[3]/2),(aParent_[4]/2)}

// Convert aPoint_ from logical to screen coordinates
ClienttoScreen(hWndParent,aPoint_)

// Offset aPoint_ by half the height and width of the child window
// still in screen coordinates
aPoint_[1] -= (iCWidth  / 2)
aPoint_[2] -= (iCHeight / 2)

// 06/13/93 Modified GB - Not Pretty but it works
// Insure that new upper left corner falls within client area of
// Parent Window

// Convert Point to logical coordinates or parent window
ScreentoClient(hWndParent,aPoint_)
// Make sure logical coordinates >= 0
aPoint_[1] := max(0, aPoint_[1])
aPoint_[2] := max(0, aPoint_[2])
// Convert Point back to screen coordinates
ClienttoScreen(hWndParent,aPoint_)

// Move the child window to the new screen coordinates.
// aPoint_ := the new upper left corner of the child window
// Height and width of the child window remain unchanged.
MoveWindow(hWnd,aPoint_[1],aPoint_[2],iCWidth,iCHeight,.F.)
return nil

// GetWindowRect calls the appropriate windows function in the
// default windows USER.EXE DLL Library to return the upper left and
// lower right screen coordinates of the hWnd passed to it.
function GetWindowRect(hWnd)
local hLib := LoadLibrary("USER.EXE")
local cGWR := GetProcAddress(hLib, "GetWindowRect", ;
                             "Pascal", "void", "HWND, string")
local cBuf := space(8)
CallDLL(cGWR, hWnd, @cBuf)
FreeLibrary(hLib)
return bin2a(cBuf, "int[4]")
