* CLIPPER File Erase utility.  Highlite the file in the window, press del key.
*  by Tim L. Shafer  May 1989
*     1853 W. Walnut  Apt A
*     Garland, TX 75042-6778
PUBLIC  its_ok, arequest, del_file, mNRMLCLR, CORNER, Aaction, mROW, Fnames
PUBLIC  an5, an6
mROW    = ROW() - 1
an5     = 1                &&  Keep track of where the cursor is & return
an6     = 1                &&  there after deleting a file.
mNRMLCLR = SETCOLOR()
set color to BG/N, W+/R+
CORNER = SAVESCREEN(0, 66, 15, 80)
@ 0, 66, 15, 80 BOX 'Ŀ '
its_ok = .T.
DO WHILE its_ok

   DECLARE Fnames[ADIR("*.*")]      &&  I DO declare!
   Fdir('*.*', Fnames)

   ACHOICE(1, 67, 14, 78, Fnames, .T., 'AFunct', an5, an6)

ENDDO
set color to (mNRMLCLR)
RESTSCREEN(0, 66, 15, 80, CORNER)
@ mROW, 0 say ''
QUIT

FUNCTION AFunct && this function controls action taken when any key is pressed.
PARAMETERS  amode, element, aposit

DO CASE
   CASE  amode = 0
      @  0, 68 say ''
      @ 15, 68 say ''
      arequest = 2

   CASE  amode = 1
      @ 0, 68 say 'Top of List'
      arequest = 2

   CASE  amode = 2
      @ 15, 68 say 'End of List'
      arequest = 2

   CASE  amode = 3            && a non-directional key has been pressed.

      DO CASE
         CASE lastkey() = 27  && press <ESC> to exit this utility program
            arequest = 0      && 0 terminates the ACHOICE function
            its_ok    = .F.

         CASE lastkey() = 13
            KEYBOARD chr(24)  && go down one element when <NEWLINE> is pressed
            arequest = 2

         CASE lastkey() = 7         && delete key
            del_file = Fnames[element]
            DELETE FILE &del_file
            an5 = element           && remove the file from the window
            an6 = aposit            && display/refill window with the names.
            arequest = 0

         CASE lastkey() > 47 .AND. lastkey() < 123
            arequest = 3      &&  a letter was pressed; find file beginning
                              &&  with that letter.

         OTHERWISE
            arequest = 2      &&  2 tells ACHOICE function to take no action

      ENDCASE

   ENDCASE

RETURN arequest


FUNCTION Fdir  &&  prepare a sorted array of filenames that match a File type

PARAMETERS F_type, Fnames

   * begin with an empty array
   afill(Fnames, "")

   * fill the array with filenames
   adir(F_type, Fnames)

   * sort the array
   array_sort(Fnames)

RETURN 0


FUNCTION array_sort  && sort the contiguous full elements before the first
                     && null string

PARAMETERS Fnames

   * sort only the full elements
   asort(Fnames, 1, afull(Fnames))

RETURN 0


FUNCTION afull && Find the number of contiguous full elements before the first
               && null string

PARAMETERS array
PRIVATE i        && cute, huh?

   * perform exact search
   SET EXACT ON

   * search for null string
   i = ascan(Fnames, "")

   * back to normal
   SET EXACT OFF

   IF i = 0
      * no null strings means completely full
      i = LEN(Fnames)

   ELSE
      * element of first null string - 1
      i = i - 1

   ENDIF

RETURN i
